#!/usr/bin/env bash

# ---------------------------------------------
# Licensed Materials - Property of IBM
# (C) Copyright IBM Corporation 2021
# ---------------------------------------------

# Created by Huang, Fuguo (aka ken) on 19.2.2021.

source ./localTempPodman.sh
source ./enableSecurity.sh
source ./enableTls.sh

source ./imageHelper.sh
#source ./.configuration


TA_LOCAL_CONFIG=./.configuration
TA_LOCAL_CONFIG_DEV=./.configuration.dev
source ./helper.sh
sourceConfig

function startDockerCompose {

  # first argument, set to true if you want to pull docker images
	shouldPullImages=$1

	# enable security environment, if conditions are met.
	importSecurityEnv
	importNeo4jPassEnv

	# translate into lower case
	TA_AUTH_ENABLE_TLS_lower_case=$(echo "$TA_AUTH_ENABLE_TLS" | tr '[:upper:]' '[:lower:]')

	if [[ $TA_AUTH_ENABLE_TLS_lower_case == 'true' ]]; then
		enableTls
		updateProtocol https
		updateNeo4JEnv true bolt+ssc OPTIONAL
	else
		# set env vars to non-TLS ports
		updateProtocol http
		updateNeo4JEnv false bolt DISABLED
	fi

	# replace placeholders in the env file to real values
	updateLibertyEnv
	updateUiEnv

  	if [[ $shouldPullImages == 'true' ]]; then
  		if [ -f "$TA_LOCAL_CONFIG_DEV" ]; then
    		log "$TA_LOCAL_CONFIG_DEV is provided. Logging into staging so we can use the dev file."
    		./.login.dev.sh $TA_LOCAL_TEMP_PODMAN_INSTALL
 		fi
    	imagePull
  	fi
	# set couch db passwords
	setDbPasswords

	# set API Key
	setApiKey

	# these 2 environment variables are set  in function importSecurityEnv
	# run setAesKeyIV, only when UI auth are turned on
	if [[ ${TA_AUTH_UI_DISABLED} != 'true' ]]; then
		# set AES key and IV
		setAesKeyIV
	fi

	if [ ! -d "../data" ]; then
		mkdir ../data
		chmod ugo+rwx ../data
	fi

	if [ ! -d "../graph_data" ]; then
		mkdir ../graph_data
		chmod ugo+rwx ../graph_data
	fi


	#echo "TA_AUTH_LIBERTY_DISABLED: $TA_AUTH_LIBERTY_DISABLED"
	#echo "TA_AUTH_IDENTITY_REQUEST_ENDPOINT: $TA_AUTH_IDENTITY_REQUEST_ENDPOINT"
	#echo "TA_AUTH_TOKEN_VERIFICATION_ENDPOINT $TA_AUTH_TOKEN_VERIFICATION_ENDPOINT"
	#echo "TA_AUTH_IDENTITY_REQUEST_ENDPOINT: $TA_AUTH_IDENTITY_REQUEST_ENDPOINT"
	#echo "TA_AUTH_IDENTITY_REQUEST_ENDPOINT_PATH: $TA_AUTH_IDENTITY_REQUEST_ENDPOINT_PATH"
	#echo "TA_AUTH_IDENTITY_REQUEST_ENDPOINT_SCOPE: $TA_AUTH_IDENTITY_REQUEST_ENDPOINT_SCOPE"
	#echo "TA_AUTH_CALLBACK_STATE_PREFIX_PADDING: $TA_AUTH_CALLBACK_STATE_PREFIX_PADDING"

	#echo "TA_AUTH_TOKEN_REQUEST_ENDPOINT: $TA_AUTH_TOKEN_REQUEST_ENDPOINT"
	#echo "TA_AUTH_TOKEN_REQUEST_ENDPOINT_PATH: $TA_AUTH_TOKEN_REQUEST_ENDPOINT_PATH"

	#echo "TA_AUTH_TOKEN_VERIFICATION_ENDPOINT: $TA_AUTH_TOKEN_VERIFICATION_ENDPOINT"
	#echo "TA_AUTH_TOKEN_VERIFICATION_ENDPOINT_PATH: $TA_AUTH_TOKEN_VERIFICATION_ENDPOINT_PATH"

	#echo "TA_AUTH_OIDC_CALLBACK_URI: $TA_AUTH_OIDC_CALLBACK_URI"
	#echo "TA_PUBLIC_ACCESSIBLE_API_SERVER_URL: $TA_PUBLIC_ACCESSIBLE_API_SERVER_URL"
	#echo "TA_LOCAL_API_SERVER: $TA_LOCAL_API_SERVER"

	#echo "TA_AUTH_OIDC_CALLBACK_URI: $TA_AUTH_OIDC_CALLBACK_URI"
	#echo "TA_AUTH_OIDC_CLIENT_ID: $TA_AUTH_OIDC_CLIENT_ID"
	#echo "TA_AUTH_OIDC_CLIENT_SECRET: $TA_AUTH_OIDC_CLIENT_SECRET"
	#echo "TA_LOCAL_INTERNAL_SERVER_PORT: $TA_LOCAL_INTERNAL_SERVER_PORT"
	#echo "TA_LOCAL_INTERNAL_UI_PORT: $TA_LOCAL_INTERNAL_UI_PORT"
	#echo "TA_LOCAL_INTERNAL_DB_PORT: $TA_LOCAL_INTERNAL_DB_PORT"

#	echo "TA_LOCAL_COUCHDB_PASSWORD: $TA_LOCAL_COUCHDB_PASSWORD"
#	echo "TA_LOCAL_DB_PASSWORD: $TA_LOCAL_DB_PASSWORD"
#	echo "TA_LOCAL_TA_DB_NONADMIN_PASSWORD: $TA_LOCAL_TA_DB_NONADMIN_PASSWORD"

	#echo "TA_API_KEY: $TA_API_KEY"
	#echo "TA_AES_IV: $TA_AES_IV"
	#echo "TA_AES_KEY: $TA_AES_KEY"

#	echo "TA_LOCAL_NEO4J_PASSWORD: $TA_LOCAL_NEO4J_PASSWORD"
#	echo "TA_LOCAL_NEO4J_USER: $TA_LOCAL_NEO4J_USER"
#	echo "NEO4J_USER: $NEO4J_USER"

	# this is the way to passing in the environments into
	# overwrite TA_LOCAL_TA_AUTH_OIDC_CALLBACK_URI
	#TA_LOCAL_TA_AUTH_OIDC_CALLBACK_URI=https://localhost:3443/auth/callback \
	#TA_LOCAL_TA_AUTH_OIDC_CALLBACK_URI=http://localhost:3000/auth/callback \
NOT_SET_STRING="NOT_SET"
cat >> .env <<-EOF
TA_AUTH_UI_DISABLED=${TA_AUTH_UI_DISABLED}
TA_AUTH_LIBERTY_DISABLED=${TA_AUTH_LIBERTY_DISABLED}
TA_AUTH_IDENTITY_REQUEST_ENDPOINT=${TA_AUTH_IDENTITY_REQUEST_ENDPOINT}
TA_AUTH_IDENTITY_REQUEST_ENDPOINT_PATH=${TA_AUTH_IDENTITY_REQUEST_ENDPOINT_PATH}
TA_AUTH_IDENTITY_REQUEST_ENDPOINT_SCOPE=${TA_AUTH_IDENTITY_REQUEST_ENDPOINT_SCOPE}
TA_AUTH_CALLBACK_STATE_PREFIX_PADDING=${TA_AUTH_CALLBACK_STATE_PREFIX_PADDING}
TA_AUTH_TOKEN_REQUEST_ENDPOINT=${TA_AUTH_TOKEN_REQUEST_ENDPOINT}
TA_AUTH_TOKEN_REQUEST_ENDPOINT_PATH=${TA_AUTH_TOKEN_REQUEST_ENDPOINT_PATH}
TA_AUTH_TOKEN_VERIFICATION_ENDPOINT=${TA_AUTH_TOKEN_VERIFICATION_ENDPOINT}
TA_AUTH_TOKEN_VERIFICATION_ENDPOINT_PATH=${TA_AUTH_TOKEN_VERIFICATION_ENDPOINT_PATH}
TA_OCP_API_ENDPOINT=${TA_OCP_API_ENDPOINT}
TA_SERVER_PORT=${TA_LOCAL_INTERNAL_SERVER_PORT}
TA_UI_PORT=${TA_LOCAL_INTERNAL_UI_PORT}
TA_DB_PORT=${TA_LOCAL_INTERNAL_DB_PORT}
TA_REC_AUTO_GENERATE=false
EOF


# TA_READ_VALUE_FROM_ENV_VAR determine whether reading the sensitive value from .env or podman secret
# If TA_READ_VALUE_FROM_ENV_VAR is empty or false, and user is using podman, then create podman secret for the data
# Otherwise, add the data to .env file
ta_read_value_from_env_var=`grep TA_READ_VALUE_FROM_ENV_VAR .env | cut -d'=' -f 2- | awk '!/^[[:space:]]*$/'`
if [[ -z "${ta_read_value_from_env_var}" || "${ta_read_value_from_env_var}" == false ]] && [[ "${TA_LOCAL_TEMP_PODMAN_INSTALL}" == true ]]; then
	source ./secretHelper.sh
	checkAndCreateTaSecret
else
	cat >> .env <<-EOF
	COUCHDB_PASSWORD=$TA_LOCAL_COUCHDB_PASSWORD
	TA_DB_PASSWORD=$TA_LOCAL_DB_PASSWORD
	TA_DB_NONADMIN_PASSWORD=$TA_LOCAL_TA_DB_NONADMIN_PASSWORD
	TA_AUTH_OIDC_CLIENT_ID=$TA_AUTH_OIDC_CLIENT_ID
	TA_AUTH_OIDC_CLIENT_SECRET=$TA_AUTH_OIDC_CLIENT_SECRET
	TA_API_KEY=$TA_API_KEY
	TA_AES_IV=$TA_AES_IV
	TA_AES_KEY=$TA_AES_KEY
	TA_PRIVATE_KEY=$TA_PRIVATE_KEY
	TA_PUBLIC_KEY=$TA_PUBLIC_KEY
	NEO4J_AUTH=neo4j/${TA_LOCAL_NEO4J_PASSWORD}
	NEO4J_USER=neo4j
	NEO4J_PASS=${TA_LOCAL_NEO4J_PASSWORD}
	EOF
fi

if [[ $TA_LOCAL_ROUTE_HOST == true ]] ; then
	routeViaHost
else
	run_with_spinner "imageRun" "Running Images" "Running Images" "STARTED"
fi

}


function setProtocol(){
	# set the protocol, reset the protocol, as startDockerCompose set to something else
	PROTOCOL=http
	# translate into lower case
	TA_AUTH_ENABLE_TLS_lower_case=$(echo "$TA_AUTH_ENABLE_TLS" | tr '[:upper:]' '[:lower:]')
	if [[ $TA_AUTH_ENABLE_TLS_lower_case == 'true' ]]; then
		PROTOCOL=https
	fi
}