#!/usr/bin/env bash
# ---------------------------------------------
# Licensed Materials - Property of IBM
# (C) Copyright IBM Corporation 2025
# ---------------------------------------------



basic_input_validation(){
    CHOICE=$1
    MIN_CHOICE=$2
    MAX_CHOICE=$3

    # Loop until the input is a valid number between $2 and $3 or q|Q to quit
    while true; do
        # Check if the user wants to quit
        if [[ "$CHOICE" == "q" || "$CHOICE" == "Q" ]]; then
            to_terminal "User cancelled input."
            exit 0
        fi

        # Validate numeric input between 1 and 10
        if [[ "$CHOICE" =~ ^[0-9]+$ ]]; then
            if [ "$CHOICE" -ge $MIN_CHOICE ] && [ "$CHOICE" -le $MAX_CHOICE ]; then
                break
            fi
        fi

        to_terminal "Invalid input. Please enter a number between $MIN_CHOICE and $MAX_CHOICE (or 'q' to quit): "
        read CHOICE

    done
    # while ! [[  "$CHOICE" =~ ^[0-9]+$ ]] || [ "$CHOICE" -lt $MIN_CHOICE ] || [ "$CHOICE" -gt $MAX_CHOICE ]; do
    #     to_terminal "Invalid input. Please enter a number between $MIN_CHOICE and $MAX_CHOICE: "
    #     read CHOICE
    # done
}