#!/usr/bin/env bash

# ---------------------------------------------
# Licensed Materials - Property of IBM
# (C) Copyright IBM Corporation 2021
# ---------------------------------------------

#run scripts at relative path
scriptdir="$(dirname "$0")"
cd "$scriptdir"
TA_LOCAL_CONFIG=./.configuration
TA_LOCAL_CONFIG_DEV=./.configuration.dev

source ./logging.sh
source ./spinner.sh
source ./helper.sh
sourceConfig
source ./localTempPodman.sh

trap - EXIT SIGINT

# echo "Have you already saved the ${PRODUCT_NAME} images to a tarball (y/n)?"
# read answer
# echo ""

# header "Have you already saved the ${PRODUCT_NAME} images to a tarball (y/n)?"
prompt_and_read "\tHave you already saved the ${PRODUCT_NAME} images to a tarball (y/n)?" ANSWER

if [ $ANSWER == 'y' ] || [ $ANSWER == 'Y' ]; then

	while :; do
		prompt_and_read "\tEnter filename location (eg, /root/$SHORT_NAME/$SHORT_NAME-images.tar.gz)" LOCATION
		location="${LOCATION:=/root/$SHORT_NAME/$SHORT_NAME-images.tar.gz}"

		if ! [[ "${location:0:1}" == / || "${location:0:2}" == ~[/a-z] ]]; then
			LOCATION=$PWD/../$location
		fi

		if [[ -f $LOCATION ]] && [[ $LOCATION = *.gz ]]; then
			break
		else
			to_terminal "File ($LOCATION) does not exist. Try again."
		fi
	done
	run_with_spinner "gunzip -c $LOCATION | docker load" "Loading the ${PRODUCT_NAME} images" "Loading"

	to_terminal "Finished uploading the ${PRODUCT_NAME} images"
	header "Starting ${PRODUCT_NAME}"
	./installLocalAirGapped.sh
else

	header "How to create the $SHORT_NAME-images.tar.gz file."
	to_terminal "On a system that has docker or podman installed and has internet connectivity, pull the images."
	to_terminal "Then, save the images to a gzip'd tar ball."
	to_terminal "\n\t\t%s\n" "docker / podman pull $TA_LOCAL_CONFIG_COUCH_IMAGE"
	to_terminal "\t\t%s\n" "docker / podman pull $TA_LOCAL_CONFIG_UI_IMAGE"
	to_terminal "\t\t%s\n" "docker / podman pull $TA_LOCAL_CONFIG_SERVER_IMAGE" 
    to_terminal "\t\t%s\n\n" "docker / podman pull $TA_LOCAL_CONFIG_NEO4J_IMAGE"
	to_terminal "If you using docker, run the command below"
	to_terminal "\n\t\t%s\n\n" "docker save $TA_LOCAL_CONFIG_COUCH_IMAGE $TA_LOCAL_CONFIG_UI_IMAGE $TA_LOCAL_CONFIG_SERVER_IMAGE $TA_LOCAL_CONFIG_NEO4J_IMAGE | gzip > $SHORT_NAME-images.tar.gz"
	to_terminal "If you using podman, run the command below"
	to_terminal "\n\t\t%s\n" "podman save -m $TA_LOCAL_CONFIG_COUCH_IMAGE $TA_LOCAL_CONFIG_UI_IMAGE $TA_LOCAL_CONFIG_SERVER_IMAGE $TA_LOCAL_CONFIG_NEO4J_IMAGE k8s.gcr.io/pause:3.5 | gzip > $SHORT_NAME-images.tar.gz"

	header "On the Air Gap system, do the following steps:"
	to_terminal "Edit the file /usr/share/containers/containers.conf"
	to_terminal "Search for infra_image"
	to_terminal "uncomment this and add the following"
	to_terminal "infra_image = \"k8s.gcr.io/pause:3.5\""
	to_terminal "Save the file"

	to_terminal "Transfer the file to the target server and run the launch script."
	to_terminal "Choose the option to work in an air gapped environment and you will be prompted to enter the location of the tarball containing the images."

	rm -rf ../.license_accepted

fi
