      ******************************************************************
      **                                                              **
      **                      IBM MQ for Windows                      **
      **                                                              **
      **  FILE NAME:      CMQMD2L                                     **
      **                                                              **
      **  DESCRIPTION:    MQMD2 Structure -- Version-2 Message        **
      **                  Descriptor                                  **
      **                                                              **
      ******************************************************************
      **  <copyright                                                  **
      **  notice="lm-source-program"                                  **
      **  pids="5724-H72,5655-R36,5724-L26"                           **
      **  years="1993,2025"                                           **
      **  crc="1616507131" >                                          **
      **  Licensed Materials - Property of IBM                        **
      **                                                              **
      **  5724-H72                                                    **
      **                                                              **
      **  (C) Copyright IBM Corp. 1993, 2025 All Rights Reserved.     **
      **                                                              **
      **  US Government Users Restricted Rights - Use, duplication or **
      **  disclosure restricted by GSA ADP Schedule Contract with     **
      **  IBM Corp.                                                   **
      **  </copyright>                                                **
      ******************************************************************
      **                                                              **
      **  FUNCTION:       This file declares the structure MQMD2,     **
      **                  which is used by the main MQI.              **
      **                                                              **
      **  PROCESSOR:      COBOL                                       **
      **                                                              **
      ******************************************************************

      ******************************************************************
      ** <BEGIN_BUILDINFO>                                            **
      ** Generated on:  03/10/2025, 11:45                             **
      ** Build Level:   p944-L251003                                  **
      ** Build Type:    Production                                    **
      ** Pointer Size:  32 Bit                                        **
      ** Source File:                                                 **
      ** CMQMD2L                                                      **
      ** <END_BUILDINFO>                                              **
      ******************************************************************

      ** MQMD2 structure
       10  MQMD.
      ** Structure identifier
       15  MQMD-STRUCID PIC X(4).
      ** Structure version number
       15  MQMD-VERSION PIC S9(9) BINARY.
      ** Options for report messages
       15  MQMD-REPORT PIC S9(9) BINARY.
      ** Message type
       15  MQMD-MSGTYPE PIC S9(9) BINARY.
      ** Message lifetime
       15  MQMD-EXPIRY PIC S9(9) BINARY.
      ** Feedback or reason code
       15  MQMD-FEEDBACK PIC S9(9) BINARY.
      ** Numeric encoding of message data
       15  MQMD-ENCODING PIC S9(9) BINARY.
      ** Character set identifier of message data
       15  MQMD-CODEDCHARSETID PIC S9(9) BINARY.
      ** Format name of message data
       15  MQMD-FORMAT PIC X(8).
      ** Message priority
       15  MQMD-PRIORITY PIC S9(9) BINARY.
      ** Message persistence
       15  MQMD-PERSISTENCE PIC S9(9) BINARY.
      ** Message identifier
       15  MQMD-MSGID PIC X(24).
      ** Correlation identifier
       15  MQMD-CORRELID PIC X(24).
      ** Backout counter
       15  MQMD-BACKOUTCOUNT PIC S9(9) BINARY.
      ** Name of reply queue
       15  MQMD-REPLYTOQ PIC X(48).
      ** Name of reply queue manager
       15  MQMD-REPLYTOQMGR PIC X(48).
      ** User identifier
       15  MQMD-USERIDENTIFIER PIC X(12).
      ** Accounting token
       15  MQMD-ACCOUNTINGTOKEN PIC X(32).
      ** Application data relating to identity
       15  MQMD-APPLIDENTITYDATA PIC X(32).
      ** Type of application that put the message
       15  MQMD-PUTAPPLTYPE PIC S9(9) BINARY.
      ** Name of application that put the message
       15  MQMD-PUTAPPLNAME PIC X(28).
      ** Date when message was put
       15  MQMD-PUTDATE PIC X(8).
      ** Time when message was put
       15  MQMD-PUTTIME PIC X(8).
      ** Application data relating to origin
       15  MQMD-APPLORIGINDATA PIC X(4).
      ** Ver:1 **
      ** Group identifier
       15  MQMD-GROUPID PIC X(24).
      ** Sequence number of logical message within group
       15  MQMD-MSGSEQNUMBER PIC S9(9) BINARY.
      ** Offset of data in physical message from start of logical
      ** message
       15  MQMD-OFFSET PIC S9(9) BINARY.
      ** Message flags
       15  MQMD-MSGFLAGS PIC S9(9) BINARY.
      ** Length of original message
       15  MQMD-ORIGINALLENGTH PIC S9(9) BINARY.
      ** Ver:2 **


      ******************************************************************
      **  End of CMQMD2L                                              **
      ******************************************************************
