/*
 * Decompiled with CFR 0.152.
 */
package crtmqras;

import crtmqras.CommandLineArguments;
import crtmqras.Logger;
import crtmqras.Registry;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipFile {
    public static final String SHORT_COPYRIGHT_STRING = "(c) Copyright IBM Corporation 2005, 2025";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=cmd/tools/com.ibm.mq.tools.ras/src/crtmqras/ZipFile.java";
    public static final String LONG_COPYRIGHT_STRING = "Licensed Materials - Property of IBM 63H9336 (c) Copyright IBM Corp. 2005, 2025. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final int buffer_size = 8192;
    private FileOutputStream outf;
    private ZipOutputStream out;
    private File outFile;
    private Logger logger;
    private String Filename;
    private Set<String> outFiles;

    public String getFilename() {
        return this.Filename;
    }

    public ZipFile(File file, CommandLineArguments commandLineArguments) throws Exception {
        this.outFile = file;
        this.logger = Logger.getInstanceOf();
        this.outf = new FileOutputStream(file);
        this.outFiles = new HashSet<String>();
        this.out = new ZipOutputStream(new BufferedOutputStream(this.outf));
        if (commandLineArguments.processLargeSections()) {
            this.logger.log("", "using maximum compression for potentially large files");
            this.out.setLevel(9);
        }
        this.Filename = this.outFile.getPath();
        this.logger.log("", "created new zipfile called " + this.Filename, 'V');
    }

    public boolean addFile(String string, String string2, boolean bl, boolean bl2, boolean bl3) throws Exception {
        boolean bl4 = true;
        try {
            File file = new File(string);
            String string3 = file.getName();
            this.logger.log("addFile", " file: " + string3 + " fullname: " + string);
            if (file.exists() && file.isFile()) {
                if (!string.equals(this.Filename)) {
                    if (bl) {
                        Object object;
                        Object object2;
                        Object object3;
                        FileInputStream fileInputStream = new FileInputStream(string);
                        BufferedInputStream bufferedInputStream = null;
                        Object var11_13 = null;
                        Method method = null;
                        Method method2 = null;
                        if (bl3) {
                            try {
                                object3 = Class.forName("com.ibm.as400.access.AS400");
                                object2 = ((Class)object3).getConstructor(new Class[0]);
                                object = ((Constructor)object2).newInstance(new Object[0]);
                                Class<?> clazz = Class.forName("com.ibm.as400.access.IFSTextFileInputStream");
                                Constructor<?> constructor = clazz.getConstructor(new Class[]{object3, String.class});
                                method = clazz.getMethod("read", Integer.TYPE);
                                method2 = clazz.getMethod("close", new Class[0]);
                                var11_13 = constructor.newInstance(object, string);
                                this.logger.log("IFSTextFileInputStream:" + string);
                            }
                            catch (Exception exception) {
                                this.logger.log("Cannot use jt400 classes - Files will be added, but not converted to ascii:" + exception);
                                bufferedInputStream = new BufferedInputStream(fileInputStream, 8192);
                            }
                        } else {
                            bufferedInputStream = new BufferedInputStream(fileInputStream, 8192);
                        }
                        object3 = null;
                        if (bl2) {
                            if (string2 != null) {
                                object3 = new ZipEntry(string2.replaceAll(Registry.SEPARATOR, "/"));
                            } else if (string.indexOf(File.separator) == 0) {
                                object2 = string.substring(1).replaceAll(Registry.SEPARATOR, "/");
                                while (((String)object2).indexOf(File.separator) == 0) {
                                    object2 = ((String)object2).substring(1).replaceAll(Registry.SEPARATOR, "/");
                                }
                                object3 = new ZipEntry((String)object2);
                            } else {
                                object3 = string.indexOf(58) == 1 ? new ZipEntry(string.substring(3).replaceAll(Registry.SEPARATOR, "/")) : new ZipEntry(string.replaceAll(Registry.SEPARATOR, "/"));
                            }
                        } else {
                            this.logger.log("Adding '" + string3 + "' without directory structure.");
                            object3 = new ZipEntry(string3);
                        }
                        ((ZipEntry)object3).setTime(file.lastModified());
                        if (!this.outFiles.add(((ZipEntry)object3).getName())) {
                            fileInputStream.close();
                            return bl4;
                        }
                        this.out.putNextEntry((ZipEntry)object3);
                        if (bufferedInputStream != null) {
                            int n = 0;
                            object = new byte[8192];
                            while ((n = bufferedInputStream.read((byte[])object, 0, 8192)) != -1) {
                                this.out.write((byte[])object, 0, n);
                            }
                            bufferedInputStream.close();
                        } else {
                            while (!((String)(object2 = (String)method.invoke(var11_13, 8192))).isEmpty()) {
                                this.out.write(((String)object2).getBytes());
                            }
                            method2.invoke(var11_13, new Object[0]);
                        }
                        this.out.closeEntry();
                        fileInputStream.close();
                    }
                    this.logger.log("", "added file " + string);
                }
            } else {
                bl4 = false;
                this.logger.log("", "failed to find file " + string);
            }
        }
        catch (Exception exception) {
            String string4 = exception.getMessage();
            if (string4 == null) {
                string4 = exception.toString();
            }
            bl4 = false;
            this.logger.log("Error: writing file (" + this.outFile.getName() + ") " + string4, true);
        }
        return bl4;
    }

    public boolean addFiles(File file, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return this.addFiles(file, bl, bl2, bl3, "", bl4, "", null);
    }

    public boolean addFiles(File file, boolean bl, boolean bl2, boolean bl3, final String string, boolean bl4, String string2, String string3) {
        boolean bl5;
        block34: {
            bl5 = true;
            String string4 = "";
            try {
                if (file.exists() && file.isDirectory()) {
                    File[] fileArray = null;
                    if (string.equals("") || string.equals("*")) {
                        fileArray = file.listFiles();
                    } else {
                        FilenameFilter filenameFilter = new FilenameFilter(){

                            @Override
                            public boolean accept(File file, String string2) {
                                if (new File(file.getPath() + File.separator + string2).isDirectory()) {
                                    return true;
                                }
                                return string2.matches(string.replace(".", "\\.").replace("*", ".*"));
                            }
                        };
                        try {
                            fileArray = file.listFiles(filenameFilter);
                        }
                        catch (PatternSyntaxException patternSyntaxException) {
                            this.logger.log("Syntax error in a regular-expression pattern: " + string + ", matching 0 files");
                        }
                    }
                    if (fileArray == null || fileArray != null && fileArray.length < 1) {
                        this.logger.log("no files found in directory " + file.getPath());
                        break block34;
                    }
                    for (int i = 0; i < fileArray.length; ++i) {
                        if (string3 != null && fileArray[i].getName().equalsIgnoreCase(string3)) {
                            this.logger.log("Skipping excluded file " + string3);
                            continue;
                        }
                        string4 = file.getPath() + File.separator + fileArray[i].getName();
                        if (string4.equals(this.Filename)) continue;
                        File file2 = new File(string4);
                        if (file2.exists() && file2.isFile()) {
                            if (bl) {
                                Object object;
                                boolean bl6 = false;
                                try {
                                    Object object2;
                                    Object object3;
                                    Object object4;
                                    FileInputStream fileInputStream = new FileInputStream(string4);
                                    object = null;
                                    Object var17_23 = null;
                                    Method method = null;
                                    Method method2 = null;
                                    if (bl4) {
                                        try {
                                            object4 = Class.forName("com.ibm.as400.access.AS400");
                                            object3 = ((Class)object4).getConstructor(new Class[0]);
                                            object2 = ((Constructor)object3).newInstance(new Object[0]);
                                            Class<?> clazz = Class.forName("com.ibm.as400.access.IFSTextFileInputStream");
                                            Constructor<?> constructor = clazz.getConstructor(new Class[]{object4, String.class});
                                            method = clazz.getMethod("read", Integer.TYPE);
                                            method2 = clazz.getMethod("close", new Class[0]);
                                            var17_23 = constructor.newInstance(object2, string4);
                                            this.logger.log("IFSTextFileInputStream:" + string4);
                                        }
                                        catch (Exception exception) {
                                            this.logger.log("Cannot use jt400 classes - Files will be added, but not converted to ascii:" + exception);
                                            object = new BufferedInputStream(fileInputStream, 8192);
                                        }
                                    } else {
                                        object = new BufferedInputStream(fileInputStream, 8192);
                                    }
                                    bl6 = true;
                                    object4 = null;
                                    if (bl2) {
                                        if (string2.length() > 0) {
                                            object4 = new ZipEntry(string4.substring(string4.indexOf(string2)).replaceAll(Registry.SEPARATOR, "/"));
                                        } else if (string4.indexOf(File.separator) == 0) {
                                            object3 = string4.substring(1).replaceAll(Registry.SEPARATOR, "/");
                                            while (((String)object3).indexOf(File.separator) == 0) {
                                                object3 = ((String)object3).substring(1).replaceAll(Registry.SEPARATOR, "/");
                                            }
                                            object4 = new ZipEntry((String)object3);
                                        } else {
                                            object4 = string4.indexOf(58) == 1 ? new ZipEntry(string4.substring(3).replaceAll(Registry.SEPARATOR, "/")) : new ZipEntry(string4.replaceAll(Registry.SEPARATOR, "/"));
                                        }
                                    } else {
                                        object3 = fileArray[i].getName();
                                        this.logger.log("Adding '" + (String)object3 + "' without directory structure.");
                                        object4 = new ZipEntry((String)object3);
                                    }
                                    ((ZipEntry)object4).setTime(file2.lastModified());
                                    if (!this.outFiles.add(((ZipEntry)object4).getName())) continue;
                                    this.out.putNextEntry((ZipEntry)object4);
                                    bl6 = false;
                                    if (object != null) {
                                        int n = 0;
                                        object2 = new byte[8192];
                                        while ((n = ((BufferedInputStream)object).read((byte[])object2, 0, 8192)) != -1) {
                                            bl6 = true;
                                            this.out.write((byte[])object2, 0, n);
                                            bl6 = false;
                                        }
                                        ((BufferedInputStream)object).close();
                                    } else {
                                        while (!((String)(object3 = (String)method.invoke(var17_23, 8192))).isEmpty()) {
                                            this.out.write(((String)object3).getBytes());
                                        }
                                        method2.invoke(var17_23, new Object[0]);
                                    }
                                    bl6 = true;
                                    this.out.closeEntry();
                                    bl6 = false;
                                    fileInputStream.close();
                                }
                                catch (Exception exception) {
                                    object = exception.getMessage();
                                    if (object == null) {
                                        object = exception.toString();
                                    }
                                    this.logger.log("Error including file " + string4 + ", " + (String)object);
                                    if (bl6) {
                                        throw exception;
                                    }
                                    this.logger.log("ERROR: Cannot read from file " + string4 + " due to an exception:", true);
                                    this.logger.log("  " + (String)object, true);
                                }
                            }
                            this.logger.log("", "added file " + string4);
                            continue;
                        }
                        if (file2.isFile()) {
                            this.logger.log("", "failed to find file " + string4);
                            continue;
                        }
                        if (!file2.isDirectory() || !bl3) continue;
                        this.logger.log("ZipFile", string4 + " is a directory, attempting to add files from within");
                        if (string2.length() > 0) {
                            this.addFiles(file2, bl, bl2, bl3, string, bl4, string4.substring(string4.indexOf(string2)), string3);
                            continue;
                        }
                        this.addFiles(file2, bl, bl2, bl3, string, bl4, "", string3);
                    }
                    break block34;
                }
                this.logger.log("", "failed to find directory " + file.getPath());
            }
            catch (Exception exception) {
                String string5 = exception.getMessage();
                if (string5 == null) {
                    string5 = exception.toString();
                }
                bl5 = false;
                String string6 = "Error: adding file (" + string4 + ") " + string5;
                this.logger.log(string6);
            }
        }
        return bl5;
    }

    public void close() throws IOException {
        this.out.flush();
        this.out.close();
        this.outf.close();
    }
}

