/*
 * Decompiled with CFR 0.152.
 */
package crtmqras;

import crtmqras.Logger;
import crtmqras.QM;
import crtmqras.QmIniFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WinRegistry {
    public static final String SHORT_COPYRIGHT_STRING = "(c) Copyright IBM Corporation 2005, 2011";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=cmd/tools/com.ibm.mq.tools.ras/src/crtmqras/WinRegistry.java";
    public static final String LONG_COPYRIGHT_STRING = "Licensed Materials - Property of IBM 63H9336 (c) Copyright IBM Corp. 2005, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String CLASSNAME = "WinRegistry";
    private static String REGKEY_NEWROOT = "HKEY_LOCAL_MACHINE\\SOFTWARE\\IBM\\WebSphere MQ";
    private static String REGKEY_OLDROOT = "[HKEY_LOCAL_MACHINE\\SOFTWARE\\IBM\\MQSeries\\CurrentVersion";
    private static String REGKEY_OLDROOTBASE = REGKEY_OLDROOT + "]";
    private static String REGKEY_CONFIGBASE = REGKEY_OLDROOT + "\\Configuration";
    private static String REGKEY_CONFIGQMGR = REGKEY_OLDROOT + "\\Configuration\\QueueManager";
    private static String REGKEY_CONFIGQMGRBASE = REGKEY_CONFIGQMGR + "]";
    private static String REGKEY_CONFIGQMGRSTEM = REGKEY_CONFIGQMGR + "\\";
    private String regkey_CONFIGQMGR_NAME = "";
    private String regkey_CONFIGQMGR_NAMELOG = "";
    private Logger logger;
    private List<QM> qm_list;
    private String work_path = "";

    public String getWork_path() {
        return this.work_path;
    }

    private void setWork_path(String string) {
        this.work_path = string;
        this.logger.log(CLASSNAME, "found work path " + string, 'V');
    }

    public WinRegistry(String string, String string2, Logger logger) throws Exception {
        this.logger = logger;
        this.qm_list = new ArrayList<QM>();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "UTF-16"));
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (string2.equals(REGKEY_NEWROOT)) {
                throw fileNotFoundException;
            }
            this.qm_list = null;
        }
        if (bufferedReader != null) {
            logger.log(CLASSNAME, "opened file " + string);
            String string3 = "";
            boolean bl = true;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            String string4 = "";
            String string5 = "";
            String string6 = "";
            String string7 = "";
            String string8 = "";
            String string9 = "";
            String string10 = "";
            String string11 = "";
            String string12 = "";
            boolean bl5 = true;
            int n = string2.equals(REGKEY_NEWROOT) ? 7 : 0;
            while (bl) {
                if (bl5) {
                    string3 = bufferedReader.readLine();
                }
                bl5 = true;
                logger.log(CLASSNAME, "read line: " + string3, 'V');
                if (string3 == null) {
                    n = 6;
                } else {
                    if ((string3 = string3.trim()).equals("")) continue;
                    if (string3.startsWith("[")) {
                        string12 = string3;
                    }
                }
                switch (n) {
                    case 0: {
                        if (0 != string3.compareTo(REGKEY_OLDROOTBASE)) break;
                        logger.log(CLASSNAME, "found ..\\Configuration]", 'V');
                        ++n;
                        break;
                    }
                    case 1: {
                        Pattern pattern = Pattern.compile("\\s*\"(.+)\"=\"(.+)\"\\s*");
                        Matcher matcher = pattern.matcher(string3);
                        if (matcher.matches()) {
                            logger.log(CLASSNAME, "found " + string3);
                            if (0 != matcher.group(1).compareToIgnoreCase("WorkPath")) break;
                            this.setWork_path(matcher.group(2).replace("\\\\", "\\"));
                            break;
                        }
                        if (!string3.startsWith(REGKEY_CONFIGQMGRBASE)) break;
                        logger.log("WinRegistry:", " moving to state " + ++n + " input=" + string3);
                        break;
                    }
                    case 2: {
                        if (!bl2 && string3.startsWith(REGKEY_CONFIGBASE)) {
                            bl2 = true;
                        }
                        if (!string3.startsWith(REGKEY_CONFIGQMGRSTEM) || !this.validLine(string3)) break;
                        int n2 = string3.lastIndexOf(92);
                        String string13 = string3.substring(n2 + 1);
                        bl3 = true;
                        logger.log(CLASSNAME, "found configuration for QueueManager " + string13);
                        n2 = string3.lastIndexOf(93);
                        this.regkey_CONFIGQMGR_NAME = string3.substring(0, n2);
                        this.regkey_CONFIGQMGR_NAMELOG = this.regkey_CONFIGQMGR_NAME + File.separator + "Log";
                        logger.log("WinRegistry:", " moving to state " + ++n + " input=" + string3);
                        logger.log(CLASSNAME, "qmgrName = " + this.regkey_CONFIGQMGR_NAME);
                        logger.log(CLASSNAME, "qmgrLog = " + this.regkey_CONFIGQMGR_NAMELOG);
                        break;
                    }
                    case 3: {
                        Pattern pattern = Pattern.compile("\\s*\"(.+)\"=\"(.+)\"\\s*");
                        Matcher matcher = pattern.matcher(string3);
                        if (matcher.matches()) {
                            logger.log(CLASSNAME, "found " + string3);
                            if (string12.equals(this.regkey_CONFIGQMGR_NAME + "]")) {
                                if (0 == matcher.group(1).compareToIgnoreCase("Name")) {
                                    string4 = matcher.group(2);
                                    logger.log(CLASSNAME, "found qm=" + string4);
                                    break;
                                }
                                if (0 == matcher.group(1).compareToIgnoreCase("Prefix")) {
                                    string5 = matcher.group(2).replace("\\\\", "\\");
                                    break;
                                }
                                if (0 == matcher.group(1).compareToIgnoreCase("DataPath")) {
                                    string8 = matcher.group(2).replace("\\\\", "\\");
                                    break;
                                }
                                if (0 == matcher.group(1).compareToIgnoreCase("Directory")) {
                                    string6 = matcher.group(2).replace("\\\\", "\\");
                                    break;
                                }
                                if (matcher.group(1).equalsIgnoreCase("InstallationName")) {
                                    string9 = matcher.group(2);
                                    break;
                                }
                                if (0 != matcher.group(1).compareToIgnoreCase("EphemeralPrefix")) break;
                                string10 = matcher.group(2).replace("\\\\", "\\");
                                break;
                            }
                            logger.log(CLASSNAME, "Ignoring name=value as not in QueueManager main stanza: " + string3, 'V');
                            break;
                        }
                        if (string3.startsWith(this.regkey_CONFIGQMGR_NAMELOG)) {
                            logger.log("WinRegistry:", " moving to state " + ++n + " input=" + string3);
                            break;
                        }
                        if (string3.startsWith(this.regkey_CONFIGQMGR_NAME + "]") || string3.startsWith(this.regkey_CONFIGQMGR_NAME + "\\")) break;
                        if (string8.equals("")) {
                            string8 = string5 + File.separator + "qmgrs" + File.separator + string6;
                        }
                        if (string10.equals("")) {
                            string10 = string5;
                            string11 = string5;
                        } else {
                            string11 = string10;
                        }
                        if (!bl4) {
                            try {
                                string7 = QmIniFile.getLogDirectory(string8 + File.separator + "qm.ini", logger);
                                bl4 = true;
                            }
                            catch (Exception exception) {
                                logger.log("Exception reading QM.ini - skipping qmgr");
                            }
                        }
                        if (bl3 && bl4) {
                            this.addQm(string4, string8, string6, string7, string9, string10, string11);
                            bl3 = false;
                            bl4 = false;
                        }
                        string4 = "";
                        string5 = "";
                        string6 = "";
                        string7 = "";
                        string9 = "";
                        string8 = "";
                        string10 = "";
                        string11 = "";
                        if (string3.startsWith(REGKEY_CONFIGQMGR) && !string3.startsWith(REGKEY_CONFIGQMGRBASE)) {
                            n = 2;
                            bl5 = false;
                        } else {
                            n += 2;
                        }
                        logger.log("WinRegistry:", " moving to state " + n + " input=" + string3);
                        break;
                    }
                    case 4: {
                        Matcher matcher;
                        Pattern pattern;
                        if (!bl4) {
                            pattern = Pattern.compile("\\s*\"(.+)\"=\"(.+)\"\\s*");
                            matcher = pattern.matcher(string3);
                            if (!matcher.matches()) break;
                            logger.log(CLASSNAME, "found " + string3);
                            if (0 != matcher.group(1).compareToIgnoreCase("LogPath")) break;
                            string7 = matcher.group(2).replace("\\\\", "\\");
                            bl4 = true;
                            break;
                        }
                        logger.log("WinRegistry:", " moving back to state " + --n + " input=" + string3);
                        break;
                    }
                    case 5: {
                        if (!string3.startsWith(REGKEY_CONFIGQMGR) || string3.startsWith(REGKEY_CONFIGQMGRBASE)) break;
                        n = 2;
                        logger.log("WinRegistry:", " moving to state " + n + " input=" + string3);
                        break;
                    }
                    case 6: {
                        bl = false;
                        break;
                    }
                    case 7: {
                        if (!string3.equals("[" + REGKEY_NEWROOT + "]")) break;
                        logger.log(CLASSNAME, "found ..\\WebSphere MQ]", 'V');
                        logger.log("WinRegistry:", " moving to state " + ++n + " input=" + string3);
                        break;
                    }
                    case 8: {
                        Pattern pattern = Pattern.compile("\\s*\"(.+)\"=\"(.+)\"\\s*");
                        Matcher matcher = pattern.matcher(string3);
                        if (matcher.matches()) {
                            logger.log(CLASSNAME, "found " + string3);
                            if (!matcher.group(1).equalsIgnoreCase("WorkPath")) break;
                            this.setWork_path(matcher.group(2).replace("\\\\", "\\"));
                            break;
                        }
                        bl = false;
                    }
                }
            }
            bufferedReader.close();
            if (!string2.equals(REGKEY_NEWROOT) && !bl2) {
                logger.log("Did not find Configuration in registry - previous values must be from primary");
                logger.log("qm_list has " + this.qm_list.size() + " entries in it (should be 0)");
                this.qm_list = null;
            }
        }
    }

    private void addQm(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        this.logger.log(CLASSNAME, "adding qm: " + string + ", inst: " + string5 + ", data: " + string2 + ", log: " + string4 + ", ephem prefix: " + string6 + ", sockets prefix: " + string7);
        QM qM = new QM(string, string2, string3, string4, string5, string6, string7);
        this.qm_list.add(qM);
    }

    public List<QM> getQueueManagers() {
        return this.qm_list;
    }

    private boolean validLine(String string) {
        if (this.regkey_CONFIGQMGR_NAME.equalsIgnoreCase("") || this.regkey_CONFIGQMGR_NAMELOG.equalsIgnoreCase("")) {
            return true;
        }
        return !string.startsWith(this.regkey_CONFIGQMGR_NAME + File.separator) || string.equalsIgnoreCase(this.regkey_CONFIGQMGR_NAMELOG + "]");
    }
}

