/*
 * Decompiled with CFR 0.152.
 */
package crtmqras;

import crtmqras.FTPHandler;
import crtmqras.Logger;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;

public class FTPClient {
    public static final String SHORT_COPYRIGHT_STRING = "(c) Copyright IBM Corporation 2005, 2008";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=cmd/tools/com.ibm.mq.tools.ras/src/crtmqras/FTPClient.java";
    public static final String LONG_COPYRIGHT_STRING = "Licensed Materials - Property of IBM 63H9336 (c) Copyright IBM Corp. 2005, 2008. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private FTPHandler ftpHandler;
    private String user;
    private String password;
    private String fileToTransfer;
    private Logger logger;

    public FTPClient(String string, String string2, String string3, String string4, String string5, Logger logger) {
        this.user = string2;
        this.password = string3;
        this.fileToTransfer = string5;
        this.logger = logger;
        this.ftpHandler = new FTPHandler(string, string4, logger);
        this.ftpHandler.setWriteLogToFile(true);
        this.ftpHandler.setWriteLogToScreen(false);
    }

    public boolean ftpFile() {
        boolean bl = false;
        try {
            this.logger.log("FTP HANDLER: Opening connection to the server.", true);
            this.ftpHandler.open(this.user, this.password, "");
            this.logger.log("FTP HANDLER: Connection established for user -" + this.user + ".", true);
            String string = this.extractFilename(this.fileToTransfer);
            this.logger.log("FTP HANDLER: Starting file transfer.", true);
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(this.fileToTransfer)));
            this.ftpHandler.putBinaryStream(dataInputStream, string, 0L);
            this.logger.log("FTP HANDLER: File transfer complete.", true);
            this.ftpHandler.close();
            this.logger.log("FTP HANDLER: Connection closed", true);
            bl = true;
        }
        catch (Exception exception) {
            this.logger.log("Exception occurred when trying to transfer file: " + exception.getMessage(), exception);
        }
        return bl;
    }

    private String extractFilename(String string) {
        int n = 0;
        for (int i = string.length() - 1; i >= 0; --i) {
            if (string.charAt(i) != '/' && string.charAt(i) != '\\') continue;
            n = i + 1;
            break;
        }
        return string.substring(n);
    }
}

