/*
 * Decompiled with CFR 0.152.
 */
package crtmqras;

import crtmqras.Logger;
import crtmqras.Registry;
import crtmqras.ZipFolder;
import crtmqras.Zipper;
import java.io.File;
import java.util.Map;

public class CommandProcessor {
    public static final String SHORT_COPYRIGHT_STRING = "(c) Copyright IBM Corporation 2005, 2024";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=cmd/tools/com.ibm.mq.tools.ras/src/crtmqras/CommandProcessor.java";
    public static final String LONG_COPYRIGHT_STRING = "Licensed Materials - Property of IBM 63H9336 (c) Copyright IBM Corp. 2005, 2024. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String OS_NAME;
    private String ISupportSanitizer;
    private boolean demoMode;
    private Registry reg;
    private Logger logger;

    private void init(ZipFolder zipFolder, boolean bl, String string, Logger logger, Registry registry) {
        this.OS_NAME = string;
        this.demoMode = bl;
        this.logger = logger;
        this.reg = registry;
        this.ISupportSanitizer = System.getProperty("AMQ_I_SUPPORT_SANITIZER");
    }

    public CommandProcessor(ZipFolder zipFolder, boolean bl, String string, Logger logger, Registry registry) {
        this.init(zipFolder, bl, string, logger, registry);
    }

    private synchronized void runCommand(String string, int n, String string2, boolean bl, String string3) throws Exception {
        Map<String, String> map;
        ProcessBuilder processBuilder;
        String string4 = "Executing: '" + string;
        string4 = n > 0 ? string4 + "' with a timeout of " + n : "' with an indefinite timeout!";
        this.logger.log(string4);
        if (!this.OS_NAME.equals("Windows")) {
            if (this.OS_NAME.equals("OS/400")) {
                processBuilder = new ProcessBuilder("/bin/qsh", "-c", string);
            } else {
                processBuilder = new ProcessBuilder("/bin/sh", "-c", string);
                if (this.ISupportSanitizer != null && !bl) {
                    map = processBuilder.environment();
                    this.logger.log("Unsetting LD_PRELOAD before invoking non-MQ program");
                    map.remove("LD_PRELOAD");
                }
            }
        } else {
            processBuilder = new ProcessBuilder("cmd", "/C", string);
        }
        if (string3 != null && 0 != string3.length()) {
            map = processBuilder.environment();
            this.logger.log("Setting PATH temporarily to " + string3 + " for " + string);
            map.remove("PATH");
            map.put("PATH", string3);
        }
        if (string2 != null && 0 != string2.length()) {
            boolean bl2 = true;
            String string5 = Zipper.WORK_DIRECTORY_NAME;
            File file = new File(string5 + File.separator + string2);
            if (!file.exists()) {
                if (!file.mkdirs()) {
                    this.logger.log("Failed to create directory " + string2 + ", using default working directory");
                    bl2 = false;
                }
            } else if (!file.isDirectory()) {
                this.logger.log(string5 + File.separator + string2 + " exists but is not a directory, using default working directory");
                bl2 = false;
            }
            if (bl2) {
                processBuilder.directory(file);
            }
        }
        Process process = processBuilder.start();
        int n2 = 99;
        if (n > 0) {
            int n3 = n * 10;
            while (n3 > 0) {
                try {
                    n2 = process.exitValue();
                    n3 = 0;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    Thread.currentThread();
                    Thread.sleep(100L);
                    --n3;
                }
            }
        } else {
            try {
                n2 = process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                this.logger.log("CommandProcessor", "cmd: '" + string + "' failed due to: " + interruptedException.toString());
            }
        }
        process.destroy();
        if (n2 > 0) {
            throw new Exception("ERROR: runCommand: process exitValue = " + n2);
        }
    }

    public synchronized void run(String string, int n, boolean bl) {
        this.run(string, n, "", bl, "");
    }

    public synchronized void run(String string, int n, String string2, boolean bl, String string3) {
        String string4 = string;
        if (this.demoMode) {
            this.logger.log("run: " + string4);
        } else {
            if (this.OS_NAME.equals("Windows")) {
                string4 = "cmd /C " + string4;
            }
            try {
                this.runCommand(string4, n, string2, bl, string3);
            }
            catch (Exception exception) {
                this.logger.log("    command " + string4);
                this.logger.log("    failed with following message:");
                this.logger.log("    " + exception.getMessage());
            }
        }
    }
}

