/*
 * Decompiled with CFR 0.152.
 */
package crtmqras;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.NativeCalls;
import com.ibm.mq.commonservices.internal.utils.QueryValue;
import com.ibm.mq.commonservices.internal.utils.QueueManager;
import crtmqras.Logger;
import crtmqras.QM;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class CS {
    public static final String SHORT_COPYRIGHT_STRING = "(c) Copyright IBM Corporation 2005, 2011";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=cmd/tools/com.ibm.mq.tools.ras/src/crtmqras/CS.java";
    public static final String LONG_COPYRIGHT_STRING = "Licensed Materials - Property of IBM 63H9336 (c) Copyright IBM Corp. 2005, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Trace trace;
    private String mq_directory;
    private String mq_ver;
    private String exe_directory;
    private String install_directory;
    private boolean mq_appliance = false;
    private boolean os_unregistered = false;
    private String error_message = "";
    private List<QM> qm_list;
    private boolean ok = true;
    protected Logger logger;
    private String QM_DIR = File.separator + "qmgrs";

    public CS() {
        this.logger = Logger.getInstanceOf();
        ArrayList arrayList = null;
        try {
            this.trace = Trace.getDefault();
            CommonServices.processInitialize((Trace)this.trace, (boolean)true);
            this.mq_ver = QueryValue.queryVersionAsString((Trace)this.trace);
            this.install_directory = QueryValue.queryInstallDir((Trace)this.trace);
            this.exe_directory = QueryValue.queryExecDir((Trace)this.trace);
            this.mq_directory = QueryValue.queryGeneralDataLib((Trace)this.trace);
            this.mq_appliance = QueryValue.isMQAppliance((Trace)this.trace);
            this.os_unregistered = QueryValue.isOSUnregistered((Trace)this.trace);
            this.logger.log("mq_ver: '" + this.mq_ver + "'");
            this.logger.log("install_directory: '" + this.install_directory + "'");
            this.logger.log("exe_directory: '" + this.exe_directory + "'");
            this.logger.log("mq_directory: '" + this.mq_directory + "'");
            this.logger.log("mq_appliance: '" + this.mq_appliance + "'");
            this.logger.log("os_unregistered: '" + this.os_unregistered + "'");
            arrayList = QueueManager.getListOfQueueManagers((Trace)this.trace);
            this.qm_list = new ArrayList<QM>();
            for (String string : arrayList) {
                String string2;
                this.logger.log("Processing QueueManager " + string);
                String string3 = QueueManager.getQueueManagerKey((Trace)this.trace, (String)string, (String)"Directory");
                String string4 = QueueManager.getQueueManagerKey((Trace)this.trace, (String)string, (String)"Prefix");
                String string5 = QueueManager.getQueueManagerKey((Trace)this.trace, (String)string, (String)"EphemeralPrefix");
                String string6 = QueueManager.getQueueManagerKey((Trace)this.trace, (String)string, (String)"InstallationName");
                String string7 = QueueManager.getQueueManagerKey((Trace)this.trace, (String)string, (String)"DataPath");
                if (string7 == null || string7.equals("")) {
                    this.logger.log("No datapath value, using default prefixed based directory");
                    string7 = string4 + this.QM_DIR + File.separator + string3;
                }
                if (string5 == null || string5.equals("")) {
                    this.logger.log("No qmEphemPrefix value, using default prefixed based directory");
                    string5 = string4;
                    string2 = this.mq_directory;
                } else {
                    string2 = string5;
                }
                String string8 = "";
                String string9 = NativeCalls.getAttrs((Trace)this.trace, (String)string, (String)"Log");
                String[] stringArray = string9.split("\n");
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!stringArray[i].equals("LogPath")) continue;
                    string8 = stringArray[i + 1];
                    break;
                }
                this.logger.log("QM: '" + string + "'");
                this.logger.log("qmDataPath: '" + string7 + "'");
                this.logger.log("qmDir: '" + string3 + "'");
                this.logger.log("qmLog: '" + string8 + "'");
                this.logger.log("qmInst: '" + string6 + "'");
                this.logger.log("qmEphemPrefix: '" + string5 + "'");
                this.logger.log("qmSocketsPrefix: '" + string2 + "'");
                QM qM = new QM(string, string7, string3, string8, string6, string5, string2);
                this.qm_list.add(qM);
            }
            CommonServices.processTerminate((Trace)this.trace);
        }
        catch (Throwable throwable) {
            this.error_message = throwable.getMessage();
            this.ok = false;
        }
    }

    public boolean isOk() {
        return this.ok;
    }

    public boolean isMQAppliance() {
        return this.mq_appliance;
    }

    public boolean isOSUnregistered() {
        return this.os_unregistered;
    }

    public String getMq_directory() {
        return this.mq_directory;
    }

    public String getError() {
        return this.error_message;
    }

    public String getMq_ver() {
        return this.mq_ver;
    }

    public String getExe_directory() {
        return this.exe_directory;
    }

    public String getInstall_directory() {
        return this.install_directory;
    }

    public List<QM> getQm_list() {
        return this.qm_list;
    }
}

