      ******************************************************************
      **                                                              **
      **                      IBM MQ for Windows                      **
      **                                                              **
      **  FILE NAME:      CMQODL                                      **
      **                                                              **
      **  DESCRIPTION:    MQOD Structure -- Object descriptor         **
      **                                                              **
      ******************************************************************
      **  <copyright                                                  **
      **  notice="lm-source-program"                                  **
      **  pids="5724-H72,5655-R36,5724-L26"                           **
      **  years="1993,2025"                                           **
      **  crc="1616507131" >                                          **
      **  Licensed Materials - Property of IBM                        **
      **                                                              **
      **  5724-H72                                                    **
      **                                                              **
      **  (C) Copyright IBM Corp. 1993, 2025 All Rights Reserved.     **
      **                                                              **
      **  US Government Users Restricted Rights - Use, duplication or **
      **  disclosure restricted by GSA ADP Schedule Contract with     **
      **  IBM Corp.                                                   **
      **  </copyright>                                                **
      ******************************************************************
      **                                                              **
      **  FUNCTION:       This file declares the structure MQOD,      **
      **                  which is used by the main MQI.              **
      **                                                              **
      **  PROCESSOR:      COBOL                                       **
      **                                                              **
      ******************************************************************

      ******************************************************************
      ** <BEGIN_BUILDINFO>                                            **
      ** Generated on:  08/10/25 09:39                                **
      ** Build Level:   p940-016-251008                               **
      ** Build Type:    Production                                    **
      ** Pointer Size:  32 Bit                                        **
      ** Source File:                                                 **
      ** CMQODL                                                       **
      ** <END_BUILDINFO>                                              **
      ******************************************************************

      ** MQOD structure
       10  MQOD.
      ** Structure identifier
       15  MQOD-STRUCID PIC X(4).
      ** Structure version number
       15  MQOD-VERSION PIC S9(9) BINARY.
      ** Object type
       15  MQOD-OBJECTTYPE PIC S9(9) BINARY.
      ** Object name
       15  MQOD-OBJECTNAME PIC X(48).
      ** Object queue manager name
       15  MQOD-OBJECTQMGRNAME PIC X(48).
      ** Dynamic queue name
       15  MQOD-DYNAMICQNAME PIC X(48).
      ** Alternate user identifier
       15  MQOD-ALTERNATEUSERID PIC X(12).
      ** Ver:1 **
      ** Number of object records present
       15  MQOD-RECSPRESENT PIC S9(9) BINARY.
      ** Number of local queues opened successfully
       15  MQOD-KNOWNDESTCOUNT PIC S9(9) BINARY.
      ** Number of remote queues opened
       15  MQOD-UNKNOWNDESTCOUNT PIC S9(9) BINARY.
      ** Number of queues that failed to open
       15  MQOD-INVALIDDESTCOUNT PIC S9(9) BINARY.
      ** Offset of first object record from start of MQOD
       15  MQOD-OBJECTRECOFFSET PIC S9(9) BINARY.
      ** Offset of first response record from start of MQOD
       15  MQOD-RESPONSERECOFFSET PIC S9(9) BINARY.
      ** Address of first object record
       15  MQOD-OBJECTRECPTR POINTER.
      ** Address of first response record
       15  MQOD-RESPONSERECPTR POINTER.
      ** Ver:2 **
      ** Alternate security identifier
       15  MQOD-ALTERNATESECURITYID PIC X(40).
      ** Resolved queue name
       15  MQOD-RESOLVEDQNAME PIC X(48).
      ** Resolved queue manager name
       15  MQOD-RESOLVEDQMGRNAME PIC X(48).
      ** Ver:3 **
      ** Object long name
       15  MQOD-OBJECTSTRING.
      ** Address of variable length string
       20  MQOD-OBJECTSTRING-VSPTR POINTER.
      ** Offset of variable length string
       20  MQOD-OBJECTSTRING-VSOFFSET PIC S9(9) BINARY.
      ** Size of buffer
       20  MQOD-OBJECTSTRING-VSBUFSIZE PIC S9(9) BINARY.
      ** Length of variable length string
       20  MQOD-OBJECTSTRING-VSLENGTH PIC S9(9) BINARY.
      ** CCSID of variable length string
       20  MQOD-OBJECTSTRING-VSCCSID PIC S9(9) BINARY.
      ** Message Selector
       15  MQOD-SELECTIONSTRING.
      ** Address of variable length string
       20  MQOD-SELECTIONSTRING-VSPTR POINTER.
      ** Offset of variable length string
       20  MQOD-SELECTIONSTRING-VSOFFSET PIC S9(9) BINARY.
      ** Size of buffer
       20  MQOD-SELECTIONSTRING-VSBUFSIZE PIC S9(9) BINARY.
      ** Length of variable length string
       20  MQOD-SELECTIONSTRING-VSLENGTH PIC S9(9) BINARY.
      ** CCSID of variable length string
       20  MQOD-SELECTIONSTRING-VSCCSID PIC S9(9) BINARY.
      ** Resolved long object name
       15  MQOD-RESOBJECTSTRING.
      ** Address of variable length string
       20  MQOD-RESOBJECTSTRING-VSPTR POINTER.
      ** Offset of variable length string
       20  MQOD-RESOBJECTSTRING-VSOFFSET PIC S9(9) BINARY.
      ** Size of buffer
       20  MQOD-RESOBJECTSTRING-VSBUFSIZE PIC S9(9) BINARY.
      ** Length of variable length string
       20  MQOD-RESOBJECTSTRING-VSLENGTH PIC S9(9) BINARY.
      ** CCSID of variable length string
       20  MQOD-RESOBJECTSTRING-VSCCSID PIC S9(9) BINARY.
      ** Alias queue resolved object type
       15  MQOD-RESOLVEDTYPE PIC S9(9) BINARY.
      ** Ver:4 **


      ******************************************************************
      **  End of CMQODL                                               **
      ******************************************************************
