/*
 * Decompiled with CFR 0.152.
 */
package crtmqras;

import crtmqras.CS;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Logger {
    public static final String SHORT_COPYRIGHT_STRING = "(c) Copyright IBM Corporation 2005, 2008";
    public static final String SCCSID = "@(#) MQMBID sn=p940-016-251008 su=f957d47a17fac92e5ee99e3c0e497737e112aed5 pn=cmd/tools/com.ibm.mq.tools.ras/src/crtmqras/Logger.java";
    public static final String LONG_COPYRIGHT_STRING = "Licensed Materials - Property of IBM 63H9336 (c) Copyright IBM Corp. 2005, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Logger the_logger = null;
    private FileOutputStream out = null;
    private PrintStream ps = null;
    private List<String> store = new ArrayList<String>();
    private boolean verboseMode = false;
    private StringWriter sw = new StringWriter();
    private PrintWriter pw = new PrintWriter(this.sw);
    private CS cs = new CS();
    private int lastMessageLength = 0;
    private LogState currentLoggingState = LogState.LogStateNormal;

    public boolean isMQAppliance() {
        return this.cs.isMQAppliance();
    }

    public void enableOverwriteState() {
        this.currentLoggingState = LogState.LogStateProgress;
    }

    public void disableOverwriteState() {
        if (this.currentLoggingState == LogState.LogStateProgress && this.lastMessageLength > 0) {
            this.currentLoggingState = LogState.LogStateNormal;
            this.lastMessageLength = 0;
            System.out.print("\n");
        }
    }

    public void enableErrorReportState() {
        if (this.currentLoggingState == LogState.LogStateProgress) {
            this.disableOverwriteState();
            this.currentLoggingState = LogState.LogStateErrorReport;
        }
    }

    public boolean isVerboseMode() {
        return this.verboseMode;
    }

    public void setVerboseMode() {
        this.verboseMode = true;
        this.log("", "running in verbose mode ", 'N');
    }

    public Logger() throws IOException {
        if (the_logger == null) {
            the_logger = this;
        }
    }

    public static Logger getInstanceOf() {
        return the_logger;
    }

    public void setFile(String string) throws Exception {
        this.out = new FileOutputStream(string + File.separator + "console.log");
        this.ps = new PrintStream(this.out);
        for (String string2 : this.store) {
            this.ps.println(string2);
            this.ps.flush();
        }
        this.store.clear();
    }

    public void log(String string, String string2, char c, boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4 = bl3 = c == 'V' && this.isVerboseMode() || c != 'V';
        if (bl3) {
            String string3 = this.getDate();
            if (this.ps == null && this.store != null) {
                String string4 = string + ":" + string2;
                string4 = string.length() > 0 ? string3 + ":     " + string + ":" + string2 : string3 + ":    " + string2;
                this.store.add(string4);
            } else {
                this.ps.print(string3 + ":    ");
                if (string.length() > 0) {
                    this.ps.print(string + ":");
                }
                this.ps.println(string2);
                this.ps.flush();
            }
            if (bl && (!this.isMQAppliance() || bl2 && this.isMQAppliance())) {
                switch (this.currentLoggingState) {
                    case LogStateNormal: {
                        System.out.println(string2);
                        break;
                    }
                    case LogStateProgress: {
                        int n;
                        int n2 = string2.length();
                        System.out.print("\r");
                        System.out.print(string2);
                        if (this.lastMessageLength > 0 && (n = this.lastMessageLength - n2) > 0) {
                            for (int i = 0; i < n; ++i) {
                                System.out.print(' ');
                            }
                        }
                        this.lastMessageLength = n2;
                        break;
                    }
                    case LogStateErrorReport: {
                        System.out.println("error: " + string2);
                        this.enableOverwriteState();
                    }
                }
            }
        }
    }

    public void log(String string, String string2, char c, boolean bl) {
        this.log(string, string2, c, bl, bl);
    }

    public void log(String string, String string2, char c) {
        this.log(string, string2, c, false);
    }

    public void log(String string, boolean bl) {
        this.log("", string, 'N', bl);
    }

    public void log(String string, boolean bl, boolean bl2) {
        this.log("", string, 'N', bl, bl2);
    }

    public void log(String string) {
        this.log(string, false);
    }

    public void log(String string, Exception exception) {
        exception.printStackTrace(this.pw);
        this.enableErrorReportState();
        this.log("", string.concat(this.sw.toString()), 'N', true);
        this.sw.getBuffer().setLength(0);
    }

    public void log(String string, String string2, boolean bl) {
        this.log(string, string2, 'N', bl);
    }

    public void log(String string, String string2) {
        this.log(string, string2, false);
    }

    public void close() throws Exception {
        if (this.ps == null) {
            throw new Exception("ERROR: console file has not been opened");
        }
        this.ps.close();
        this.ps = null;
        this.out = null;
    }

    public String getDate() {
        Date date = new Date();
        String string = date.toString();
        return string;
    }

    private static enum LogState {
        LogStateNormal,
        LogStateProgress,
        LogStateErrorReport;

    }
}

