/*
 * Decompiled with CFR 0.152.
 */
package crtmqras;

import crtmqras.FtpException;
import crtmqras.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

public class FTPHandler {
    public static final String SHORT_COPYRIGHT_STRING = "(c) Copyright IBM Corporation 2005, 2008";
    public static final String SCCSID = "@(#) MQMBID sn=p940-016-251008 su=f957d47a17fac92e5ee99e3c0e497737e112aed5 pn=cmd/tools/com.ibm.mq.tools.ras/src/crtmqras/FTPHandler.java";
    public static final String LONG_COPYRIGHT_STRING = "Licensed Materials - Property of IBM 63H9336 (c) Copyright IBM Corp. 2005, 2008. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected RemoteStatus remoteStatus = RemoteStatus.INIT;
    protected String server;
    protected String user;
    protected String password;
    private String className = "FTP";
    private String reply = "";
    private String replyCode = "";
    private String replyText = "";
    private Socket socket = null;
    private BufferedReader in = null;
    private PrintWriter out = null;
    private int port = 21;
    private ConnectionType connectionType = ConnectionType.PASSIVE;
    private String directory = "";
    private int timeout = 5000;
    private boolean isTracing = true;
    private final byte[] transferBuffer = new byte[4096];
    private static final String CONNECT = "FTP_INIT";
    private static final String CMD_ACCT = "ACCT ";
    private static final String CMD_CWD = "CWD ";
    private static final String CMD_CDUP = "CDUP";
    private static final String CMD_DELE = "DELE ";
    private static final String CMD_MKD = "MKD ";
    private static final String CMD_PASV = "PASV";
    private static final String CMD_PASS = "PASS ";
    private static final String CMD_PORT = "PORT ";
    private static final String CMD_PWD = "PWD";
    private static final String CMD_QUIT = "QUIT";
    private static final String CMD_RMD = "RMD ";
    private static final String CMD_REST = "REST ";
    private static final String CMD_RETR = "RETR ";
    private static final String CMD_RNTO = "RNTO ";
    private static final String CMD_RNFR = "RNFR ";
    private static final String CMD_STOR = "STOR ";
    private static final String CMD_SYST = "SYST";
    private static final String CMD_USER = "USER ";
    private static final String CMD_TYPE = "TYPE ";
    private static final String CMD_LIST = "LIST";
    private static final String CMD_NLST = "NLST";
    private static final String CMD_EPRT = "EPRT ";
    private static final String MODE_ASCII = "A";
    private static final String MODE_BINARY = "I";
    private static final String ENCODING = "US-ASCII";
    private static final int BUFFER_SIZE = 4096;
    private static final int PORT_DEFAULT = 21;
    private static final int PORT_MIN = 1;
    private static final int PORT_MAX = 65535;
    private static final int TIMEOUT_DEFAULT = 5000;
    private boolean writeLogToFile = true;
    private boolean writeLogToScreen = false;
    File logFile;
    private ArrayList<String> logs = new ArrayList();
    private Logger logger;

    public FTPHandler(String string, String string2, Logger logger) {
        this(string, TransferMode.BINARY, 5000, ConnectionType.PASSIVE, string2, logger);
    }

    public FTPHandler(String string, int n, String string2, Logger logger) {
        this(string, TransferMode.BINARY, n, ConnectionType.PASSIVE, string2, logger);
    }

    public FTPHandler(String string, int n, ConnectionType connectionType, String string2, Logger logger) {
        this(string, TransferMode.BINARY, n, connectionType, string2, logger);
    }

    public FTPHandler(String string, TransferMode transferMode, ConnectionType connectionType, String string2, Logger logger) {
        this(string, transferMode, 5000, connectionType, string2, logger);
    }

    public FTPHandler(String string, ConnectionType connectionType, String string2, Logger logger) {
        this(string, TransferMode.BINARY, 5000, connectionType, string2, logger);
    }

    private FTPHandler(String string, TransferMode transferMode, int n, ConnectionType connectionType, String string2, Logger logger) {
        this(FTPHandler.serverPart(string), FTPHandler.portPart(string), transferMode, n, connectionType, string2, logger);
    }

    private FTPHandler(String string, int n, TransferMode transferMode, int n2, ConnectionType connectionType, String string2, Logger logger) {
        this.logger = logger;
        if (this.isTracing) {
            this.log("Creating new Handler with server :" + string + " Port: " + n + " Transfer type: " + transferMode + " Timeout: " + n2 + " ConnectionType: " + connectionType + " Directory " + string2 + ".");
        }
        this.server = string;
        this.port = n;
        this.timeout = n2;
        this.connectionType = connectionType;
        this.directory = string2;
        if (this.isTracing) {
            this.log("Creating Handler complete.");
        }
    }

    private static final String serverPart(String string) {
        String string2 = string.trim();
        if (string2.length() == 0) {
            return string2;
        }
        if (string2.charAt(0) == '[') {
            int n = string2.lastIndexOf(93);
            if (-1 == n) {
                return string2;
            }
            return string2.substring(1, n);
        }
        int n = string2.lastIndexOf(58);
        if (-1 == n) {
            return string2;
        }
        return string2.substring(0, n);
    }

    private static final int portPart(String string) {
        int n;
        String string2 = string.trim();
        if (string2.length() == 0) {
            return 21;
        }
        if (string2.charAt(0) == '[') {
            n = string2.lastIndexOf(93);
            if (n == -1) {
                return 21;
            }
            string2 = string2.substring(n + 1);
        }
        n = 21;
        int n2 = string2.lastIndexOf(58);
        if (n2 != -1) {
            try {
                n = Integer.parseInt(string2.substring(n2 + 1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return FTPHandler.inRange(n, 1, 65535) ? n : 21;
    }

    private static final boolean inRange(int n, int n2, int n3) {
        return n2 <= n && n <= n3;
    }

    public boolean isTracing() {
        return this.isTracing;
    }

    public void setTracing(boolean bl) {
        this.isTracing = bl;
    }

    public synchronized void open(String string, String string2, String string3) throws Exception {
        if (this.isTracing) {
            this.log(this.className + ": Trying to open connection for user: " + string + " Account info: " + string3 + ". ");
        }
        try {
            if (this.remoteStatus != RemoteStatus.INIT) {
                throw this.ftpStateException("OPEN", this.server, "State:" + this.remoteStatus.toString());
            }
            this.user = string;
            this.password = string2;
            this.remoteStatus = RemoteStatus.FAILED;
            this.socket = new Socket();
            InetSocketAddress inetSocketAddress = new InetSocketAddress(this.server, this.port);
            if (inetSocketAddress.isUnresolved()) {
                throw this.ftpConnectException("OPEN", this.server, "Address unresolved for server address" + inetSocketAddress.toString() + ". ");
            }
            try {
                this.socket.connect(inetSocketAddress, this.timeout);
                this.socket.setSoTimeout(this.timeout);
            }
            catch (SocketException socketException) {
                this.log(socketException);
                throw this.ftpConnectException("OPEN", this.server, "timeout(" + this.timeout + "): " + String.valueOf(socketException.getMessage()));
            }
            catch (SocketTimeoutException socketTimeoutException) {
                this.log(socketTimeoutException);
                throw this.ftpConnectException("OPEN", this.server, "timeout(" + this.timeout + "): " + String.valueOf(socketTimeoutException.getMessage()));
            }
            catch (IOException iOException) {
                this.log(iOException);
                throw this.ftpConnectException("OPEN", this.server, "socket I/O: " + String.valueOf(iOException.getMessage()));
            }
            try {
                this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), ENCODING));
                this.out = new PrintWriter((Writer)new OutputStreamWriter(this.socket.getOutputStream(), ENCODING), true);
            }
            catch (IOException iOException) {
                this.log(iOException);
                throw this.ftpConnectException("OPEN", this.server, "stream I/O: " + String.valueOf(iOException.getMessage()));
            }
            try {
                this.receiveResponse(CONNECT);
            }
            catch (Exception exception) {
                this.log(exception);
                throw this.ftpConnectException("OPEN", this.server, "protocol: " + String.valueOf(exception.getMessage()));
            }
            if (!this.isPositiveReplyType()) {
                throw this.ftpConnectException("OPEN", this.server, "refused: " + this.getReply());
            }
            this.login(string, string2, string3);
            this.initSystemType();
            this.remoteStatus = RemoteStatus.OPEN;
            this.setServerDirectory(this.directory);
        }
        catch (FtpException.Login login) {
            this.log(login);
            this.close();
            throw login;
        }
        catch (FtpException.Protocol protocol) {
            this.log(protocol);
            this.close();
            throw protocol;
        }
        catch (Exception exception) {
            this.log(exception);
            this.close();
            throw exception;
        }
        finally {
            if (this.isTracing) {
                this.log(this.className + ": " + "OPEN" + " has ended execution.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveResponse(String string) throws Exception {
        if (this.isTracing) {
            this.log("RECEIVE RESPONSE: Initiating response receipt.");
        }
        try {
            String string2 = "";
            String string3 = "";
            try {
                while (!this.testAndSetReply(string2 = this.log(this.in.readLine()))) {
                    string3 = string3 + string2 + "\n";
                }
            }
            catch (IOException iOException) {
                this.log(iOException);
                throw this.ftpProtocolException("RECEIVE RESPONSE", this.server, string + "=>response: " + string3);
            }
            if (!ProtocolChecker.isValidReplyCode(string, this.getReplyCode())) {
                throw this.ftpProtocolException("RECEIVE RESPONSE", this.server, string + "=>response: " + this.getReply());
            }
        }
        finally {
            if (this.isTracing) {
                this.log("RECEIVE RESPONSE :Ended execution of response receipt.");
            }
        }
    }

    private boolean testAndSetReply(String string) throws IOException {
        if (string == null) {
            throw new IOException("End of Stream reached");
        }
        if (string.length() <= 3) {
            return false;
        }
        if (!(string.charAt(3) == ' ' && Character.isDigit(string.charAt(0)) && Character.isDigit(string.charAt(1)) && Character.isDigit(string.charAt(2)))) {
            return false;
        }
        this.reply = string;
        this.replyCode = string.substring(0, 3);
        this.replyText = string.substring(4);
        return true;
    }

    private String getReplyCode() {
        return this.replyCode;
    }

    private String log(String string) {
        this.logs.add(new Timestamp(System.currentTimeMillis()).toString() + " " + string);
        if (this.writeLogToScreen) {
            this.logger.log(string, true);
        }
        return string;
    }

    private String log(Exception exception) {
        String string;
        block2: {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            string = exception.toString();
            try {
                exception.printStackTrace(printWriter);
                string = string + stringWriter.getBuffer().toString();
            }
            catch (Exception exception2) {
                if (!this.writeLogToScreen) break block2;
                this.logger.log("Exception occurred while logging the Exception to the log file: " + exception.getMessage(), exception);
            }
        }
        return this.log(string);
    }

    private boolean writeLogsToFile() {
        boolean bl = false;
        File file = new File("c:/Temp/runmqrasFtpLogFile.txt");
        try {
            file.createNewFile();
            FileWriter fileWriter = new FileWriter(file);
            for (int i = 0; i < this.logs.size(); ++i) {
                String string = this.logs.get(i);
                fileWriter.write(string);
                fileWriter.write("\n");
            }
            fileWriter.close();
            this.logger.log("FTPHandler Log file created.", true);
            bl = true;
        }
        catch (IOException iOException) {
            this.logger.log("An error occurred in writing the FTPHandler log file.", true);
            this.log(iOException);
        }
        return bl;
    }

    private boolean isPositiveReplyType() {
        switch (this.getReplyCode().charAt(0)) {
            case '1': 
            case '2': {
                return true;
            }
        }
        return false;
    }

    private String getReply() {
        return this.reply;
    }

    private String getReplyText() {
        return this.replyText;
    }

    private void login(String string, String string2, String string3) throws Exception {
        if (this.isTracing) {
            this.log("LOGIN: Logging in intiated.");
        }
        try {
            this.command(CMD_USER, string);
            if (this.getReplyCode().equals("331")) {
                this.command(CMD_PASS, string2);
            }
            if (this.getReplyCode().equals("332") || this.isPositiveReplyType() && string3.length() > 0) {
                this.command(CMD_ACCT, string3);
            }
            if (!this.isPositiveReplyType()) {
                throw this.ftpLoginException("LOGIN", this.server, string, this.getReply());
            }
        }
        catch (Exception exception) {
            this.log(exception);
            throw this.ftpLoginException("LOGIN", this.server, string, this.getReply());
        }
        finally {
            if (this.isTracing) {
                this.log("LOGIN: Ended execution for logging in.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void command(String string, String string2) throws Exception {
        if (this.isTracing) {
            if (string.equals(CMD_PASS)) {
                this.log("COMMAND : Sending command " + string + " ********. ");
            } else {
                this.log("COMMAND : Sending command " + string + " " + string2 + ". ");
            }
        }
        try {
            if (this.out == null) {
                return;
            }
            this.out.print(this.log(string + string2) + "\r\n");
            this.out.flush();
            this.receiveResponse(string);
        }
        finally {
            if (this.isTracing) {
                this.log("COMMAND : Sending command execution ended.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getServerDirectory() throws Exception {
        if (this.isTracing) {
            this.log("GET SERVER DIRECTORY : Getting server directory initiated.");
        }
        try {
            if (this.remoteStatus != RemoteStatus.OPEN) {
                throw new Exception();
            }
            this.command(CMD_PWD);
            String string = this.getReplyText();
            int n = string.lastIndexOf("\"");
            if (n == -1) {
                String string2 = null;
                return string2;
            }
            int n2 = string.indexOf("\"");
            if (n2 == n) {
                String string3 = null;
                return string3;
            }
            String string4 = string.substring(n2 + 1, n);
            return string4;
        }
        finally {
            if (this.isTracing) {
                this.log("GET SERVER DIRECTORY : Ended Execution for get server directory.");
            }
        }
    }

    private void command(String string) throws Exception {
        this.command(string, "");
    }

    public void setServerDirectory(String string) throws Exception {
        if (this.isTracing) {
            this.log("SET SERVER DIRECTORY: Changing Server Directory to " + string);
        }
        try {
            if (this.remoteStatus != RemoteStatus.OPEN) {
                throw this.ftpStateException("SET SERVER DIRECTORY", this.server, "State:" + this.remoteStatus.toString());
            }
            this.command(CMD_CWD, string);
            if (!this.isPositiveReplyType()) {
                throw this.ftpConnectException("SET SERVER DIRECTORY", this.server, CMD_CWD + string + "=>" + this.getReply());
            }
        }
        finally {
            if (this.isTracing) {
                this.log("SET SERVER DIRECTORY: Execution ended for setting server directory to " + string);
            }
        }
    }

    private void initSystemType() {
        if (this.isTracing) {
            this.log("INITIALISE SYSTEM TYPE: Initialising System Type.");
        }
        try {
            this.command(CMD_SYST);
        }
        catch (Exception exception) {
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        if (this.isTracing) {
            this.log("INITIALISE SYSTEM TYPE: Initialising System Type complete.");
        }
    }

    public synchronized void makeDirectory(String string) throws Exception {
        if (this.isTracing) {
            this.log("MAKE DIRECTORY: Making Directory initiated for directory " + string);
        }
        try {
            if (this.remoteStatus != RemoteStatus.OPEN) {
                throw this.ftpStateException("MAKE DIRECTORY", this.server, "State:" + this.remoteStatus.toString());
            }
            this.command(CMD_MKD, string);
        }
        finally {
            if (this.isTracing) {
                this.log("MAKE DIRECTORY: Exceution ended for directory creation.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void putBinaryStream(InputStream inputStream, String string, long l) throws Exception {
        if (this.isTracing) {
            this.log("PUT BINARY STREAM: Initiated trying to put binary stream.");
        }
        try {
            if (this.remoteStatus != RemoteStatus.OPEN) {
                throw this.ftpStateException("PUT BINARY STREAM", this.server, "State:" + this.remoteStatus.toString());
            }
            if (inputStream == null) {
                throw this.ftpTransferException("PUT BINARY STREAM", this.server, string, "null InputStream");
            }
            Socket socket = null;
            OutputStream outputStream = null;
            try {
                this.setServerTransferMode(TransferMode.BINARY);
                socket = this.getDataSocket(CMD_STOR, string, l);
                if (null != socket) {
                    outputStream = socket.getOutputStream();
                    this.pumpInputStreamToStream(inputStream, outputStream);
                }
            }
            catch (IOException iOException) {
                this.log(iOException);
                throw this.ftpTransferException("PUT BINARY STREAM", this.server, string, "stream I/O:");
            }
            finally {
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {
                        this.log(iOException);
                    }
                }
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {
                        this.log(iOException);
                    }
                }
            }
            if (socket != null) {
                this.receiveResponse(CMD_STOR);
            }
            if (!this.isPositiveReplyType()) {
                throw this.ftpTransferException("PUT BINARY STREAM", this.server, string, this.getReply());
            }
        }
        finally {
            if (this.isTracing) {
                this.log("PUT BINARY STREAM: Execution ended for putting binary stream.");
            }
        }
    }

    private void pumpInputStreamToStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        int n2 = inputStream.available();
        int n3 = this.transferBuffer.length;
        int n4 = 1;
        int n5 = 1;
        int n6 = 0;
        while ((n = inputStream.read(this.transferBuffer)) != -1) {
            outputStream.write(this.transferBuffer, 0, n);
            n5 = n4 * 100 * n3 / n2;
            if (n5 > 100) {
                n5 = 100;
            }
            if (n5 / 10 > n6) {
                this.logger.log("Transferred: " + n5 / 10 * 10 + " %.", true);
                this.logger.log("", true);
                ++n6;
            }
            ++n4;
        }
    }

    private void setServerTransferMode(TransferMode transferMode) throws Exception {
        String string = transferMode == TransferMode.ASCII ? MODE_ASCII : MODE_BINARY;
        this.command(CMD_TYPE, string);
        if (!this.isPositiveReplyType()) {
            throw this.ftpProtocolException("setServerTransferType", this.server, CMD_TYPE + string + "=>" + this.getReply());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Socket getDataSocket(String string, String string2, long l) throws Exception {
        if (this.isTracing) {
            this.log("GET DATA SOCKET: Initiated getting data socket.");
        }
        Socket socket = null;
        try {
            ServerSocket serverSocket = null;
            if (this.connectionType == ConnectionType.PASSIVE) {
                socket = this.getPassiveDataSocket();
            } else {
                serverSocket = this.getActiveDataSocket();
            }
            try {
                if (l > 0L) {
                    this.command(CMD_REST, Long.toString(l));
                }
                this.command(string, string2);
            }
            catch (Exception exception) {
                try {
                    if (socket != null) {
                        socket.close();
                    }
                    if (serverSocket != null) {
                        serverSocket.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw exception;
            }
            if (!this.isPositiveReplyType()) {
                try {
                    if (socket != null) {
                        socket.close();
                    }
                    if (serverSocket != null) {
                        serverSocket.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (this.getReplyCode().indexOf("550") != -1) {
                    throw this.ftpFileException("GET DATA SOCKET", this.server, "protocol" + string + "=>" + this.getReply());
                }
                throw this.ftpConnectException("GET DATA SOCKET", this.server, "protocol: " + string + "=>" + this.getReply());
            }
            if (this.connectionType.equals(ConnectionType.ACTIVE)) {
                try {
                    socket = serverSocket.accept();
                    serverSocket.close();
                }
                catch (IOException iOException) {
                    this.log(iOException);
                    throw this.ftpConnectException("GET DATA SOCKET", this.server, "socket I/O:" + iOException.getMessage());
                }
            }
            Socket socket2 = socket;
            return socket2;
        }
        finally {
            if (this.isTracing) {
                this.log("GET DATA SOCKET: Ending execution for getting data socket");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Socket getPassiveDataSocket() throws Exception {
        if (this.isTracing) {
            this.log("GET PASSIVE DATA SOCKET: Method initiated");
        }
        Socket socket = null;
        try {
            int n;
            this.command(CMD_PASV);
            if (!this.isPositiveReplyType()) {
                throw this.ftpConnectException("GET PASSIVE DATA SOCKET", this.server, "create passive:" + this.getReply());
            }
            String[] stringArray = new String[6];
            String string = this.getReplyText();
            String string2 = string.substring(string.indexOf(40) + 1, string.lastIndexOf(41));
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            for (n = 0; n < 6; ++n) {
                stringArray[n] = stringTokenizer.nextToken();
            }
            n = Integer.parseInt(stringArray[4]) * 256 + Integer.parseInt(stringArray[5]);
            socket = new Socket();
            InetSocketAddress inetSocketAddress = new InetSocketAddress(this.server, n);
            try {
                socket.connect(inetSocketAddress, this.timeout);
                socket.setSoTimeout(this.timeout);
            }
            catch (SocketException socketException) {
                this.log(socketException);
                throw this.ftpConnectException("GET PASSIVE DATA SOCKET", ((Object)inetSocketAddress).toString(), "timeout(" + this.timeout + ")");
            }
            catch (SocketTimeoutException socketTimeoutException) {
                this.log(socketTimeoutException);
                throw this.ftpConnectException("GET PASSIVE DATA SOCKET", ((Object)inetSocketAddress).toString(), "timeout(" + this.timeout + ")");
            }
            catch (IOException iOException) {
                this.log(iOException);
                throw this.ftpConnectException("GET PASSIVE DATA SOCKET", ((Object)inetSocketAddress).toString(), "socket I/O:" + iOException.getMessage());
            }
            Socket socket2 = socket;
            return socket2;
        }
        finally {
            if (this.isTracing) {
                this.log("GET PASSIVE DATA SOCKET: Execution ended for getting passive data socket");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerSocket getActiveDataSocket() throws Exception {
        if (this.isTracing) {
            this.log("GET ACTIVE DATA SOCKET: Initiated getting active data socket.");
        }
        ServerSocket serverSocket = null;
        try {
            Object object;
            int[] nArray = new int[6];
            InetAddress inetAddress = this.socket.getLocalAddress();
            String string = inetAddress.getHostAddress();
            try {
                serverSocket = new ServerSocket(0);
            }
            catch (IOException iOException) {
                this.log(iOException);
                throw this.ftpConnectException("GET ACTIVE DATA SOCKET", this.server, "ServerSocket I/O:" + iOException.getMessage());
            }
            int n = serverSocket.getLocalPort();
            if (inetAddress instanceof Inet6Address) {
                object = "|2|" + string + "|" + n + "|";
                this.command(CMD_EPRT, (String)object);
                if (!this.isPositiveReplyType()) {
                    throw this.ftpConnectException("GET ACTIVE DATA SOCKET", this.server, "create ipv6 active:" + this.getReply());
                }
            } else {
                object = new StringTokenizer(string, ".");
                for (int i = 0; i < 4; ++i) {
                    nArray[i] = Integer.parseInt(((StringTokenizer)object).nextToken());
                }
                nArray[4] = n / 256;
                nArray[5] = n % 256;
                String string2 = String.valueOf(nArray[0]);
                for (int i = 1; i < nArray.length; ++i) {
                    string2 = string2 + "," + String.valueOf(nArray[i]);
                }
                this.command(CMD_PORT, string2);
                if (!this.isPositiveReplyType()) {
                    throw this.ftpConnectException("GET ACTIVE DATA SOCKET", this.server, "create ipv4 active:" + this.getReply());
                }
            }
            object = serverSocket;
            return object;
        }
        finally {
            if (this.isTracing) {
                this.log("GET ACTIVE DATA SOCKET: Ended execution for getting passive data socket");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void close() throws Exception {
        if (this.isTracing) {
            this.log("CLOSE: Initiated trying to close connection.");
        }
        try {
            block31: {
                if (this.remoteStatus == RemoteStatus.INIT) {
                    return;
                }
                try {
                    this.command(CMD_QUIT);
                    if (this.out != null) {
                        this.out.close();
                    }
                    if (this.in == null) break block31;
                }
                catch (Exception exception) {
                    if (this.out != null) {
                        this.out.close();
                    }
                    if (this.in != null) {
                        try {
                            this.in.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (this.socket != null) {
                        try {
                            this.socket.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    this.in = null;
                    this.out = null;
                    this.socket = null;
                    this.remoteStatus = RemoteStatus.CLOSED;
                    return;
                }
                catch (Throwable throwable) {
                    if (this.out != null) {
                        this.out.close();
                    }
                    if (this.in != null) {
                        try {
                            this.in.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (this.socket != null) {
                        try {
                            this.socket.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    this.in = null;
                    this.out = null;
                    this.socket = null;
                    this.remoteStatus = RemoteStatus.CLOSED;
                    throw throwable;
                }
                try {
                    this.in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.in = null;
            this.out = null;
            this.socket = null;
            this.remoteStatus = RemoteStatus.CLOSED;
            return;
        }
        finally {
            if (this.isTracing) {
                this.log("CLOSE: Ended Execution for closing the connection.");
            }
            if (this.writeLogToFile) {
                this.writeLogsToFile();
            }
        }
    }

    public boolean isWriteLogToFile() {
        return this.writeLogToFile;
    }

    public void setWriteLogToFile(boolean bl) {
        this.writeLogToFile = bl;
    }

    public boolean isWriteLogToScreen() {
        return this.writeLogToScreen;
    }

    public void setWriteLogToScreen(boolean bl) {
        this.writeLogToScreen = bl;
    }

    protected final FtpException.Login ftpLoginException(String string, String string2, String string3, String string4) {
        FtpException ftpException = new FtpException();
        return ftpException.ftpLoginException(string, string2, string3, string4);
    }

    private FtpException.Connect ftpConnectException(String string, String string2, String string3) {
        FtpException ftpException = new FtpException();
        return ftpException.ftpConnectException(string, string2, string3);
    }

    private FtpException.State ftpStateException(String string, String string2, String string3) {
        FtpException ftpException = new FtpException();
        return ftpException.ftpStateException(string, string2, string3);
    }

    private Exception ftpProtocolException(String string, String string2, String string3) {
        FtpException ftpException = new FtpException();
        return ftpException.ftpProtocolException(string, string2, string3);
    }

    private Exception ftpFileException(String string, String string2, String string3) {
        FtpException ftpException = new FtpException();
        return ftpException.ftpFileException(string, string2, string3);
    }

    private Exception ftpTransferException(String string, String string2, String string3, String string4) {
        FtpException ftpException = new FtpException();
        return ftpException.ftpStateTransfer(string, string2, string3, string4);
    }

    private static final class ProtocolChecker {
        public static String[] listOfcodes = new String[]{"FTP_INIT120", "FTP_INIT220", "FTP_INIT421", "ACCT 230", "ACCT 202", "ACCT 530", "ACCT 500", "ACCT 501", "ACCT 503", "ACCT 421", "CDUP200", "CDUP500", "CDUP501", "CDUP502", "CDUP421", "CDUP530", "CDUP550", "CWD 250", "CWD 500", "CWD 501", "CWD 502", "CWD 421", "CWD 530", "CWD 550", "DELE 250", "DELE 450", "DELE 550", "DELE 500", "DELE 501", "DELE 502", "DELE 421", "DELE 530", "EPRT 200", "EPRT 500", "EPRT 501", "EPRT 421", "EPRT 530", "EPRT 522", "LIST125", "LIST150", "LIST226", "LIST250", "LIST425", "LIST426", "LIST451", "LIST450", "LIST500", "LIST501", "LIST502", "LIST421", "LIST530", "NLST125", "NLST150", "NLST226", "NLST250", "NLST425", "NLST426", "NLST451", "NLST450", "NLST500", "NLST501", "NLST502", "NLST421", "NLST530", "MKD 257", "MKD 500", "MKD 501", "MKD 502", "MKD 421", "MKD 530", "MKD 550", "PASV227", "PASV500", "PASV501", "PASV502", "PASV421", "PASV530", "PASS 230", "PASS 202", "PASS 530", "PASS 500", "PASS 501", "PASS 503", "PASS 421", "PASS 332", "PORT 200", "PORT 500", "PORT 501", "PORT 421", "PORT 530", "PWD257", "PWD500", "PWD501", "PWD502", "PWD421", "PWD550", "QUIT221", "QUIT500", "RETR 125", "RETR 150", "RETR 226", "RETR 250", "RETR 425", "RETR 426", "RETR 451", "RETR 450", "RETR 550", "RETR 500", "RETR 501", "RETR 421", "RETR 530", "RNFR 450", "RNFR 550", "RNFR 500", "RNFR 501", "RNFR 502", "RNFR 421", "RNFR 530", "RNFR 350", "RNTO 250", "RNTO 532", "RNTO 553", "RNTO 500", "RNTO 501", "RNTO 502", "RNTO 503", "RNTO 421", "RNTO 530", "REST 500", "REST 501", "REST 502", "REST 421", "REST 530", "REST 350", "RMD 250", "RMD 500", "RMD 501", "RMD 502", "RMD 421", "RMD 530", "RMD 550", "STOR 125", "STOR 150", "STOR 226", "STOR 250", "STOR 425", "STOR 426", "STOR 451", "STOR 551", "STOR 552", "STOR 532", "STOR 450", "STOR 452", "STOR 553", "STOR 500", "STOR 501", "STOR 421", "STOR 530", "SYST215", "SYST500", "SYST501", "SYST502", "SYST421", "TYPE 200", "TYPE 500", "TYPE 501", "TYPE 504", "TYPE 421", "TYPE 530", "USER 230", "USER 530", "USER 500", "USER 501", "USER 421", "USER 331", "USER 332"};
        private static final Set<String> validCmdReplyCodes = new HashSet<String>(Arrays.asList(listOfcodes));

        private ProtocolChecker() {
        }

        public static final boolean isValidReplyCode(String string, String string2) {
            return validCmdReplyCodes.contains(string + string2);
        }
    }

    protected static class RemoteStatus {
        private final String status;
        public static final RemoteStatus INIT = new RemoteStatus("init");
        public static final RemoteStatus FAILED = new RemoteStatus("failed");
        public static final RemoteStatus OPEN = new RemoteStatus("open");
        public static final RemoteStatus CLOSED = new RemoteStatus("closed");
        public static final RemoteStatus TRANSFER = new RemoteStatus("transfer");

        private RemoteStatus(String string) {
            this.status = string;
        }

        public String toString() {
            return this.status;
        }
    }

    public static class ConnectionType {
        private final String connectionType;
        public static final ConnectionType ACTIVE = new ConnectionType("active");
        public static final ConnectionType PASSIVE = new ConnectionType("passive");

        private ConnectionType(String string) {
            this.connectionType = string;
        }

        public String toString() {
            return this.connectionType;
        }
    }

    public static class TransferMode {
        private final String mode;
        public static final TransferMode ASCII = new TransferMode("ascii");
        public static final TransferMode BINARY = new TransferMode("binary");

        private TransferMode(String string) {
            this.mode = string;
        }

        public String toString() {
            return this.mode;
        }
    }
}

