/*
 * Decompiled with CFR 0.152.
 */
package crtmqras;

import crtmqras.Logger;
import crtmqras.Registry;
import crtmqras.ZipFolder;
import crtmqras.Zipper;
import java.io.File;
import java.util.Map;

public class CommandProcessor {
    public static final String SHORT_COPYRIGHT_STRING = "(c) Copyright IBM Corporation 2005, 2008";
    public static final String SCCSID = "@(#) MQMBID sn=p940-016-251008 su=f957d47a17fac92e5ee99e3c0e497737e112aed5 pn=cmd/tools/com.ibm.mq.tools.ras/src/crtmqras/CommandProcessor.java";
    public static final String LONG_COPYRIGHT_STRING = "Licensed Materials - Property of IBM 63H9336 (c) Copyright IBM Corp. 2005, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String OS_NAME;
    private String ISupportSanitizer;
    private boolean demoMode;
    private Registry reg;
    private Logger logger;

    private void init(ZipFolder zipFolder, boolean bl, String string, Logger logger, Registry registry) {
        this.OS_NAME = string;
        this.demoMode = bl;
        this.logger = logger;
        this.reg = registry;
        this.ISupportSanitizer = System.getProperty("AMQ_I_SUPPORT_SANITIZER");
    }

    public CommandProcessor(ZipFolder zipFolder, boolean bl, String string, Logger logger, Registry registry) {
        this.init(zipFolder, bl, string, logger, registry);
    }

    private synchronized void runCommand(String string, int n, String string2, boolean bl) throws Exception {
        ProcessBuilder processBuilder;
        String string3 = "Executing: '" + string;
        string3 = n > 0 ? string3 + "' with a timeout of " + n : "' with an indefinite timeout!";
        this.logger.log(string3);
        if (!this.OS_NAME.equals("Windows")) {
            if (this.OS_NAME.equals("OS/400")) {
                processBuilder = new ProcessBuilder("/bin/qsh", "-c", string);
            } else {
                processBuilder = new ProcessBuilder("/bin/sh", "-c", string);
                if (this.ISupportSanitizer != null && !bl) {
                    Map<String, String> map = processBuilder.environment();
                    this.logger.log("Unsetting LD_PRELOAD before invoking non-MQ program");
                    map.remove("LD_PRELOAD");
                }
            }
        } else {
            processBuilder = new ProcessBuilder("cmd", "/C", string);
        }
        if (string2 != null && 0 != string2.length()) {
            boolean bl2 = true;
            String string4 = Zipper.WORK_DIRECTORY_NAME;
            File file = new File(string4 + File.separator + string2);
            if (!file.exists()) {
                if (!file.mkdirs()) {
                    this.logger.log("Failed to create directory " + string2 + ", using default working directory");
                    bl2 = false;
                }
            } else if (!file.isDirectory()) {
                this.logger.log(string4 + File.separator + string2 + " exists but is not a directory, using default working directory");
                bl2 = false;
            }
            if (bl2) {
                processBuilder.directory(file);
            }
        }
        Process process = processBuilder.start();
        int n2 = 99;
        if (n > 0) {
            int n3 = n * 10;
            while (n3 > 0) {
                try {
                    n2 = process.exitValue();
                    n3 = 0;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    Thread.currentThread();
                    Thread.sleep(100L);
                    --n3;
                }
            }
        } else {
            try {
                n2 = process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                this.logger.log("CommandProcessor", "cmd: '" + string + "' failed due to: " + interruptedException.toString());
            }
        }
        process.destroy();
        if (n2 > 0) {
            throw new Exception("ERROR: runCommand: process exitValue = " + n2);
        }
    }

    public synchronized void run(String string, int n, boolean bl) {
        this.run(string, n, "", bl);
    }

    public synchronized void run(String string, int n, String string2, boolean bl) {
        String string3 = string;
        if (this.demoMode) {
            this.logger.log("run: " + string3);
        } else {
            if (this.OS_NAME.equals("Windows")) {
                string3 = "cmd /C " + string3;
            }
            try {
                this.runCommand(string3, n, string2, bl);
            }
            catch (Exception exception) {
                this.logger.log("    command " + string3);
                this.logger.log("    failed with following message:");
                this.logger.log("    " + exception.getMessage());
            }
        }
    }
}

