      ******************************************************************
      **                                                              **
      **                      IBM MQ for Windows                      **
      **                                                              **
      **  FILE NAME:      CMQXV                                       **
      **                                                              **
      **  DESCRIPTION:    Declarations for Exits and MQCD             **
      **                                                              **
      ******************************************************************
      **  <copyright                                                  **
      **  notice="lm-source-program"                                  **
      **  pids="5724-H72,5655-R36,5724-L26"                           **
      **  years="1993,2025"                                           **
      **  crc="1616507131" >                                          **
      **  Licensed Materials - Property of IBM                        **
      **                                                              **
      **  5724-H72                                                    **
      **                                                              **
      **  (C) Copyright IBM Corp. 1993, 2025 All Rights Reserved.     **
      **                                                              **
      **  US Government Users Restricted Rights - Use, duplication or **
      **  disclosure restricted by GSA ADP Schedule Contract with     **
      **  IBM Corp.                                                   **
      **  </copyright>                                                **
      ******************************************************************
      **                                                              **
      **  FUNCTION:       This file declares the functions,           **
      **                  structures and named constants for exits    **
      **                  and MQCD.                                   **
      **                                                              **
      **  PROCESSOR:      COBOL                                       **
      **                                                              **
      ******************************************************************

      ******************************************************************
      ** <BEGIN_BUILDINFO>                                            **
      ** Generated on:  07/10/25 14:42                                **
      ** Build Level:   p930-035-251007                               **
      ** Build Type:    Production                                    **
      ** Pointer Size:  64 Bit                                        **
      ** Source File:                                                 **
      ** CMQXV                                                        **
      ** <END_BUILDINFO>                                              **
      ******************************************************************

      ******************************************************************
      **  Values Related to MQCD Structure                         
      ******************************************************************
      ** Structure Version Number
       10  MQCD-VERSION-1   PIC S9(9) BINARY VALUE 1.
       10  MQCD-VERSION-2   PIC S9(9) BINARY VALUE 2.
       10  MQCD-VERSION-3   PIC S9(9) BINARY VALUE 3.
       10  MQCD-VERSION-4   PIC S9(9) BINARY VALUE 4.
       10  MQCD-VERSION-5   PIC S9(9) BINARY VALUE 5.
       10  MQCD-VERSION-6   PIC S9(9) BINARY VALUE 6.
       10  MQCD-VERSION-7   PIC S9(9) BINARY VALUE 7.
       10  MQCD-VERSION-8   PIC S9(9) BINARY VALUE 8.
       10  MQCD-VERSION-9   PIC S9(9) BINARY VALUE 9.
       10  MQCD-VERSION-10   PIC S9(9) BINARY VALUE 10.
       10  MQCD-VERSION-11   PIC S9(9) BINARY VALUE 11.
       10  MQCD-VERSION-12   PIC S9(9) BINARY VALUE 12.
       10  MQCD-CURRENT-VERSION   PIC S9(9) BINARY VALUE 12.

      ** Structure Length
       10  MQCD-LENGTH-1   PIC S9(9) BINARY VALUE 984.
       10  MQCD-LENGTH-2   PIC S9(9) BINARY VALUE 1312.
       10  MQCD-LENGTH-3   PIC S9(9) BINARY VALUE 1480.
       10  MQCD-LENGTH-4   PIC S9(9) BINARY VALUE 1568.
       10  MQCD-LENGTH-5   PIC S9(9) BINARY VALUE 1584.
       10  MQCD-LENGTH-6   PIC S9(9) BINARY VALUE 1688.
       10  MQCD-LENGTH-7   PIC S9(9) BINARY VALUE 1792.
       10  MQCD-LENGTH-8   PIC S9(9) BINARY VALUE 1888.
       10  MQCD-LENGTH-9   PIC S9(9) BINARY VALUE 1912.
       10  MQCD-LENGTH-10   PIC S9(9) BINARY VALUE 1920.
       10  MQCD-LENGTH-11   PIC S9(9) BINARY VALUE 1984.
       10  MQCD-LENGTH-12   PIC S9(9) BINARY VALUE 1992.
       10  MQCD-CURRENT-LENGTH   PIC S9(9) BINARY VALUE 1992.

      ** Channel Types
       10  MQCHT-SENDER   PIC S9(9) BINARY VALUE 1.
       10  MQCHT-SERVER   PIC S9(9) BINARY VALUE 2.
       10  MQCHT-RECEIVER   PIC S9(9) BINARY VALUE 3.
       10  MQCHT-REQUESTER   PIC S9(9) BINARY VALUE 4.
       10  MQCHT-ALL   PIC S9(9) BINARY VALUE 5.
       10  MQCHT-CLNTCONN   PIC S9(9) BINARY VALUE 6.
       10  MQCHT-SVRCONN   PIC S9(9) BINARY VALUE 7.
       10  MQCHT-CLUSRCVR   PIC S9(9) BINARY VALUE 8.
       10  MQCHT-CLUSSDR   PIC S9(9) BINARY VALUE 9.
       10  MQCHT-MQTT   PIC S9(9) BINARY VALUE 10.
       10  MQCHT-AMQP   PIC S9(9) BINARY VALUE 11.

      ** Channel Compression
       10  MQCOMPRESS-NOT-AVAILABLE   PIC S9(9) BINARY VALUE -1.
       10  MQCOMPRESS-NONE   PIC S9(9) BINARY VALUE 0.
       10  MQCOMPRESS-RLE   PIC S9(9) BINARY VALUE 1.
       10  MQCOMPRESS-ZLIBFAST   PIC S9(9) BINARY VALUE 2.
       10  MQCOMPRESS-ZLIBHIGH   PIC S9(9) BINARY VALUE 4.
       10  MQCOMPRESS-SYSTEM   PIC S9(9) BINARY VALUE 8.
       10  MQCOMPRESS-ANY   PIC S9(9) BINARY VALUE 268435455.

      ** Transport Types
       10  MQXPT-ALL   PIC S9(9) BINARY VALUE -1.
       10  MQXPT-LOCAL   PIC S9(9) BINARY VALUE 0.
       10  MQXPT-LU62   PIC S9(9) BINARY VALUE 1.
       10  MQXPT-TCP   PIC S9(9) BINARY VALUE 2.
       10  MQXPT-NETBIOS   PIC S9(9) BINARY VALUE 3.
       10  MQXPT-SPX   PIC S9(9) BINARY VALUE 4.
       10  MQXPT-DECNET   PIC S9(9) BINARY VALUE 5.
       10  MQXPT-UDP   PIC S9(9) BINARY VALUE 6.

      ** Put Authority
       10  MQPA-DEFAULT   PIC S9(9) BINARY VALUE 1.
       10  MQPA-CONTEXT   PIC S9(9) BINARY VALUE 2.
       10  MQPA-ONLY-MCA   PIC S9(9) BINARY VALUE 3.
       10  MQPA-ALTERNATE-OR-MCA   PIC S9(9) BINARY VALUE 4.

      ** Channel Data Conversion
       10  MQCDC-SENDER-CONVERSION   PIC S9(9) BINARY VALUE 1.
       10  MQCDC-NO-SENDER-CONVERSION   PIC S9(9) BINARY VALUE 0.

      ** MCA Types
       10  MQMCAT-PROCESS   PIC S9(9) BINARY VALUE 1.
       10  MQMCAT-THREAD   PIC S9(9) BINARY VALUE 2.

      ** NonPersistent-Message Speeds
       10  MQNPMS-NORMAL   PIC S9(9) BINARY VALUE 1.
       10  MQNPMS-FAST   PIC S9(9) BINARY VALUE 2.

      ** SSL Client Authentication
       10  MQSCA-REQUIRED   PIC S9(9) BINARY VALUE 0.
       10  MQSCA-OPTIONAL   PIC S9(9) BINARY VALUE 1.
       10  MQSCA-NEVER-REQUIRED   PIC S9(9) BINARY VALUE 2.

      ** KeepAlive Interval
       10  MQKAI-AUTO   PIC S9(9) BINARY VALUE -1.

      ** Connection Affinity Values
       10  MQCAFTY-NONE   PIC S9(9) BINARY VALUE 0.
       10  MQCAFTY-PREFERRED   PIC S9(9) BINARY VALUE 1.

      ** Client Reconnect
       10  MQRCN-NO   PIC S9(9) BINARY VALUE 0.
       10  MQRCN-YES   PIC S9(9) BINARY VALUE 1.
       10  MQRCN-Q-MGR   PIC S9(9) BINARY VALUE 2.
       10  MQRCN-DISABLED   PIC S9(9) BINARY VALUE 3.

      ** Protocol
       10  MQPROTO-MQTTV3   PIC S9(9) BINARY VALUE 1.
       10  MQPROTO-HTTP   PIC S9(9) BINARY VALUE 2.
       10  MQPROTO-AMQP   PIC S9(9) BINARY VALUE 3.
       10  MQPROTO-MQTTV311   PIC S9(9) BINARY VALUE 4.

      ** Security Protocol
       10  MQSECPROT-NONE   PIC S9(9) BINARY VALUE 0.
       10  MQSECPROT-SSLV30   PIC S9(9) BINARY VALUE 1.
       10  MQSECPROT-TLSV10   PIC S9(9) BINARY VALUE 2.
       10  MQSECPROT-TLSV12   PIC S9(9) BINARY VALUE 4.
       10  MQSECPROT-TLSV13   PIC S9(9) BINARY VALUE 8.

      ** SPL Protection
       10  MQSPL-PASSTHRU   PIC S9(9) BINARY VALUE 0.
       10  MQSPL-REMOVE   PIC S9(9) BINARY VALUE 1.
       10  MQSPL-AS-POLICY   PIC S9(9) BINARY VALUE 2.

      ******************************************************************
      **  Values Related to MQDXP Structure                        
      ******************************************************************
      ** Structure Identifier
       10  MQDXP-STRUC-ID   PIC X(4) VALUE 'DXP '.

      ** Structure Version Number
       10  MQDXP-VERSION-1   PIC S9(9) BINARY VALUE 1.
       10  MQDXP-VERSION-2   PIC S9(9) BINARY VALUE 2.
       10  MQDXP-CURRENT-VERSION   PIC S9(9) BINARY VALUE 2.

      ** Structure Length
       10  MQDXP-LENGTH-1   PIC S9(9) BINARY VALUE 44.
       10  MQDXP-LENGTH-2   PIC S9(9) BINARY VALUE 56.
       10  MQDXP-CURRENT-LENGTH   PIC S9(9) BINARY VALUE 56.

      ** Exit Response
       10  MQXDR-OK   PIC S9(9) BINARY VALUE 0.
       10  MQXDR-CONVERSION-FAILED   PIC S9(9) BINARY VALUE 1.

      ******************************************************************
      **  General Values Related to Exits                          
      ******************************************************************
      ** Exit Identifiers
       10  MQXT-API-CROSSING-EXIT   PIC S9(9) BINARY VALUE 1.
       10  MQXT-API-EXIT   PIC S9(9) BINARY VALUE 2.
       10  MQXT-CHANNEL-SEC-EXIT   PIC S9(9) BINARY VALUE 11.
       10  MQXT-CHANNEL-MSG-EXIT   PIC S9(9) BINARY VALUE 12.
       10  MQXT-CHANNEL-SEND-EXIT   PIC S9(9) BINARY VALUE 13.
       10  MQXT-CHANNEL-RCV-EXIT   PIC S9(9) BINARY VALUE 14.
       10  MQXT-CHANNEL-MSG-RETRY-EXIT   PIC S9(9) BINARY VALUE 15.
       10  MQXT-CHANNEL-AUTO-DEF-EXIT   PIC S9(9) BINARY VALUE 16.
       10  MQXT-CLUSTER-WORKLOAD-EXIT   PIC S9(9) BINARY VALUE 20.
       10  MQXT-PUBSUB-ROUTING-EXIT   PIC S9(9) BINARY VALUE 21.
       10  MQXT-PUBLISH-EXIT   PIC S9(9) BINARY VALUE 22.
       10  MQXT-PRECONNECT-EXIT   PIC S9(9) BINARY VALUE 23.

      ** Exit Reasons
       10  MQXR-BEFORE   PIC S9(9) BINARY VALUE 1.
       10  MQXR-AFTER   PIC S9(9) BINARY VALUE 2.
       10  MQXR-CONNECTION   PIC S9(9) BINARY VALUE 3.
       10  MQXR-BEFORE-CONVERT   PIC S9(9) BINARY VALUE 4.
       10  MQXR-INIT   PIC S9(9) BINARY VALUE 11.
       10  MQXR-TERM   PIC S9(9) BINARY VALUE 12.
       10  MQXR-MSG   PIC S9(9) BINARY VALUE 13.
       10  MQXR-XMIT   PIC S9(9) BINARY VALUE 14.
       10  MQXR-SEC-MSG   PIC S9(9) BINARY VALUE 15.
       10  MQXR-INIT-SEC   PIC S9(9) BINARY VALUE 16.
       10  MQXR-RETRY   PIC S9(9) BINARY VALUE 17.
       10  MQXR-AUTO-CLUSSDR   PIC S9(9) BINARY VALUE 18.
       10  MQXR-AUTO-RECEIVER   PIC S9(9) BINARY VALUE 19.
       10  MQXR-CLWL-OPEN   PIC S9(9) BINARY VALUE 20.
       10  MQXR-CLWL-PUT   PIC S9(9) BINARY VALUE 21.
       10  MQXR-CLWL-MOVE   PIC S9(9) BINARY VALUE 22.
       10  MQXR-CLWL-REPOS   PIC S9(9) BINARY VALUE 23.
       10  MQXR-CLWL-REPOS-MOVE   PIC S9(9) BINARY VALUE 24.
       10  MQXR-END-BATCH   PIC S9(9) BINARY VALUE 25.
       10  MQXR-ACK-RECEIVED   PIC S9(9) BINARY VALUE 26.
       10  MQXR-AUTO-SVRCONN   PIC S9(9) BINARY VALUE 27.
       10  MQXR-AUTO-CLUSRCVR   PIC S9(9) BINARY VALUE 28.
       10  MQXR-SEC-PARMS   PIC S9(9) BINARY VALUE 29.
       10  MQXR-PUBLICATION   PIC S9(9) BINARY VALUE 30.
       10  MQXR-PRECONNECT   PIC S9(9) BINARY VALUE 31.

      ** Exit Responses
       10  MQXCC-OK   PIC S9(9) BINARY VALUE 0.
       10  MQXCC-SUPPRESS-FUNCTION   PIC S9(9) BINARY VALUE -1.
       10  MQXCC-SKIP-FUNCTION   PIC S9(9) BINARY VALUE -2.
       10  MQXCC-SEND-AND-REQUEST-SEC-MSG   PIC S9(9) BINARY VALUE -3.
       10  MQXCC-SEND-SEC-MSG   PIC S9(9) BINARY VALUE -4.
       10  MQXCC-SUPPRESS-EXIT   PIC S9(9) BINARY VALUE -5.
       10  MQXCC-CLOSE-CHANNEL   PIC S9(9) BINARY VALUE -6.
       10  MQXCC-REQUEST-ACK   PIC S9(9) BINARY VALUE -7.
       10  MQXCC-FAILED   PIC S9(9) BINARY VALUE -8.

      ** Exit User Area Value
       10  MQXUA-NONE   PIC X(16) VALUE LOW-VALUES.

      ** Cluster Cache Types
       10  MQCLCT-STATIC   PIC S9(9) BINARY VALUE 0.
       10  MQCLCT-DYNAMIC   PIC S9(9) BINARY VALUE 1.

      ** Multicast Events
       10  MQMCEV-PACKET-LOSS   PIC S9(9) BINARY VALUE 1.
       10  MQMCEV-HEARTBEAT-TIMEOUT   PIC S9(9) BINARY VALUE 2.
       10  MQMCEV-VERSION-CONFLICT   PIC S9(9) BINARY VALUE 3.
       10  MQMCEV-RELIABILITY   PIC S9(9) BINARY VALUE 4.
       10  MQMCEV-CLOSED-TRANS   PIC S9(9) BINARY VALUE 5.
       10  MQMCEV-STREAM-ERROR   PIC S9(9) BINARY VALUE 6.
       10  MQMCEV-NEW-SOURCE   PIC S9(9) BINARY VALUE 10.
       10  MQMCEV-RECEIVE-QUEUE-TRIMMED   PIC S9(9) BINARY VALUE 11.
       10  MQMCEV-PACKET-LOSS-NACK-EXPIRE   PIC S9(9) BINARY VALUE 12.
       10  MQMCEV-ACK-RETRIES-EXCEEDED   PIC S9(9) BINARY VALUE 13.
       10  MQMCEV-STREAM-SUSPEND-NACK   PIC S9(9) BINARY VALUE 14.
       10  MQMCEV-STREAM-RESUME-NACK   PIC S9(9) BINARY VALUE 15.
       10  MQMCEV-STREAM-EXPELLED   PIC S9(9) BINARY VALUE 16.
       10  MQMCEV-FIRST-MESSAGE   PIC S9(9) BINARY VALUE 20.
       10  MQMCEV-LATE-JOIN-FAILURE   PIC S9(9) BINARY VALUE 21.
       10  MQMCEV-MESSAGE-LOSS   PIC S9(9) BINARY VALUE 22.
       10  MQMCEV-SEND-PACKET-FAILURE   PIC S9(9) BINARY VALUE 23.
       10  MQMCEV-REPAIR-DELAY   PIC S9(9) BINARY VALUE 24.
       10  MQMCEV-MEMORY-ALERT-ON   PIC S9(9) BINARY VALUE 25.
       10  MQMCEV-MEMORY-ALERT-OFF   PIC S9(9) BINARY VALUE 26.
       10  MQMCEV-NACK-ALERT-ON   PIC S9(9) BINARY VALUE 27.
       10  MQMCEV-NACK-ALERT-OFF   PIC S9(9) BINARY VALUE 28.
       10  MQMCEV-REPAIR-ALERT-ON   PIC S9(9) BINARY VALUE 29.
       10  MQMCEV-REPAIR-ALERT-OFF   PIC S9(9) BINARY VALUE 30.
       10  MQMCEV-RELIABILITY-CHANGED   PIC S9(9) BINARY VALUE 31.
       10  MQMCEV-SHM-DEST-UNUSABLE   PIC S9(9) BINARY VALUE 80.
       10  MQMCEV-SHM-PORT-UNUSABLE   PIC S9(9) BINARY VALUE 81.
       10  MQMCEV-CCT-GETTIME-FAILED   PIC S9(9) BINARY VALUE 110.
       10  MQMCEV-DEST-INTERFACE-FAILURE   PIC S9(9) BINARY VALUE 120.
       10  MQMCEV-DEST-INTERFACE-FAILOVER   PIC S9(9) BINARY VALUE 121.
       10  MQMCEV-PORT-INTERFACE-FAILURE   PIC S9(9) BINARY VALUE 122.
       10  MQMCEV-PORT-INTERFACE-FAILOVER   PIC S9(9) BINARY VALUE 123.

      ******************************************************************
      **  Values Related to MQ_CLUSTER_WORKLOAD_EXIT Function      
      ******************************************************************
      ** Channel exit

      ******************************************************************
      **  Values Related to MQ_TRANSPORT_EXIT Function             
      ******************************************************************
      ** Channel exit
       10  MQTRANSPORTEXIT   PIC X(17) VALUE 'MQ_TRANSPORT_EXIT'.

      ******************************************************************
      **  Values Related to MQXCNVC Function                       
      ******************************************************************
      ** Conversion Options
       10  MQDCC-DEFAULT-CONVERSION   PIC S9(9) BINARY VALUE 1.
       10  MQDCC-FILL-TARGET-BUFFER   PIC S9(9) BINARY VALUE 2.
       10  MQDCC-INT-DEFAULT-CONVERSION   PIC S9(9) BINARY VALUE 4.
       10  MQDCC-SOURCE-ENC-NATIVE   PIC S9(9) BINARY VALUE 16.
       10  MQDCC-SOURCE-ENC-NORMAL   PIC S9(9) BINARY VALUE 16.
       10  MQDCC-SOURCE-ENC-REVERSED   PIC S9(9) BINARY VALUE 32.
       10  MQDCC-SOURCE-ENC-UNDEFINED   PIC S9(9) BINARY VALUE 0.
       10  MQDCC-TARGET-ENC-NATIVE   PIC S9(9) BINARY VALUE 256.
       10  MQDCC-TARGET-ENC-NORMAL   PIC S9(9) BINARY VALUE 256.
       10  MQDCC-TARGET-ENC-REVERSED   PIC S9(9) BINARY VALUE 512.
       10  MQDCC-TARGET-ENC-UNDEFINED   PIC S9(9) BINARY VALUE 0.
       10  MQDCC-NONE   PIC S9(9) BINARY VALUE 0.

      ** Conversion Options Masks and Factors
       10  MQDCC-SOURCE-ENC-MASK   PIC S9(9) BINARY VALUE 240.
       10  MQDCC-TARGET-ENC-MASK   PIC S9(9) BINARY VALUE 3840.
       10  MQDCC-SOURCE-ENC-FACTOR   PIC S9(9) BINARY VALUE 16.
       10  MQDCC-TARGET-ENC-FACTOR   PIC S9(9) BINARY VALUE 256.



      ******************************************************************
      **  End of CMQXV                                                **
      ******************************************************************
