      ******************************************************************
      **                                                              **
      **                      IBM MQ for Windows                      **
      **                                                              **
      **  FILE NAME:      CMQSDL                                      **
      **                                                              **
      **  DESCRIPTION:    MQSD Structure -- Subscription Descriptor   **
      **                                                              **
      ******************************************************************
      **  <copyright                                                  **
      **  notice="lm-source-program"                                  **
      **  pids="5724-H72,5655-R36,5724-L26"                           **
      **  years="1993,2025"                                           **
      **  crc="1616507131" >                                          **
      **  Licensed Materials - Property of IBM                        **
      **                                                              **
      **  5724-H72                                                    **
      **                                                              **
      **  (C) Copyright IBM Corp. 1993, 2025 All Rights Reserved.     **
      **                                                              **
      **  US Government Users Restricted Rights - Use, duplication or **
      **  disclosure restricted by GSA ADP Schedule Contract with     **
      **  IBM Corp.                                                   **
      **  </copyright>                                                **
      ******************************************************************
      **                                                              **
      **  FUNCTION:       This file declares the structure MQSD,      **
      **                  which is used by the main MQI.              **
      **                                                              **
      **  PROCESSOR:      COBOL                                       **
      **                                                              **
      ******************************************************************

      ******************************************************************
      ** <BEGIN_BUILDINFO>                                            **
      ** Generated on:  07/10/25 14:42                                **
      ** Build Level:   p930-035-251007                               **
      ** Build Type:    Production                                    **
      ** Pointer Size:  64 Bit                                        **
      ** Source File:                                                 **
      ** CMQSDL                                                       **
      ** <END_BUILDINFO>                                              **
      ******************************************************************

      ** MQSD structure
       10  MQSD.
      ** Structure identifier
       15  MQSD-STRUCID PIC X(4).
      ** Structure version number
       15  MQSD-VERSION PIC S9(9) BINARY.
      ** Options associated with subscribing
       15  MQSD-OPTIONS PIC S9(9) BINARY.
      ** Object name
       15  MQSD-OBJECTNAME PIC X(48).
      ** Alternate user identifier
       15  MQSD-ALTERNATEUSERID PIC X(12).
      ** Alternate security identifier
       15  MQSD-ALTERNATESECURITYID PIC X(40).
      ** Expiry of Subscription
       15  MQSD-SUBEXPIRY PIC S9(9) BINARY.
      ** Add padding to ensure that pointers start on correct
      ** boundaries
       15  FILLER  PIC S9(9) BINARY VALUE 0.
      ** Object long name
       15  MQSD-OBJECTSTRING.
      ** Address of variable length string
       20  MQSD-OBJECTSTRING-VSPTR POINTER.
      ** Offset of variable length string
       20  MQSD-OBJECTSTRING-VSOFFSET PIC S9(9) BINARY.
      ** Size of buffer
       20  MQSD-OBJECTSTRING-VSBUFSIZE PIC S9(9) BINARY.
      ** Length of variable length string
       20  MQSD-OBJECTSTRING-VSLENGTH PIC S9(9) BINARY.
      ** CCSID of variable length string
       20  MQSD-OBJECTSTRING-VSCCSID PIC S9(9) BINARY.
      ** Subscription name
       15  MQSD-SUBNAME.
      ** Address of variable length string
       20  MQSD-SUBNAME-VSPTR POINTER.
      ** Offset of variable length string
       20  MQSD-SUBNAME-VSOFFSET PIC S9(9) BINARY.
      ** Size of buffer
       20  MQSD-SUBNAME-VSBUFSIZE PIC S9(9) BINARY.
      ** Length of variable length string
       20  MQSD-SUBNAME-VSLENGTH PIC S9(9) BINARY.
      ** CCSID of variable length string
       20  MQSD-SUBNAME-VSCCSID PIC S9(9) BINARY.
      ** Subscription user data
       15  MQSD-SUBUSERDATA.
      ** Address of variable length string
       20  MQSD-SUBUSERDATA-VSPTR POINTER.
      ** Offset of variable length string
       20  MQSD-SUBUSERDATA-VSOFFSET PIC S9(9) BINARY.
      ** Size of buffer
       20  MQSD-SUBUSERDATA-VSBUFSIZE PIC S9(9) BINARY.
      ** Length of variable length string
       20  MQSD-SUBUSERDATA-VSLENGTH PIC S9(9) BINARY.
      ** CCSID of variable length string
       20  MQSD-SUBUSERDATA-VSCCSID PIC S9(9) BINARY.
      ** Correlation Id related to this subscription
       15  MQSD-SUBCORRELID PIC X(24).
      ** Priority set in publications
       15  MQSD-PUBPRIORITY PIC S9(9) BINARY.
      ** Accounting Token set in publications
       15  MQSD-PUBACCOUNTINGTOKEN PIC X(32).
      ** Appl Identity Data set in publications
       15  MQSD-PUBAPPLIDENTITYDATA PIC X(32).
      ** Add padding to ensure that pointers start on correct
      ** boundaries
       15  FILLER  PIC S9(9) BINARY VALUE 0.
      ** Message selector structure
       15  MQSD-SELECTIONSTRING.
      ** Address of variable length string
       20  MQSD-SELECTIONSTRING-VSPTR POINTER.
      ** Offset of variable length string
       20  MQSD-SELECTIONSTRING-VSOFFSET PIC S9(9) BINARY.
      ** Size of buffer
       20  MQSD-SELECTIONSTRING-VSBUFSIZE PIC S9(9) BINARY.
      ** Length of variable length string
       20  MQSD-SELECTIONSTRING-VSLENGTH PIC S9(9) BINARY.
      ** CCSID of variable length string
       20  MQSD-SELECTIONSTRING-VSCCSID PIC S9(9) BINARY.
      ** Subscription level
       15  MQSD-SUBLEVEL PIC S9(9) BINARY.
      ** Add padding to ensure that pointers start on correct
      ** boundaries
       15  FILLER  PIC S9(9) BINARY VALUE 0.
      ** Resolved long object name
       15  MQSD-RESOBJECTSTRING.
      ** Address of variable length string
       20  MQSD-RESOBJECTSTRING-VSPTR POINTER.
      ** Offset of variable length string
       20  MQSD-RESOBJECTSTRING-VSOFFSET PIC S9(9) BINARY.
      ** Size of buffer
       20  MQSD-RESOBJECTSTRING-VSBUFSIZE PIC S9(9) BINARY.
      ** Length of variable length string
       20  MQSD-RESOBJECTSTRING-VSLENGTH PIC S9(9) BINARY.
      ** CCSID of variable length string
       20  MQSD-RESOBJECTSTRING-VSCCSID PIC S9(9) BINARY.


      ******************************************************************
      **  End of CMQSDL                                               **
      ******************************************************************
