      ******************************************************************
      **                                                              **
      **                      IBM MQ for Windows                      **
      **                                                              **
      **  FILE NAME:      CMQPSV                                      **
      **                                                              **
      **  DESCRIPTION:    Declarations for Publish/Subscribe          **
      **                                                              **
      ******************************************************************
      **  <copyright                                                  **
      **  notice="lm-source-program"                                  **
      **  pids="5724-H72,5655-R36,5724-L26"                           **
      **  years="1993,2025"                                           **
      **  crc="1616507131" >                                          **
      **  Licensed Materials - Property of IBM                        **
      **                                                              **
      **  5724-H72                                                    **
      **                                                              **
      **  (C) Copyright IBM Corp. 1993, 2025 All Rights Reserved.     **
      **                                                              **
      **  US Government Users Restricted Rights - Use, duplication or **
      **  disclosure restricted by GSA ADP Schedule Contract with     **
      **  IBM Corp.                                                   **
      **  </copyright>                                                **
      ******************************************************************
      **                                                              **
      **  FUNCTION:       This file declares the named constants      **
      **                  for publish/subscribe.                      **
      **                                                              **
      **  PROCESSOR:      COBOL                                       **
      **                                                              **
      ******************************************************************

      ******************************************************************
      ** <BEGIN_BUILDINFO>                                            **
      ** Generated on:  07/10/25 14:42                                **
      ** Build Level:   p930-035-251007                               **
      ** Build Type:    Production                                    **
      ** Pointer Size:  64 Bit                                        **
      ** Source File:                                                 **
      ** CMQPSV                                                       **
      ** <END_BUILDINFO>                                              **
      ******************************************************************

      ******************************************************************
      **  Definitions used by MQRFH(1) - Rules and Formatting      
      **  Header                                                   
      ******************************************************************
      ******************************************************************
      **  Publish/Subscribe Tags                                   
      ******************************************************************
      ** Tags as strings
       10  MQPS-COMMAND   PIC X(11) VALUE 'MQPSCommand'.
       10  MQPS-COMP-CODE   PIC X(12) VALUE 'MQPSCompCode'.
       10  MQPS-CORREL-ID   PIC X(12) VALUE 'MQPSCorrelId'.
       10  MQPS-DELETE-OPTIONS   PIC X(11) VALUE 'MQPSDelOpts'.
       10  MQPS-ERROR-ID   PIC X(11) VALUE 'MQPSErrorId'.
       10  MQPS-ERROR-POS   PIC X(12) VALUE 'MQPSErrorPos'.
       10  MQPS-INTEGER-DATA   PIC X(11) VALUE 'MQPSIntData'.
       10  MQPS-PARAMETER-ID   PIC X(10) VALUE 'MQPSParmId'.
       10  MQPS-PUBLICATION-OPTIONS   PIC X(11) VALUE 'MQPSPubOpts'.
       10  MQPS-PUBLISH-TIMESTAMP   PIC X(11) VALUE 'MQPSPubTime'.
       10  MQPS-Q-MGR-NAME   PIC X(12) VALUE 'MQPSQMgrName'.
       10  MQPS-Q-NAME   PIC X(9) VALUE 'MQPSQName'.
       10  MQPS-REASON   PIC X(10) VALUE 'MQPSReason'.
       10  MQPS-REASON-TEXT   PIC X(14) VALUE 'MQPSReasonText'.
       10  MQPS-REGISTRATION-OPTIONS   PIC X(11) VALUE 'MQPSRegOpts'.
       10  MQPS-SEQUENCE-NUMBER   PIC X(10) VALUE 'MQPSSeqNum'.
       10  MQPS-STREAM-NAME   PIC X(14) VALUE 'MQPSStreamName'.
       10  MQPS-STRING-DATA   PIC X(14) VALUE 'MQPSStringData'.
       10  MQPS-SUBSCRIPTION-IDENTITY   PIC X(15)
           VALUE 'MQPSSubIdentity'.
       10  MQPS-SUBSCRIPTION-NAME   PIC X(11) VALUE 'MQPSSubName'.
       10  MQPS-SUBSCRIPTION-USER-DATA   PIC X(15)
           VALUE 'MQPSSubUserData'.
       10  MQPS-TOPIC   PIC X(9) VALUE 'MQPSTopic'.
       10  MQPS-USER-ID   PIC X(10) VALUE 'MQPSUserId'.

      ** Tags as blank-enclosed strings
       10  MQPS-COMMAND-B   PIC X(13) VALUE ' MQPSCommand '.
       10  MQPS-COMP-CODE-B   PIC X(14) VALUE ' MQPSCompCode '.
       10  MQPS-CORREL-ID-B   PIC X(14) VALUE ' MQPSCorrelId '.
       10  MQPS-DELETE-OPTIONS-B   PIC X(13) VALUE ' MQPSDelOpts '.
       10  MQPS-ERROR-ID-B   PIC X(13) VALUE ' MQPSErrorId '.
       10  MQPS-ERROR-POS-B   PIC X(14) VALUE ' MQPSErrorPos '.
       10  MQPS-INTEGER-DATA-B   PIC X(13) VALUE ' MQPSIntData '.
       10  MQPS-PARAMETER-ID-B   PIC X(12) VALUE ' MQPSParmId '.
       10  MQPS-PUBLICATION-OPTIONS-B   PIC X(13) VALUE ' MQPSPubOpts '.
       10  MQPS-PUBLISH-TIMESTAMP-B   PIC X(13) VALUE ' MQPSPubTime '.
       10  MQPS-Q-MGR-NAME-B   PIC X(14) VALUE ' MQPSQMgrName '.
       10  MQPS-Q-NAME-B   PIC X(11) VALUE ' MQPSQName '.
       10  MQPS-REASON-B   PIC X(12) VALUE ' MQPSReason '.
       10  MQPS-REASON-TEXT-B   PIC X(16) VALUE ' MQPSReasonText '.
       10  MQPS-REGISTRATION-OPTIONS-B   PIC X(13)
           VALUE ' MQPSRegOpts '.
       10  MQPS-SEQUENCE-NUMBER-B   PIC X(12) VALUE ' MQPSSeqNum '.
       10  MQPS-STREAM-NAME-B   PIC X(16) VALUE ' MQPSStreamName '.
       10  MQPS-STRING-DATA-B   PIC X(16) VALUE ' MQPSStringData '.
       10  MQPS-SUBSCRIPTION-IDENTITY-B   PIC X(17)
           VALUE ' MQPSSubIdentity '.
       10  MQPS-SUBSCRIPTION-NAME-B   PIC X(13) VALUE ' MQPSSubName '.
       10  MQPS-SUBSCRIPTION-USER-DATA-B   PIC X(17)
           VALUE ' MQPSSubUserData '.
       10  MQPS-TOPIC-B   PIC X(11) VALUE ' MQPSTopic '.
       10  MQPS-USER-ID-B   PIC X(12) VALUE ' MQPSUserId '.

      ******************************************************************
      **  Values for MQPS_COMMAND Tag                              
      ******************************************************************
      ** Values as strings
       10  MQPS-DELETE-PUBLICATION   PIC X(9) VALUE 'DeletePub'.
       10  MQPS-DEREGISTER-PUBLISHER   PIC X(8) VALUE 'DeregPub'.
       10  MQPS-DEREGISTER-SUBSCRIBER   PIC X(8) VALUE 'DeregSub'.
       10  MQPS-PUBLISH   PIC X(7) VALUE 'Publish'.
       10  MQPS-REGISTER-PUBLISHER   PIC X(6) VALUE 'RegPub'.
       10  MQPS-REGISTER-SUBSCRIBER   PIC X(6) VALUE 'RegSub'.
       10  MQPS-REQUEST-UPDATE   PIC X(9) VALUE 'ReqUpdate'.

      ** Values as blank-enclosed strings
       10  MQPS-DELETE-PUBLICATION-B   PIC X(11) VALUE ' DeletePub '.
       10  MQPS-DEREGISTER-PUBLISHER-B   PIC X(10) VALUE ' DeregPub '.
       10  MQPS-DEREGISTER-SUBSCRIBER-B   PIC X(10) VALUE ' DeregSub '.
       10  MQPS-PUBLISH-B   PIC X(9) VALUE ' Publish '.
       10  MQPS-REGISTER-PUBLISHER-B   PIC X(8) VALUE ' RegPub '.
       10  MQPS-REGISTER-SUBSCRIBER-B   PIC X(8) VALUE ' RegSub '.
       10  MQPS-REQUEST-UPDATE-B   PIC X(11) VALUE ' ReqUpdate '.

      ******************************************************************
      **  Values for tags                                          
      ******************************************************************
      ** Values as strings
       10  MQPS-ADD-NAME   PIC X(7) VALUE 'AddName'.
       10  MQPS-ANONYMOUS   PIC X(4) VALUE 'Anon'.
       10  MQPS-CORREL-ID-AS-IDENTITY   PIC X(10) VALUE 'CorrelAsId'.
       10  MQPS-DEREGISTER-ALL   PIC X(8) VALUE 'DeregAll'.
       10  MQPS-DIRECT-REQUESTS   PIC X(9) VALUE 'DirectReq'.
       10  MQPS-DUPLICATES-OK   PIC X(6) VALUE 'DupsOK'.
       10  MQPS-FULL-RESPONSE   PIC X(8) VALUE 'FullResp'.
       10  MQPS-INCLUDE-STREAM-NAME   PIC X(14) VALUE 'InclStreamName'.
       10  MQPS-INFORM-IF-RETAINED   PIC X(11) VALUE 'InformIfRet'.
       10  MQPS-IS-RETAINED-PUBLICATION   PIC X(13)
           VALUE 'IsRetainedPub'.
       10  MQPS-JOIN-EXCLUSIVE   PIC X(8) VALUE 'JoinExcl'.
       10  MQPS-JOIN-SHARED   PIC X(10) VALUE 'JoinShared'.
       10  MQPS-LEAVE-ONLY   PIC X(9) VALUE 'LeaveOnly'.
       10  MQPS-LOCAL   PIC X(5) VALUE 'Local'.
       10  MQPS-LOCKED   PIC X(6) VALUE 'Locked'.
       10  MQPS-NEW-PUBLICATIONS-ONLY   PIC X(11) VALUE 'NewPubsOnly'.
       10  MQPS-NO-ALTERATION   PIC X(7) VALUE 'NoAlter'.
       10  MQPS-NO-REGISTRATION   PIC X(5) VALUE 'NoReg'.
       10  MQPS-NON-PERSISTENT   PIC X(7) VALUE 'NonPers'.
       10  MQPS-NONE   PIC X(4) VALUE 'None'.
       10  MQPS-OTHER-SUBSCRIBERS-ONLY   PIC X(13)
           VALUE 'OtherSubsOnly'.
       10  MQPS-PERSISTENT   PIC X(4) VALUE 'Pers'.
       10  MQPS-PERSISTENT-AS-PUBLISH   PIC X(9) VALUE 'PersAsPub'.
       10  MQPS-PERSISTENT-AS-Q   PIC X(11) VALUE 'PersAsQueue'.
       10  MQPS-PUBLISH-ON-REQUEST-ONLY   PIC X(12)
           VALUE 'PubOnReqOnly'.
       10  MQPS-RETAIN-PUBLICATION   PIC X(9) VALUE 'RetainPub'.
       10  MQPS-VARIABLE-USER-ID   PIC X(14) VALUE 'VariableUserId'.

      ** Values as blank-enclosed strings
       10  MQPS-ADD-NAME-B   PIC X(9) VALUE ' AddName '.
       10  MQPS-ANONYMOUS-B   PIC X(6) VALUE ' Anon '.
       10  MQPS-CORREL-ID-AS-IDENTITY-B   PIC X(12)
           VALUE ' CorrelAsId '.
       10  MQPS-DEREGISTER-ALL-B   PIC X(10) VALUE ' DeregAll '.
       10  MQPS-DIRECT-REQUESTS-B   PIC X(11) VALUE ' DirectReq '.
       10  MQPS-DUPLICATES-OK-B   PIC X(8) VALUE ' DupsOK '.
       10  MQPS-FULL-RESPONSE-B   PIC X(10) VALUE ' FullResp '.
       10  MQPS-INCLUDE-STREAM-NAME-B   PIC X(16)
           VALUE ' InclStreamName '.
       10  MQPS-INFORM-IF-RETAINED-B   PIC X(13) VALUE ' InformIfRet '.
       10  MQPS-IS-RETAINED-PUBLICATION-B   PIC X(15)
           VALUE ' IsRetainedPub '.
       10  MQPS-JOIN-EXCLUSIVE-B   PIC X(10) VALUE ' JoinExcl '.
       10  MQPS-JOIN-SHARED-B   PIC X(12) VALUE ' JoinShared '.
       10  MQPS-LEAVE-ONLY-B   PIC X(11) VALUE ' LeaveOnly '.
       10  MQPS-LOCAL-B   PIC X(7) VALUE ' Local '.
       10  MQPS-LOCKED-B   PIC X(8) VALUE ' Locked '.
       10  MQPS-NEW-PUBLICATIONS-ONLY-B   PIC X(13)
           VALUE ' NewPubsOnly '.
       10  MQPS-NO-ALTERATION-B   PIC X(9) VALUE ' NoAlter '.
       10  MQPS-NO-REGISTRATION-B   PIC X(7) VALUE ' NoReg '.
       10  MQPS-NON-PERSISTENT-B   PIC X(9) VALUE ' NonPers '.
       10  MQPS-NONE-B   PIC X(6) VALUE ' None '.
       10  MQPS-OTHER-SUBSCRIBERS-ONLY-B   PIC X(15)
           VALUE ' OtherSubsOnly '.
       10  MQPS-PERSISTENT-B   PIC X(6) VALUE ' Pers '.
       10  MQPS-PERSISTENT-AS-PUBLISH-B   PIC X(11) VALUE ' PersAsPub '.
       10  MQPS-PERSISTENT-AS-Q-B   PIC X(13) VALUE ' PersAsQueue '.
       10  MQPS-PUBLISH-ON-REQUEST-ONLY-B   PIC X(14)
           VALUE ' PubOnReqOnly '.
       10  MQPS-RETAIN-PUBLICATION-B   PIC X(11) VALUE ' RetainPub '.
       10  MQPS-VARIABLE-USER-ID-B   PIC X(16) VALUE ' VariableUserId '.

      ******************************************************************
      **  Definitions used by MQRFH2 - Rules and Formatting Header 
      **  2                                                        
      ******************************************************************
      ******************************************************************
      **  RFH2 Top-level folder Tags                               
      ******************************************************************
      ** Tag names
       10  MQRFH2-PUBSUB-CMD-FOLDER   PIC X(3) VALUE 'psc'.
       10  MQRFH2-PUBSUB-RESP-FOLDER   PIC X(4) VALUE 'pscr'.
       10  MQRFH2-MSG-CONTENT-FOLDER   PIC X(3) VALUE 'mcd'.
       10  MQRFH2-USER-FOLDER   PIC X(3) VALUE 'usr'.

      ******************************************************************
      **  Message Content Descriptor (mcd) Tags                    
      ******************************************************************
      ** Tag names
       10  MQMCD-MSG-DOMAIN   PIC X(3) VALUE 'Msd'.
       10  MQMCD-MSG-SET   PIC X(3) VALUE 'Set'.
       10  MQMCD-MSG-TYPE   PIC X(4) VALUE 'Type'.
       10  MQMCD-MSG-FORMAT   PIC X(3) VALUE 'Fmt'.

      ** XML tag names
       10  MQMCD-MSG-DOMAIN-B   PIC X(5) VALUE '<Msd>'.
       10  MQMCD-MSG-DOMAIN-E   PIC X(6) VALUE '</Msd>'.
       10  MQMCD-MSG-SET-B   PIC X(5) VALUE '<Set>'.
       10  MQMCD-MSG-SET-E   PIC X(6) VALUE '</Set>'.
       10  MQMCD-MSG-TYPE-B   PIC X(6) VALUE '<Type>'.
       10  MQMCD-MSG-TYPE-E   PIC X(7) VALUE '</Type>'.
       10  MQMCD-MSG-FORMAT-B   PIC X(5) VALUE '<Fmt>'.
       10  MQMCD-MSG-FORMAT-E   PIC X(6) VALUE '</Fmt>'.

      ** Tag values
       10  MQMCD-DOMAIN-NONE   PIC X(4) VALUE 'none'.
       10  MQMCD-DOMAIN-NEON   PIC X(4) VALUE 'neon'.
       10  MQMCD-DOMAIN-MRM   PIC X(3) VALUE 'mrm'.
       10  MQMCD-DOMAIN-JMS-NONE   PIC X(8) VALUE 'jms_none'.
       10  MQMCD-DOMAIN-JMS-TEXT   PIC X(8) VALUE 'jms_text'.
       10  MQMCD-DOMAIN-JMS-OBJECT   PIC X(10) VALUE 'jms_object'.
       10  MQMCD-DOMAIN-JMS-MAP   PIC X(7) VALUE 'jms_map'.
       10  MQMCD-DOMAIN-JMS-STREAM   PIC X(10) VALUE 'jms_stream'.
       10  MQMCD-DOMAIN-JMS-BYTES   PIC X(9) VALUE 'jms_bytes'.

      ******************************************************************
      **  Publish/Subscribe Command Folder (psc) Tags              
      ******************************************************************
      ** Tag names
       10  MQPSC-COMMAND   PIC X(7) VALUE 'Command'.
       10  MQPSC-REGISTRATION-OPTION   PIC X(6) VALUE 'RegOpt'.
       10  MQPSC-PUBLICATION-OPTION   PIC X(6) VALUE 'PubOpt'.
       10  MQPSC-DELETE-OPTION   PIC X(6) VALUE 'DelOpt'.
       10  MQPSC-TOPIC   PIC X(5) VALUE 'Topic'.
       10  MQPSC-SUBSCRIPTION-POINT   PIC X(8) VALUE 'SubPoint'.
       10  MQPSC-FILTER   PIC X(6) VALUE 'Filter'.
       10  MQPSC-Q-MGR-NAME   PIC X(8) VALUE 'QMgrName'.
       10  MQPSC-Q-NAME   PIC X(5) VALUE 'QName'.
       10  MQPSC-PUBLISH-TIMESTAMP   PIC X(7) VALUE 'PubTime'.
       10  MQPSC-SEQUENCE-NUMBER   PIC X(6) VALUE 'SeqNum'.
       10  MQPSC-SUBSCRIPTION-NAME   PIC X(7) VALUE 'SubName'.
       10  MQPSC-SUBSCRIPTION-IDENTITY   PIC X(11) VALUE 'SubIdentity'.
       10  MQPSC-SUBSCRIPTION-USER-DATA   PIC X(11) VALUE 'SubUserData'.
       10  MQPSC-CORREL-ID   PIC X(8) VALUE 'CorrelId'.

      ** XML tag names
       10  MQPSC-COMMAND-B   PIC X(9) VALUE '<Command>'.
       10  MQPSC-COMMAND-E   PIC X(10) VALUE '</Command>'.
       10  MQPSC-REGISTRATION-OPTION-B   PIC X(8) VALUE '<RegOpt>'.
       10  MQPSC-REGISTRATION-OPTION-E   PIC X(9) VALUE '</RegOpt>'.
       10  MQPSC-PUBLICATION-OPTION-B   PIC X(8) VALUE '<PubOpt>'.
       10  MQPSC-PUBLICATION-OPTION-E   PIC X(9) VALUE '</PubOpt>'.
       10  MQPSC-DELETE-OPTION-B   PIC X(8) VALUE '<DelOpt>'.
       10  MQPSC-DELETE-OPTION-E   PIC X(9) VALUE '</DelOpt>'.
       10  MQPSC-TOPIC-B   PIC X(7) VALUE '<Topic>'.
       10  MQPSC-TOPIC-E   PIC X(8) VALUE '</Topic>'.
       10  MQPSC-SUBSCRIPTION-POINT-B   PIC X(10) VALUE '<SubPoint>'.
       10  MQPSC-SUBSCRIPTION-POINT-E   PIC X(11) VALUE '</SubPoint>'.
       10  MQPSC-FILTER-B   PIC X(8) VALUE '<Filter>'.
       10  MQPSC-FILTER-E   PIC X(9) VALUE '</Filter>'.
       10  MQPSC-Q-MGR-NAME-B   PIC X(10) VALUE '<QMgrName>'.
       10  MQPSC-Q-MGR-NAME-E   PIC X(11) VALUE '</QMgrName>'.
       10  MQPSC-Q-NAME-B   PIC X(7) VALUE '<QName>'.
       10  MQPSC-Q-NAME-E   PIC X(8) VALUE '</QName>'.
       10  MQPSC-PUBLISH-TIMESTAMP-B   PIC X(9) VALUE '<PubTime>'.
       10  MQPSC-PUBLISH-TIMESTAMP-E   PIC X(10) VALUE '</PubTime>'.
       10  MQPSC-SEQUENCE-NUMBER-B   PIC X(8) VALUE '<SeqNum>'.
       10  MQPSC-SEQUENCE-NUMBER-E   PIC X(9) VALUE '</SeqNum>'.
       10  MQPSC-SUBSCRIPTION-NAME-B   PIC X(9) VALUE '<SubName>'.
       10  MQPSC-SUBSCRIPTION-NAME-E   PIC X(10) VALUE '</SubName>'.
       10  MQPSC-SUBSCRIPTION-IDENTITY-B   PIC X(13)
           VALUE '<SubIdentity>'.
       10  MQPSC-SUBSCRIPTION-IDENTITY-E   PIC X(14)
           VALUE '</SubIdentity>'.
       10  MQPSC-SUBSCRIPTION-USER-DATA-B   PIC X(13)
           VALUE '<SubUserData>'.
       10  MQPSC-SUBSCRIPTION-USER-DATA-E   PIC X(14)
           VALUE '</SubUserData>'.
       10  MQPSC-CORREL-ID-B   PIC X(10) VALUE '<CorrelId>'.
       10  MQPSC-CORREL-ID-E   PIC X(11) VALUE '</CorrelId>'.

      ******************************************************************
      **  Values for MQPSC_COMMAND Tag                             
      ******************************************************************
      ** Values as strings
       10  MQPSC-DELETE-PUBLICATION   PIC X(9) VALUE 'DeletePub'.
       10  MQPSC-DEREGISTER-SUBSCRIBER   PIC X(8) VALUE 'DeregSub'.
       10  MQPSC-PUBLISH   PIC X(7) VALUE 'Publish'.
       10  MQPSC-REGISTER-SUBSCRIBER   PIC X(6) VALUE 'RegSub'.
       10  MQPSC-REQUEST-UPDATE   PIC X(9) VALUE 'ReqUpdate'.

      ******************************************************************
      **  Values for MQPSC_COMMAND Tag                             
      ******************************************************************
      ** Values as strings
       10  MQPSC-ADD-NAME   PIC X(7) VALUE 'AddName'.
       10  MQPSC-CORREL-ID-AS-IDENTITY   PIC X(10) VALUE 'CorrelAsId'.
       10  MQPSC-DEREGISTER-ALL   PIC X(8) VALUE 'DeregAll'.
       10  MQPSC-DUPLICATES-OK   PIC X(6) VALUE 'DupsOK'.
       10  MQPSC-FULL-RESPONSE   PIC X(8) VALUE 'FullResp'.
       10  MQPSC-INFORM-IF-RETAINED   PIC X(11) VALUE 'InformIfRet'.
       10  MQPSC-IS-RETAINED-PUB   PIC X(13) VALUE 'IsRetainedPub'.
       10  MQPSC-JOIN-SHARED   PIC X(10) VALUE 'JoinShared'.
       10  MQPSC-JOIN-EXCLUSIVE   PIC X(8) VALUE 'JoinExcl'.
       10  MQPSC-LEAVE-ONLY   PIC X(9) VALUE 'LeaveOnly'.
       10  MQPSC-LOCAL   PIC X(5) VALUE 'Local'.
       10  MQPSC-LOCKED   PIC X(6) VALUE 'Locked'.
       10  MQPSC-NEW-PUBS-ONLY   PIC X(11) VALUE 'NewPubsOnly'.
       10  MQPSC-NO-ALTERATION   PIC X(7) VALUE 'NoAlter'.
       10  MQPSC-NON-PERSISTENT   PIC X(7) VALUE 'NonPers'.
       10  MQPSC-OTHER-SUBS-ONLY   PIC X(13) VALUE 'OtherSubsOnly'.
       10  MQPSC-PERSISTENT   PIC X(4) VALUE 'Pers'.
       10  MQPSC-PERSISTENT-AS-PUBLISH   PIC X(9) VALUE 'PersAsPub'.
       10  MQPSC-PERSISTENT-AS-Q   PIC X(11) VALUE 'PersAsQueue'.
       10  MQPSC-NONE   PIC X(4) VALUE 'None'.
       10  MQPSC-PUB-ON-REQUEST-ONLY   PIC X(12) VALUE 'PubOnReqOnly'.
       10  MQPSC-RETAIN-PUB   PIC X(9) VALUE 'RetainPub'.
       10  MQPSC-VARIABLE-USER-ID   PIC X(14) VALUE 'VariableUserId'.

      ******************************************************************
      **  Publish/Subscribe Response Folder (pscr) Tags            
      ******************************************************************
      ** Tag names
       10  MQPSCR-COMPLETION   PIC X(10) VALUE 'Completion'.
       10  MQPSCR-RESPONSE   PIC X(8) VALUE 'Response'.
       10  MQPSCR-REASON   PIC X(6) VALUE 'Reason'.

      ** XML tag names
       10  MQPSCR-COMPLETION-B   PIC X(12) VALUE '<Completion>'.
       10  MQPSCR-COMPLETION-E   PIC X(13) VALUE '</Completion>'.
       10  MQPSCR-RESPONSE-B   PIC X(10) VALUE '<Response>'.
       10  MQPSCR-RESPONSE-E   PIC X(11) VALUE '</Response>'.
       10  MQPSCR-REASON-B   PIC X(8) VALUE '<Reason>'.
       10  MQPSCR-REASON-E   PIC X(9) VALUE '</Reason>'.

      ** Tag values
       10  MQPSCR-OK   PIC X(2) VALUE 'ok'.
       10  MQPSCR-WARNING   PIC X(7) VALUE 'warning'.
       10  MQPSCR-ERROR   PIC X(5) VALUE 'error'.



      ******************************************************************
      **  End of CMQPSV                                               **
      ******************************************************************
