/*
 * Decompiled with CFR 0.152.
 */
package crtmqras;

import crtmqras.CS;
import crtmqras.CommaSeparatedList;
import crtmqras.CommandLineArguments;
import crtmqras.CommandProcessor;
import crtmqras.Logger;
import crtmqras.MqIniFile;
import crtmqras.QM;
import crtmqras.WinRegistry;
import crtmqras.ZipFolder;
import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;

public class Registry {
    public static final String SCCSID = "@(#) MQMBID sn=p930-035-251007 su=263925fe29acb90671ec1938ace719dfc41589c3 pn=cmd/tools/com.ibm.mq.tools.ras/src/crtmqras/Registry.java";
    public static final String LONG_COPYRIGHT_STRING = "Licensed Materials - Property of IBM 63H9336 (c) Copyright IBM Corp. 2005, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static String ERROR_DIR = File.separator + "errors";
    private static final String OS400_PATH = "/QIBM/UserData/mqm/mqs.ini";
    private static final String MQ_INSTALLATION_NAME_PROPERTY = "MQ_INSTALLATION_NAME";
    private static final String DEFAULT_MQ_INSTALLATION_NAME = "Installation1";
    public static String OS_NAME;
    public static String SEPARATOR;
    public static final String PRODUCT_TYPE_MQ = "mq";
    public static final String PRODUCT_TYPE_MQAPPLIANCE = "mqappliance";
    public static final String PRODUCT_TYPE_RDQM = "rdqm";
    private boolean isWindows = false;
    private boolean isHPNS = false;
    private boolean demoMode;
    private List<QM> qm_list;
    private String error_directory;
    private String install_directory;
    private String unix_style_install_directory;
    private String mq_directory = null;
    private String mq_ver;
    private String exe_directory;
    private String prodType;
    private String wlp_directory = null;
    private String wlp_data_directory = null;
    private Logger logger;
    private CommaSeparatedList suppliedQMList;
    public static final String EXC_MSG_MISSING_QM = "Missing QM found in -qmlist";

    /*
     * WARNING - void declaration
     */
    public Registry(ZipFolder zipFolder, CommandLineArguments commandLineArguments) throws Exception {
        Object object;
        CS cS;
        boolean bl = true;
        boolean bl2 = commandLineArguments.getDemoMode();
        CommaSeparatedList commaSeparatedList = commandLineArguments.getSuppliedQMList();
        int n = commandLineArguments.getTimeout();
        this.logger = Logger.getInstanceOf();
        OS_NAME = System.getProperty("os.name");
        if (!this.logger.isMQAppliance()) {
            this.logger.log("", "running on " + OS_NAME);
        }
        this.suppliedQMList = commaSeparatedList;
        this.demoMode = bl2;
        if (OS_NAME.startsWith("Windows")) {
            OS_NAME = "Windows";
            this.isWindows = true;
            SEPARATOR = "\\\\";
        } else if (OS_NAME.equals("NONSTOP_KERNEL")) {
            this.isHPNS = true;
        } else if (OS_NAME.startsWith("Mac ")) {
            OS_NAME = "MacOS";
        }
        if (!this.logger.isMQAppliance()) {
            this.logger.log("Running on " + OS_NAME, true);
        }
        if (bl = (cS = new CS()).isOk()) {
            this.logger.log("Using commonservices");
            this.mq_directory = cS.getMq_directory();
            this.mq_ver = cS.getMq_ver();
            this.exe_directory = cS.getExe_directory();
            this.install_directory = cS.getInstall_directory();
            this.unix_style_install_directory = this.install_directory.replaceAll(SEPARATOR, "/").replaceAll(" ", "%20");
            this.qm_list = cS.getQm_list();
            this.error_directory = this.mq_directory + ERROR_DIR;
        } else {
            this.logger.log("error from commonservices: " + cS.getError());
            object = "";
            if (0 == OS_NAME.compareToIgnoreCase("OS/400")) {
                object = OS400_PATH;
                this.unix_style_install_directory = "/QIBM/ProdData/mqm";
                this.install_directory = "/QIBM/ProdData/mqm";
                this.exe_directory = "/QSYS.LIB/QMQM.LIB";
                this.mq_directory = "/QIBM/UserData/mqm";
            } else {
                String string;
                void var9_12;
                Object object2;
                Object object22 = null;
                String string2 = Registry.class.getName().replace('.', '/') + ".class";
                ClassLoader classLoader = Registry.class.getClassLoader();
                if (classLoader == null) {
                    this.logger.log("Cannot load class loader");
                } else {
                    object2 = classLoader.getResource(string2);
                    if (object2 != null) {
                        try {
                            File file = new File(((URL)object2).toURI());
                        }
                        catch (Exception exception) {
                            File file = new File(((URL)object2).getPath());
                        }
                    }
                }
                if (var9_12 != null) {
                    object2 = URLDecoder.decode(var9_12.toString(), "UTF-8");
                    this.logger.log("Filestring for class: '" + (String)object2 + "'");
                    object2 = ((String)object2).replace("file:\\", "");
                    object2 = ((String)object2).replace("file:", "");
                    int n2 = ((String)object2).indexOf("com.ibm.mq.tools.ras.jar");
                    if (n2 > -1) {
                        object2 = ((String)object2).substring(0, n2) + ".." + File.separator + "..";
                        this.logger.log("Filestring for install directory: '" + (String)object2 + "'");
                        this.install_directory = new File((String)object2).getCanonicalPath();
                        this.unix_style_install_directory = new File((String)object2).getCanonicalPath().replaceAll(SEPARATOR, "/").replaceAll(" ", "%20");
                        this.exe_directory = this.install_directory + File.separator + "bin";
                    }
                }
                if (this.install_directory == null) {
                    this.logger.log("Unable to obtain current location - using defaults");
                    if (this.isWindows) {
                        this.install_directory = "C:\\Program Files\\IBM\\MQ";
                        this.unix_style_install_directory = "C:/Program%20Files/IBM/MQ";
                    } else if (0 == OS_NAME.compareToIgnoreCase("AIX")) {
                        this.unix_style_install_directory = "/usr/mqm";
                        this.install_directory = "/usr/mqm";
                    } else {
                        this.unix_style_install_directory = "/opt/mqm";
                        this.install_directory = "/opt/mqm";
                    }
                    this.exe_directory = this.install_directory + File.separator + "bin";
                }
                if (this.isWindows) {
                    object2 = zipFolder.toString() + File.separator + "reg.out";
                    string = "HKEY_LOCAL_MACHINE\\SOFTWARE\\IBM\\WebSphere MQ";
                    String string3 = "reg EXPORT \"" + string + "\" \"" + (String)object2 + "\"";
                    CommandProcessor commandProcessor = new CommandProcessor(zipFolder, false, OS_NAME, this.logger, null);
                    commandProcessor.run(string3, n, false);
                    WinRegistry winRegistry = null;
                    if (new File((String)object2).exists()) {
                        winRegistry = new WinRegistry((String)object2, string, this.logger);
                        this.mq_directory = winRegistry.getWork_path();
                    }
                    object2 = zipFolder.toString() + File.separator + "oldreg.out";
                    string = "HKEY_LOCAL_MACHINE\\SOFTWARE\\IBM\\MQSeries";
                    string3 = "reg EXPORT \"" + string + "\" \"" + (String)object2 + "\"";
                    commandProcessor.run(string3, n, false);
                    winRegistry = new WinRegistry((String)object2, string, this.logger);
                    if (new File((String)object2).exists()) {
                        this.qm_list = winRegistry.getQueueManagers();
                        if (this.mq_directory == null || this.mq_directory.equals("")) {
                            this.mq_directory = winRegistry.getWork_path();
                        }
                    }
                } else if (this.isHPNS) {
                    object2 = new File(this.install_directory);
                    string = this.install_directory.endsWith("/opt/mqm") ? ((File)object2).getParentFile().getParent() : "";
                    this.mq_directory = string + "/var/mqm";
                } else {
                    object2 = System.getenv("MQ_DATA_PATH");
                    if (object2 != null) {
                        this.logger.log("Taking MQ_DATA_PATH from environment " + (String)object2);
                        this.mq_directory = new File((String)object2).getCanonicalPath();
                    } else {
                        this.logger.log("MQ_DATA_PATH is not set, assuming default of /var/mqm");
                        this.mq_directory = "/var/mqm";
                    }
                }
                object = this.mq_directory + File.separator + "mqs.ini";
            }
            if (this.qm_list == null && new File((String)object).exists()) {
                MqIniFile mqIniFile = new MqIniFile((String)object, this.logger);
                this.qm_list = mqIniFile.getQueueManagers();
            }
            this.mq_ver = "unknown";
            this.error_directory = this.mq_directory + ERROR_DIR;
        }
        this.prodType = cS.isMQAppliance() ? PRODUCT_TYPE_MQAPPLIANCE : (new File(this.exe_directory + File.separator + "rdqmadm").exists() ? PRODUCT_TYPE_RDQM : PRODUCT_TYPE_MQ);
        if (cS.isMQAppliance()) {
            this.wlp_directory = new File(this.install_directory + File.separator + ".." + File.separator + "ibm" + File.separator + "wlp").getCanonicalPath();
            this.wlp_data_directory = new File(this.install_directory + File.separator + ".." + File.separator + "ibm" + File.separator + "wlp" + File.separator + "usr").getCanonicalPath();
        } else {
            object = System.getProperty(MQ_INSTALLATION_NAME_PROPERTY, DEFAULT_MQ_INSTALLATION_NAME);
            this.wlp_directory = new File(this.install_directory + File.separator + "web").getCanonicalPath();
            this.wlp_data_directory = new File(this.mq_directory + File.separator + "web" + File.separator + "installations" + File.separator + (String)object).getCanonicalPath();
        }
        this.logger.log("Summary");
        this.logger.log("-------");
        this.logger.log("MQ Version = " + this.mq_ver);
        this.logger.log("MQ Install Directory = " + this.install_directory);
        this.logger.log("MQ Exe Directory = " + this.exe_directory);
        this.logger.log("MQ General Directory = " + this.mq_directory);
        this.logger.log("MQ Product Type = " + this.prodType);
        this.logger.log("WLP Directory = " + this.wlp_directory);
        this.logger.log("WLP Data Directory = " + this.wlp_data_directory);
        this.sortQMList();
        if (this.qm_list != null) {
            for (QM qM : this.qm_list) {
                this.logger.log("Qm: " + qM.getName() + ", DataPath: " + qM.getDataPath() + ", LogPath: " + qM.getLogpath() + ", Installation: " + qM.getInstallationName() + ", MangledName: " + qM.getMangledName() + ", EphemeralPrefix: " + qM.getEphemPrefix() + ", SocketsPrefix: " + qM.getSocketsPrefix());
            }
        }
    }

    public boolean isDemoMode() {
        return this.demoMode;
    }

    public boolean isWindows() {
        return this.isWindows;
    }

    public String getProdType() {
        return this.prodType;
    }

    public String getInstall_directory() {
        return this.install_directory;
    }

    public String getMq_ver() {
        return this.mq_ver;
    }

    public String getExe_directory() {
        return this.exe_directory;
    }

    public void setError_directory(String string) {
        this.error_directory = string;
    }

    public List<QM> getQM_list() {
        return this.qm_list;
    }

    public String getErrorDirectory() {
        return this.error_directory;
    }

    public String getMqDirectory() {
        return this.mq_directory;
    }

    public String getWlpDirectory() {
        return this.wlp_directory;
    }

    public String getWlpDataDirectory() {
        return this.wlp_data_directory;
    }

    private void sortQMList() throws Exception {
        List<QM> list = this.getQM_list();
        List<Object> list2 = new ArrayList();
        StringBuilder stringBuilder = new StringBuilder();
        if (this.suppliedQMList == null) {
            this.logger.log("No QM list supplied by user.");
            list2 = list;
        } else {
            Object object;
            Object object2;
            for (QM object32 : list) {
                object2 = object32.getName();
                object = stringBuilder.length() == 0 ? object2 : "," + (String)object2;
                stringBuilder.append((String)object);
                if (this.suppliedQMList.listContains((String)object2)) {
                    this.logger.log("Registry", "Adding QM: '" + (String)object2 + "' to sorted list");
                    list2.add(object32);
                    continue;
                }
                this.logger.log("Registry", "Removing QM: '" + (String)object2 + "' from qm_list");
            }
            CommaSeparatedList commaSeparatedList = new CommaSeparatedList(stringBuilder.toString());
            object2 = this.suppliedQMList.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                if (((String)object).length() <= 0 || commaSeparatedList.listContains((String)object)) continue;
                this.logger.log("Registry", "ERROR: A specified Queue Manager was not found: " + (String)object, true);
                throw new Exception(EXC_MSG_MISSING_QM);
            }
        }
        this.qm_list = list2;
    }

    static {
        SEPARATOR = "/";
    }
}

