/*
 * Decompiled with CFR 0.152.
 */
package crtmqras;

import crtmqras.Logger;
import crtmqras.Registry;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class QmIniFile {
    public static final String SHORT_COPYRIGHT_STRING = "(c) Copyright IBM Corporation 2005, 2011";
    public static final String SCCSID = "@(#) MQMBID sn=p930-035-251007 su=263925fe29acb90671ec1938ace719dfc41589c3 pn=cmd/tools/com.ibm.mq.tools.ras/src/crtmqras/QmIniFile.java";
    public static final String LONG_COPYRIGHT_STRING = "Licensed Materials - Property of IBM 63H9336 (c) Copyright IBM Corp. 2005, 2011. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String CLASSNAME = "QmIniFile";

    public static String getLogDirectory(String string, Logger logger) throws IOException {
        logger.log(CLASSNAME, "Opening file " + string);
        BufferedReader bufferedReader = null;
        if (Registry.OS_NAME.equals("OS/400")) {
            logger.log(CLASSNAME, "Reading as ebcdic file", 'V');
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "Cp037"));
        } else {
            logger.log(CLASSNAME, "Reading as ascii file", 'V');
            bufferedReader = new BufferedReader(new FileReader(string));
        }
        int n = 0;
        boolean bl = true;
        boolean bl2 = false;
        String string2 = "";
        while (bl && !bl2) {
            String string3 = bufferedReader.readLine();
            if (string3 == null) {
                logger.log(CLASSNAME, "reached EOF", 'V');
                break;
            }
            string3 = string3.trim();
            logger.log(CLASSNAME, "read line: " + string3, 'V');
            if (string3.equals("") || string3.startsWith("#")) continue;
            switch (n) {
                case 0: {
                    if (0 != string3.compareToIgnoreCase("Log:")) break;
                    n = 1;
                    break;
                }
                case 1: {
                    Pattern pattern = Pattern.compile("\\s*(.+)=(.+)\\s*");
                    Matcher matcher = pattern.matcher(string3);
                    if (matcher.matches()) {
                        if (0 != matcher.group(1).compareToIgnoreCase("LogPath")) break;
                        string2 = matcher.group(2);
                        logger.log(CLASSNAME, "Found logpath =" + string2);
                        bl2 = true;
                        break;
                    }
                    n = 0;
                }
            }
        }
        bufferedReader.close();
        return string2;
    }
}

