/*
 * Decompiled with CFR 0.152.
 */
package crtmqras;

import crtmqras.Logger;
import crtmqras.QM;
import crtmqras.QmIniFile;
import crtmqras.Registry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MqIniFile {
    public static final String SHORT_COPYRIGHT_STRING = "(c) Copyright IBM Corporation 2005, 2011";
    public static final String SCCSID = "@(#) MQMBID sn=p930-035-251007 su=263925fe29acb90671ec1938ace719dfc41589c3 pn=cmd/tools/com.ibm.mq.tools.ras/src/crtmqras/MqIniFile.java";
    public static final String LONG_COPYRIGHT_STRING = "Licensed Materials - Property of IBM 63H9336 (c) Copyright IBM Corp. 2005, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String CLASSNAME = "MqIniFile";
    private Logger logger;
    private ArrayList<QM> qm_list;

    public MqIniFile(String string, Logger logger) throws Exception {
        this.logger = logger;
        this.qm_list = new ArrayList();
        logger.log(CLASSNAME, "Opening file " + string);
        BufferedReader bufferedReader = null;
        if (Registry.OS_NAME.equals("OS/400")) {
            logger.log(CLASSNAME, "Reading as ebcdic file", 'V');
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "Cp037"));
        } else {
            logger.log(CLASSNAME, "Reading as ascii file", 'V');
            bufferedReader = new BufferedReader(new FileReader(string));
        }
        int n = 0;
        boolean bl = true;
        boolean bl2 = false;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        String string9 = "";
        String string10 = "";
        while (bl) {
            String string11 = bufferedReader.readLine();
            if (string11 == null) {
                logger.log(CLASSNAME, "reached EOF", 'V');
                n = 4;
            } else {
                string11 = string11.trim();
            }
            logger.log(CLASSNAME, "read line: " + string11, 'V');
            switch (n) {
                case 0: {
                    if (0 == string11.compareToIgnoreCase("AllQueueManagers:")) {
                        logger.log(CLASSNAME, "0: found AllQueueManagers:", 'V');
                        n = 1;
                        break;
                    }
                    if (string11.startsWith("#")) break;
                    logger.log(CLASSNAME, "0: skipping line: " + string11, 'V');
                    break;
                }
                case 1: {
                    if (0 == string11.compareToIgnoreCase("QueueManager:")) {
                        bl2 = true;
                        logger.log(CLASSNAME, "1: found QueueManager:", 'V');
                        n = 2;
                        break;
                    }
                    if (0 == string11.compareToIgnoreCase("LogDefaults:")) {
                        logger.log(CLASSNAME, "1: found LogDefaults:", 'V');
                        n = 3;
                        break;
                    }
                    if (string11.startsWith("#")) break;
                    if (string11.endsWith(":")) {
                        logger.log(CLASSNAME, "1: skipping section: " + string11, 'V');
                        break;
                    }
                    logger.log(CLASSNAME, "1: skipping line: " + string11, 'V');
                    break;
                }
                case 2: {
                    Pattern pattern = Pattern.compile("\\s*(.+)=(.+)\\s*");
                    Matcher matcher = pattern.matcher(string11);
                    if (matcher.matches()) {
                        logger.log(CLASSNAME, "2: found " + string11);
                        if (0 == matcher.group(1).compareToIgnoreCase("Name")) {
                            string2 = matcher.group(2);
                        } else if (0 == matcher.group(1).compareToIgnoreCase("Prefix")) {
                            string3 = matcher.group(2);
                        } else if (0 == matcher.group(1).compareToIgnoreCase("DataPath")) {
                            string4 = matcher.group(2);
                        } else if (0 == matcher.group(1).compareToIgnoreCase("Library")) {
                            string5 = matcher.group(2);
                        } else if (0 == matcher.group(1).compareToIgnoreCase("Directory")) {
                            string6 = matcher.group(2);
                        } else if (0 == matcher.group(1).compareToIgnoreCase("InstallationName")) {
                            string8 = matcher.group(2);
                        } else if (0 == matcher.group(1).compareToIgnoreCase("EphemeralPrefix")) {
                            string9 = matcher.group(2);
                        } else {
                            logger.log(CLASSNAME, "2: skipping line: " + string11, 'V');
                        }
                        n = 2;
                        break;
                    }
                    if (string11.endsWith(":")) {
                        logger.log("QM name: " + string2);
                        logger.log("QM pre: " + string3);
                        logger.log("QM data: " + string4);
                        logger.log("QM Lib: " + string5);
                        logger.log("QM Dir: " + string6);
                        logger.log("QM Inst: " + string8);
                        logger.log("QM ephem prefix: " + string9);
                        logger.log("QM sockets prefix: " + string10);
                        if (string4.equals("")) {
                            string4 = string3 + File.separator + "qmgrs" + File.separator + string6;
                        }
                        if (string9.equals("")) {
                            string9 = string3;
                            string10 = string3;
                        } else {
                            string10 = string9;
                        }
                        this.addQm(string2, string4, string5, string6, string8, string7, string9, string10);
                        string2 = "";
                        string4 = "";
                        string3 = "";
                        string5 = "";
                        string6 = "";
                        string8 = "";
                        string9 = "";
                        string10 = "";
                        if (0 == string11.compareToIgnoreCase("QueueManager:")) {
                            logger.log(CLASSNAME, "2: found QueueManager:", 'V');
                            n = 2;
                            break;
                        }
                        logger.log(CLASSNAME, "2: skipping section: " + string11, 'V');
                        bl2 = false;
                        n = 1;
                        break;
                    }
                    logger.log(CLASSNAME, "2: skipping line: " + string11, 'V');
                    break;
                }
                case 3: {
                    Pattern pattern = Pattern.compile("\\s*(.+)=(.+)\\s*");
                    Matcher matcher = pattern.matcher(string11);
                    if (matcher.matches()) {
                        logger.log(CLASSNAME, "3: found " + string11, 'V');
                        if (0 != matcher.group(1).compareToIgnoreCase("LogDefaultPath")) break;
                        string7 = matcher.group(2);
                        break;
                    }
                    if (0 == string11.compareToIgnoreCase("QueueManager:")) {
                        logger.log(CLASSNAME, "3: found QueueManager:", 'V');
                        bl2 = true;
                        n = 2;
                        break;
                    }
                    if (!string11.startsWith("#")) {
                        logger.log(CLASSNAME, "3: skipping line: " + string11, 'V');
                        break;
                    }
                    n = 1;
                    break;
                }
                case 4: {
                    bl = false;
                    if (!bl2) break;
                    logger.log("QM name: " + string2);
                    logger.log("QM pre: " + string3);
                    logger.log("QM data: " + string4);
                    logger.log("QM Lib: " + string5);
                    logger.log("QM Dir: " + string6);
                    logger.log("QM Inst: " + string8);
                    logger.log("QM ephem prefix: " + string9);
                    logger.log("QM sockets prefix: " + string10);
                    if (string4.equals("")) {
                        string4 = string3 + File.separator + "qmgrs" + File.separator + string6;
                    }
                    if (string9.equals("")) {
                        string9 = string3;
                        string10 = string3;
                    } else {
                        string10 = string9;
                    }
                    this.addQm(string2, string4, string5, string6, string8, string7, string9, string10);
                }
            }
        }
        bufferedReader.close();
    }

    private void addQm(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        String string9 = "";
        if (string3.equals("")) {
            try {
                string9 = QmIniFile.getLogDirectory(string2 + File.separator + "qm.ini", this.logger);
            }
            catch (IOException iOException) {
                this.logger.log("IO exception reading QM.ini");
            }
            if (string9.equals("")) {
                this.logger.log("Failed to get log directory from QM.ini, using default");
                string9 = string6 + File.separator + string4;
            }
        } else {
            string9 = File.separator + "QSYS.LIB" + File.separator + string3 + ".LIB";
        }
        this.logger.log(CLASSNAME, "adding qm: " + string + ", inst: " + string5 + ", data: " + string2 + ", log: " + string9 + ", qm_ephem_prefix: " + string7 + ", qm_sockets_prefix: " + string8);
        QM qM = new QM(string, string2, string4, string9, string5, string7, string8);
        this.qm_list.add(qM);
    }

    public ArrayList<QM> getQueueManagers() {
        return this.qm_list;
    }
}

