      ******************************************************************
      **                                                              **
      **                      IBM MQ for Windows                      **
      **                                                              **
      **  FILE NAME:      CMQDLHL                                     **
      **                                                              **
      **  DESCRIPTION:    MQDLH Structure -- Dead Letter Header       **
      **                                                              **
      ******************************************************************
      **  <copyright                                                  **
      **  notice="lm-source-program"                                  **
      **  pids="5724-H72,5655-R36,5724-L26"                           **
      **  years="1993,2020"                                           **
      **  crc="1616507131" >                                          **
      **  Licensed Materials - Property of IBM                        **
      **                                                              **
      **  5724-H72                                                    **
      **                                                              **
      **  (C) Copyright IBM Corp. 1993, 2020 All Rights Reserved.     **
      **                                                              **
      **  US Government Users Restricted Rights - Use, duplication or **
      **  disclosure restricted by GSA ADP Schedule Contract with     **
      **  IBM Corp.                                                   **
      **  </copyright>                                                **
      ******************************************************************
      **                                                              **
      **  FUNCTION:       This file declares the structure MQDLH,     **
      **                  which is used by the main MQI.              **
      **                                                              **
      **  PROCESSOR:      COBOL                                       **
      **                                                              **
      ******************************************************************

      ******************************************************************
      ** <BEGIN_BUILDINFO>                                            **
      ** Generated on:  14/10/25 14:02                                **
      ** Build Level:   p920-038-251014                               **
      ** Build Type:    Production                                    **
      ** Pointer Size:  32 Bit                                        **
      ** Source File:                                                 **
      ** CMQDLHL                                                      **
      ** <END_BUILDINFO>                                              **
      ******************************************************************

      ** MQDLH structure
       10  MQDLH.
      ** Structure identifier
       15  MQDLH-STRUCID PIC X(4).
      ** Structure version number
       15  MQDLH-VERSION PIC S9(9) BINARY.
      ** Reason message arrived on dead-letter (undelivered-message)
      ** queue
       15  MQDLH-REASON PIC S9(9) BINARY.
      ** Name of original destination queue
       15  MQDLH-DESTQNAME PIC X(48).
      ** Name of original destination queue manager
       15  MQDLH-DESTQMGRNAME PIC X(48).
      ** Numeric encoding of data that follows MQDLH
       15  MQDLH-ENCODING PIC S9(9) BINARY.
      ** Character set identifier of data that follows MQDLH
       15  MQDLH-CODEDCHARSETID PIC S9(9) BINARY.
      ** Format name of data that follows MQDLH
       15  MQDLH-FORMAT PIC X(8).
      ** Type of application that put message on dead-letter
      ** (undelivered-message) queue
       15  MQDLH-PUTAPPLTYPE PIC S9(9) BINARY.
      ** Name of application that put message on dead-letter
      ** (undelivered-message) queue
       15  MQDLH-PUTAPPLNAME PIC X(28).
      ** Date when message was put on dead-letter (undelivered-message)
      ** queue
       15  MQDLH-PUTDATE PIC X(8).
      ** Time when message was put on dead-letter (undelivered-message)
      ** queue
       15  MQDLH-PUTTIME PIC X(8).


      ******************************************************************
      **  End of CMQDLHL                                              **
      ******************************************************************
