/*
 * Decompiled with CFR 0.152.
 */
package crtmqras;

import crtmqras.CommaSeparatedList;
import crtmqras.CommandLineArguments;
import crtmqras.CommandProcessor;
import crtmqras.Logger;
import crtmqras.MQStringSubstitution;
import crtmqras.QM;
import crtmqras.Registry;
import crtmqras.ZipFile;
import crtmqras.ZipFolder;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class myHandler
extends DefaultHandler {
    public static final String SHORT_COPYRIGHT_STRING = "(c) Copyright IBM Corporation 2005, 2008";
    public static final String SCCSID = "@(#) MQMBID sn=p920-038-251014 su=37056e99045b1a90fb46804fec32700b61389170 pn=cmd/tools/com.ibm.mq.tools.ras/src/crtmqras/myHandler.java";
    public static final String LONG_COPYRIGHT_STRING = "Licensed Materials - Property of IBM 63H9336 (c) Copyright IBM Corp. 2005, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String PLATFORM = "platform";
    private static final String SECTION = "section";
    private static final String FILES = "files";
    private static final String FILE = "file";
    private static final String COMMANDS = "commands";
    private static final String COMMAND = "command";
    private static final String BODY = "body";
    private static final int S_START = 0;
    private static final int S_READY = 1;
    private static final int S_COMMAND = 2;
    private static final int S_FILE = 3;
    private static final int S_ENDING = -3;
    private static final int S_ENDED = -2;
    private static final int S_ERROR = -1;
    private boolean platformOk = false;
    private boolean sectionOk = true;
    private String sectionN = "";
    private boolean demoMode = false;
    private ZipFolder zip_folder;
    private ZipFile zip_file;
    private Registry reg;
    private CommandProcessor cp;
    private MQStringSubstitution mqSub;
    CommandLineArguments clp;
    private int State;
    private Logger logger;
    private String tag;
    private final String prodType;
    private StringBuilder sectionsUsed;

    public myHandler(ZipFolder zipFolder, Registry registry, ZipFile zipFile, CommandLineArguments commandLineArguments, Logger logger) {
        this.logger = logger;
        this.zip_folder = zipFolder;
        this.zip_file = zipFile;
        this.reg = registry;
        this.clp = commandLineArguments;
        this.demoMode = this.clp.getDemoMode();
        this.mqSub = new MQStringSubstitution(this.reg);
        this.cp = new CommandProcessor(zipFolder, registry.isDemoMode(), Registry.OS_NAME, this.logger, this.reg);
        this.sectionsUsed = new StringBuilder();
        this.State = -1;
        this.prodType = this.reg.getProdType();
    }

    private void addUsedSectionNameToBuilder(String string) {
        String string2 = this.sectionsUsed.length() == 0 ? string : "," + string;
        this.sectionsUsed.append(string2);
    }

    public String commandNameToUse(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = string + " " + string2;
        StringTokenizer stringTokenizer = new StringTokenizer(string3, "&&");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            if (n > 0) {
                stringBuilder.append(" && ");
            }
            String string4 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string4, "|");
            int n2 = 0;
            while (stringTokenizer2.hasMoreTokens()) {
                String string5;
                String[] stringArray;
                String string6;
                String[] stringArray2;
                String string7;
                if (n2 > 0) {
                    stringBuilder.append(" | ");
                }
                if ((string7 = (stringArray2 = (string6 = (stringArray = (string5 = stringTokenizer2.nextToken().replaceAll("\"", "").replaceAll("'", "").trim()).split(" "))[0]).split(Pattern.quote(File.separator)))[stringArray2.length - 1]).equals("mqsudo") && stringArray.length > 1) {
                    string6 = stringArray[1];
                    stringArray2 = string6.split(Pattern.quote(File.separator));
                    string7 = stringArray2[stringArray2.length - 1];
                }
                stringBuilder.append(string7);
                ++n2;
            }
            ++n;
        }
        int n3 = stringBuilder.length();
        return n3 > 43 ? "..." + stringBuilder.toString().substring(n3 - 43) : stringBuilder.toString();
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
        this.logger.log("processingInstruction(" + string + "," + string2 + ")", true);
    }

    @Override
    public void startDocument() throws SAXException {
        this.State = 0;
    }

    @Override
    public void endDocument() throws SAXException {
        if (-3 != this.State) {
            throw new SAXException("ERROR: unexpected end of document tag");
        }
        if (this.clp.getSection().length() > 0) {
            CommaSeparatedList commaSeparatedList = new CommaSeparatedList(this.sectionsUsed.toString());
            CommaSeparatedList commaSeparatedList2 = new CommaSeparatedList(this.clp.getSection());
            Iterator<String> iterator = commaSeparatedList2.iterator();
            while (iterator.hasNext()) {
                String string = iterator.next();
                if (string.equals("all") || string.equals("nodefault") || commaSeparatedList.listContains(string)) continue;
                this.logger.log("WARNING: A named section was not found: " + string, true);
            }
        }
        this.State = -2;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.tag = "<" + string3 + " ";
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string4 = attributes.getQName(i);
            String string5 = attributes.getValue(i);
            this.tag = this.tag + string4 + "=\"" + string5 + "\" ";
        }
        this.tag = this.tag + "/>";
        if (0 == string3.compareToIgnoreCase(BODY)) {
            if (0 != this.State) {
                throw new SAXException("ERROR: unexpected <BODY> tag");
            }
            this.State = 1;
        } else if (0 == string3.compareToIgnoreCase(COMMANDS)) {
            if (1 != this.State) {
                throw new SAXException("ERROR: unexpected <COMMANDS> tag state = " + this.State);
            }
            this.logger.enableOverwriteState();
            this.State = 2;
            this.startCommands(attributes);
        } else if (0 == string3.compareToIgnoreCase(COMMAND)) {
            this.startCommand(attributes);
        } else if (0 == string3.compareToIgnoreCase(FILES)) {
            if (1 != this.State) {
                throw new SAXException("ERROR: unexpected <FILES> tag state = " + this.State);
            }
            this.logger.enableOverwriteState();
            this.State = 3;
            this.startFiles(attributes);
        } else if (0 == string3.compareToIgnoreCase(FILE)) {
            this.startFile(attributes);
        } else {
            this.logger.log("Error unknown XML tag: <" + string3 + ">");
        }
    }

    private void startFiles(Attributes attributes) throws SAXException {
        this.logger.log("Found <Files> section");
        String string = " - ";
        this.sectionOk = this.clp.processDefaultSections();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Object object;
            String string2 = attributes.getQName(i);
            String string3 = attributes.getValue(i);
            String string4 = string2 + "(" + string3 + "); ";
            string = string + string4;
            if (0 == string2.compareToIgnoreCase(new String(PLATFORM))) {
                object = new CommaSeparatedList(string3);
                this.platformOk = ((CommaSeparatedList)object).listContains(Registry.OS_NAME);
                this.logger.log("Found platform=" + string3 + ", matches=" + this.platformOk);
                continue;
            }
            if (0 == string2.compareToIgnoreCase(new String(SECTION))) {
                if (!this.clp.processAllSections()) {
                    object = this.clp.getSection();
                    CommaSeparatedList commaSeparatedList = new CommaSeparatedList(string3);
                    this.sectionOk = ((String)object).length() > 0 ? commaSeparatedList.listContains((String)object) : false;
                    this.logger.log("Found section=" + string3 + ", matches=" + this.sectionOk);
                    if (!this.platformOk || !this.sectionOk) continue;
                    this.addUsedSectionNameToBuilder(string3);
                    continue;
                }
                this.sectionOk = this.checkSectionIsNotADuplicate(string3);
                this.logger.log("Found section=" + string3 + ", processing all sections");
                continue;
            }
            throw new SAXException("Error: unrecognised attribute '" + string2 + "' on <files> tag line: " + string);
        }
    }

    private void startFile(Attributes attributes) throws SAXException {
        if (this.platformOk && this.sectionOk) {
            Object object;
            String string = " - ";
            String string2 = "";
            String string3 = "";
            String string4 = "";
            String string5 = "";
            String string6 = "";
            boolean bl = false;
            boolean bl2 = false;
            for (int i = 0; i < attributes.getLength(); ++i) {
                object = attributes.getQName(i);
                String list3 = attributes.getValue(i);
                String string7 = (String)object + "(" + list3 + "); ";
                string = string + string7;
                if (0 == ((String)object).compareToIgnoreCase("path")) {
                    string2 = list3;
                    continue;
                }
                if (0 == ((String)object).compareToIgnoreCase("detail")) {
                    string3 = list3;
                    continue;
                }
                if (0 == ((String)object).compareToIgnoreCase("qm")) {
                    string4 = list3;
                    continue;
                }
                if (0 == ((String)object).compareToIgnoreCase("e2a")) {
                    if (!list3.equalsIgnoreCase("yes")) continue;
                    bl = true;
                    continue;
                }
                if (((String)object).equalsIgnoreCase("recursive")) {
                    if (!list3.equalsIgnoreCase("yes")) continue;
                    bl2 = true;
                    continue;
                }
                if (((String)object).equalsIgnoreCase("env")) {
                    string5 = list3;
                    continue;
                }
                if (0 == ((String)object).compareToIgnoreCase("exclude")) {
                    string6 = list3;
                    continue;
                }
                throw new SAXException("Error: unrecognised attribute '" + (String)object + "' on <file> tag line: " + string);
            }
            this.logger.log("", "tag = " + this.tag, 'V');
            if (!string5.equals("") && string5.substring(0, 1).equals("!") && !this.prodType.equalsIgnoreCase(string5.substring(1))) {
                string5 = "";
            }
            this.logger.log("Processing file entry : " + string);
            if (this.prodType.equalsIgnoreCase(string5) || string5.equals("") || this.logger.isMQAppliance() && "mq".equalsIgnoreCase(string5) || "rdqm".equals(this.prodType) && "mq".equalsIgnoreCase(string5)) {
                if (string4.length() > 0) {
                    String string8;
                    List<Object> list2 = new ArrayList();
                    if (0 == string4.compareToIgnoreCase("*")) {
                        list2 = this.reg.getQM_list();
                    } else {
                        this.logger.log("myHandler", "startFile for qm(s): " + string4);
                        object = new CommaSeparatedList(string4);
                        List<QM> list = this.reg.getQM_list();
                        for (int i = 0; i < list.size(); ++i) {
                            string8 = list.get(i).getName();
                            if (!((CommaSeparatedList)object).listContains(string8)) continue;
                            this.logger.log("myHandler", "Match found for: " + string8);
                            list2.add(list.get(i));
                        }
                    }
                    if (list2 != null && list2.size() > 0) {
                        for (QM qM : list2) {
                            String string9 = this.mqSub.processLine(string2, qM);
                            string8 = this.mqSub.processLine(string3, qM);
                            String string10 = this.mqSub.processLine(string6, qM);
                            this.processFile(string9, string8, string10, bl2, bl);
                        }
                    } else {
                        this.logger.log("StartFile", "No QMs found that match " + string4);
                    }
                } else {
                    String string11 = this.mqSub.processLine(string2, null);
                    object = this.mqSub.processLine(string3, null);
                    String string12 = this.mqSub.processLine(string6, null);
                    this.processFile(string11, (String)object, string12, bl2, bl);
                }
            } else {
                this.logger.log("Skipping file: " + string2 + "/" + string3);
                this.logger.log("env ( " + string5 + " ) does not match product type ( " + this.prodType + " )");
            }
        }
    }

    private void processFile(String string, String string2, String string3, boolean bl, boolean bl2) {
        Object object;
        String[] stringArray;
        String string4 = "";
        String string5 = "";
        String[] stringArray2 = new String[]{"APPDATA", "USERPROFILE"};
        String[] stringArray3 = new String[]{"HOME"};
        if (this.reg.isWindows()) {
            stringArray = stringArray2;
            string4 = "%";
            string5 = "%";
        } else {
            stringArray = stringArray3;
            string4 = "$";
        }
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl3;
            String string6 = string4 + stringArray[i] + string5;
            object = System.getenv(stringArray[i]);
            String string7 = string;
            boolean bl4 = bl3 = string.indexOf(string6) != -1;
            if (object == null && bl3) {
                this.logger.log("myHandler", "Failed to find: " + string6 + " environment variable");
                this.logger.log("myHandler", "Skipping processing of: " + string);
                return;
            }
            if (bl3) {
                string = string.replace(string6, (CharSequence)object);
            }
            if (string.equals(string7)) continue;
            this.logger.log("myHandler", "Replaced env var " + string6 + " with " + (String)object + " in: " + string7);
            this.logger.log("myHandler", "Resulted in " + string);
        }
        if (this.logger.isMQAppliance()) {
            this.logger.log("Processing MQ files...", true);
        }
        int n = 35;
        if (string.length() > n) {
            this.logger.log("Processing all files from: ..." + string.substring(Math.max(string.length() - n, 0)), true, false);
        } else {
            this.logger.log("Processing all files from: " + string, true, false);
        }
        object = new File(string);
        this.zip_file.addFiles((File)object, !this.demoMode, true, bl, string2, bl2, "", string3);
    }

    private void startCommands(Attributes attributes) throws SAXException {
        String string = " - ";
        this.logger.log("Found <Commands> section");
        this.sectionN = "";
        this.sectionOk = this.clp.processDefaultSections();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Object object;
            String string2 = attributes.getQName(i);
            String string3 = attributes.getValue(i);
            String string4 = string2 + "(" + string3 + "); ";
            string = string + string4;
            this.logger.log("Command attribute " + string2 + " " + string3);
            if (0 == string2.compareToIgnoreCase(new String(PLATFORM))) {
                object = new CommaSeparatedList(string3);
                this.platformOk = ((CommaSeparatedList)object).listContains(Registry.OS_NAME);
                this.logger.log("Found platform=" + string3 + ", matches=" + this.platformOk);
                continue;
            }
            if (0 == string2.compareToIgnoreCase(new String(SECTION))) {
                if (!this.clp.processAllSections()) {
                    object = this.clp.getSection();
                    CommaSeparatedList commaSeparatedList = new CommaSeparatedList(string3);
                    this.sectionOk = ((String)object).length() > 0 ? commaSeparatedList.listContains((String)object) : false;
                    this.logger.log("Found section=" + string3 + ", matches=" + this.sectionOk);
                    if (!this.platformOk || !this.sectionOk) continue;
                    this.addUsedSectionNameToBuilder(string3);
                    this.sectionN = string3;
                    continue;
                }
                this.sectionOk = this.checkSectionIsNotADuplicate(string3);
                this.logger.log("Found section=" + string3 + ", processing all sections.");
                continue;
            }
            throw new SAXException("Error: unrecognised attribute '" + string2 + "' on <commands> tag line: " + string);
        }
    }

    private boolean checkSectionIsNotADuplicate(String string) {
        if (this.clp.processAllSections() && this.logger.isMQAppliance() && string.equals("webui")) {
            System.out.println("Removing duplicate " + string);
            return false;
        }
        return true;
    }

    private void startCommand(Attributes attributes) throws SAXException {
        if (this.platformOk && this.sectionOk) {
            Iterator<QM> iterator;
            Object object;
            Object object2;
            String string;
            int n;
            String string2 = " - ";
            String string3 = "";
            String string4 = "";
            String string5 = "";
            Object object3 = "";
            Object object4 = "";
            Object object5 = "";
            Object object6 = "";
            Object object7 = "";
            boolean bl = false;
            String string6 = "";
            String string7 = "";
            for (n = 0; n < attributes.getLength(); ++n) {
                string = attributes.getQName(n);
                object2 = attributes.getValue(n);
                object = string + "(" + (String)object2 + "); ";
                string2 = string2 + (String)object;
                this.logger.log("command attribute = " + string + " " + (String)object2);
                if (0 == string.compareToIgnoreCase("name")) {
                    string3 = object2;
                    string4 = object2;
                    continue;
                }
                if (0 == string.compareToIgnoreCase("args")) {
                    iterator = this.zip_folder.toString() + File.separator;
                    if (this.sectionN.length() > 0) {
                        iterator = (String)((Object)iterator) + this.sectionN + File.separator;
                    }
                    string5 = this.mqSub.processArgLine((String)object2, (String)((Object)iterator), (String)((Object)iterator));
                    string5 = " " + string5;
                    object3 = object2;
                    this.logger.log("command arguments  = " + string5);
                    continue;
                }
                if (0 == string.compareToIgnoreCase("output")) {
                    object4 = object2;
                    continue;
                }
                if (0 == string.compareToIgnoreCase("qm")) {
                    object5 = object2;
                    continue;
                }
                if (0 == string.compareToIgnoreCase("env")) {
                    object6 = object2;
                    continue;
                }
                if (0 == string.compareToIgnoreCase("timeout")) {
                    object7 = object2;
                    continue;
                }
                if (0 == string.compareToIgnoreCase("noquote")) {
                    if (!((String)object2).trim().equalsIgnoreCase("true")) continue;
                    bl = true;
                    continue;
                }
                throw new SAXException("Error: unrecognised attribute '" + string + "' on <command> tag line: " + string2);
            }
            string3 = this.mqSub.processLine(string3, null);
            boolean bl2 = this.mqSub.isMqProgram(string3);
            if (!((String)object6).equals("") && ((String)object6).substring(0, 1).equals("!")) {
                this.logger.log("NOT ENV CASE " + (String)object6);
                if (!this.prodType.equalsIgnoreCase(((String)object6).substring(1))) {
                    object6 = "";
                    this.logger.log("changing env to empty");
                }
            }
            if (this.prodType.equalsIgnoreCase((String)object6) || ((String)object6).equals("") || this.logger.isMQAppliance() && "mq".equalsIgnoreCase((String)object6) || "rdqm".equals(this.prodType) && "mq".equalsIgnoreCase((String)object6)) {
                if (0 != ((String)object4).length()) {
                    String string8 = "";
                    string = "";
                    Object object8 = object2 = this.sectionN.length() > 0 ? this.sectionN + File.separator : "";
                    if (this.reg.isWindows()) {
                        string8 = " >\"" + this.zip_folder.toString() + File.separator + (String)object2 + (String)object4 + ".stdout\"";
                        string = " 2>\"" + this.zip_folder.toString() + File.separator + object2 + (String)object4 + ".stderr\"";
                    } else {
                        string8 = " >" + this.zip_folder.toString() + File.separator + (String)object2 + (String)object4 + ".stdout";
                        string = " 2>" + this.zip_folder.toString() + File.separator + object2 + (String)object4 + ".stderr";
                    }
                    string7 = this.zip_folder.toString() + File.separator + (String)object2 + (String)object4 + ".stderr";
                    object4 = string8 + string;
                }
                n = this.clp.getTimeout();
                if (0 != ((String)object7).length() && !this.clp.isTimeoutOverridden()) {
                    try {
                        n = Integer.parseInt((String)object7);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.logger.log("myHandler", "The specified timeout is invalid " + numberFormatException.getMessage() + numberFormatException);
                    }
                }
                string = n <= 0 ? " (long-running)" : "";
                this.logger.log("", "tag = " + this.tag, 'V');
                if (((String)object5).length() > 0) {
                    String string8;
                    object2 = new ArrayList();
                    if (0 == ((String)object5).compareToIgnoreCase("*")) {
                        object2 = this.reg.getQM_list();
                    } else {
                        this.logger.log("myHandler", "startCommand for qm(s): " + (String)object5);
                        object = new CommaSeparatedList((String)object5);
                        for (QM object9 : this.reg.getQM_list()) {
                            string8 = object9.getName();
                            if (!((CommaSeparatedList)object).listContains(string8)) continue;
                            object2.add(object9);
                        }
                    }
                    if (object2 != null && object2.size() > 0) {
                        object = object2.iterator();
                        while (object.hasNext()) {
                            iterator = (QM)object.next();
                            String string9 = this.mqSub.processLine(string5, (QM)((Object)iterator));
                            string8 = this.mqSub.processLine((String)object4, (QM)((Object)iterator));
                            String string10 = this.mqSub.processLine(string7, (QM)((Object)iterator));
                            string6 = this.reg.isWindows() ? (!bl ? "\"" + string3 + string9 + "\"" + string8 : string3 + string9 + string8) : string3 + string9 + string8;
                            this.logger.log("Executing command: " + this.commandNameToUse(string4, (String)object3) + string, true);
                            this.cp.run(string6, n, this.sectionN, bl2);
                            if (((String)object4).length() <= 0 || this.deleteFileIfEmpty(string10)) continue;
                            this.logger.log("Warning: couldn't delete file: " + string10);
                        }
                    }
                } else {
                    string5 = this.mqSub.processLine(string5, null);
                    object4 = this.mqSub.processLine((String)object4, null);
                    object2 = this.mqSub.processLine(string7, null);
                    string6 = this.reg.isWindows() ? (!bl ? "\"" + string3 + string5 + "\"" + (String)object4 : string3 + string5 + (String)object4) : string3 + string5 + (String)object4;
                    this.logger.log("Executing command: " + this.commandNameToUse(string4, (String)object3) + string, true);
                    this.cp.run(string6, n, this.sectionN, bl2);
                    if (((String)object4).length() > 0 && !this.deleteFileIfEmpty((String)object2)) {
                        this.logger.log("Warning: couldn't delete file: " + (String)object2);
                    }
                }
            } else {
                this.logger.log("Skipping command: " + string3);
                this.logger.log("env ( " + (String)object6 + " ) does not match product type ( " + this.prodType + " )");
            }
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (0 == string3.compareToIgnoreCase(BODY)) {
            if (1 != this.State) {
                throw new SAXException("ERROR: unexpected </BODY> tag");
            }
            this.State = -3;
        } else if (0 == string3.compareToIgnoreCase(COMMANDS)) {
            if (2 != this.State) {
                throw new SAXException("ERROR: unexpected <" + string3 + "> tag");
            }
            this.logger.disableOverwriteState();
            this.State = 1;
        } else if (0 != string3.compareToIgnoreCase(COMMAND)) {
            if (0 == string3.compareToIgnoreCase(FILES)) {
                if (3 != this.State) {
                    throw new SAXException("ERROR: unexpected <" + string3 + "> tag");
                }
                this.logger.disableOverwriteState();
                this.State = 1;
            } else if (0 != string3.compareToIgnoreCase(FILE)) {
                throw new SAXException("ERROR: unknown </" + string3 + "> tag");
            }
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
    }

    public StringBuilder getSectionsUsed() {
        return this.sectionsUsed;
    }

    public boolean deleteFileIfEmpty(String string) {
        File file;
        File file2 = file = string == null || string.length() == 0 ? null : new File(string);
        if (null != file && 0L == file.length()) {
            return file.delete();
        }
        return true;
    }
}

