/*
 * Decompiled with CFR 0.152.
 */
package crtmqras;

import crtmqras.CommaSeparatedList;
import crtmqras.CommandLineArguments;
import crtmqras.FTPClient;
import crtmqras.Logger;
import crtmqras.Registry;
import crtmqras.ZipFile;
import crtmqras.ZipFolder;
import crtmqras.myHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;

public class Zipper {
    public static final String SHORT_COPYRIGHT_STRING = "(c) Copyright IBM Corporation 2005, 2021";
    public static final String SCCSID = "@(#) MQMBID sn=p920-038-251014 su=37056e99045b1a90fb46804fec32700b61389170 pn=cmd/tools/com.ibm.mq.tools.ras/src/crtmqras/Zipper.java";
    public static final String LONG_COPYRIGHT_STRING = "Licensed Materials - Property of IBM 63H9336 (c) Copyright IBM Corp. 2005, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static String XML_FILE_NAME;
    public static String SECONDARY_XML_FILE_NAME;
    public static String ZIP_FILE_NAME;
    public static String WORK_DIRECTORY_NAME;
    public static boolean MULTIPLE_INPUTS;

    private static void showHelp() {
        System.out.println("");
        System.out.println("General parameters:");
        System.out.println("-inputfile file       : fully qualified name of the XML input file");
        System.out.println("-custominput file     : fully qualified name of an additonal XML input file");
        System.out.println("-zipfile file         : name of the zip output file");
        System.out.println("-outputdir dir        : provide the destination path of the zip file");
        System.out.println("-workdirectory dir    : fully qualified name of an empty work directory");
        System.out.println("-section name,name    : execute named sections from comma separated list in XML");
        System.out.println("-qmlist qm,qm         : run commands only for those QMs supplied");
        System.out.println("-noqmdata             : omit queue manager data collection. It is not valid to supply both -qmlist and -noqmdata");
        System.out.println("-timeout secs         : timeout period for commands in seconds (0 indefinite)");
        System.out.println("-demo                 : list commands which would have been processed and files which would have been gathered");
        System.out.println("-v                    : verbose output into console log");
        System.out.println("-ftp <IBM|custom>     : ftp the zip file on completion");
        System.out.println("      IBM             -Send file straight to IBM (requires -pmrno or -caseno)");
        System.out.println("      custom          -Send the file to a user provided location");
        System.out.println("");
        System.out.println("For use with -ftp IBM:");
        System.out.println("-pmrno pmrNumber      : provide a PMR number for the file name");
        System.out.println("-caseno caseNumber    : provide a case number for the file name");
        System.out.println("                      [ only one of either -pmrno or -caseno may be supplied ]");
        System.out.println("");
        System.out.println("For use with -ftp custom:");
        System.out.println("-ftpserver server     : name of server to be used for the ftp connection");
        System.out.println("-ftpusername username : username to be used for the ftp connection");
        System.out.println("-ftppassword password : password to be used for the ftp connection");
        System.out.println("-ftpdirectory path    : directory to be used for the ftp connection");
        System.out.println("");
        System.out.println("Other options: ");
        System.out.println("-help                 : provide simple help");
        System.out.println("-sub                  : Shows what keywords will be substitued in the xml");
    }

    private static void applianceshowHelp() {
        System.out.println("");
        System.out.println("General parameters:");
        System.out.println("-section name,name    : execute named sections");
        System.out.println("-qmlist qm,qm         : run commands only for those QMs supplied");
        System.out.println("-noqmdata             : omit queue manager data collection. It is not valid to supply both -qmlist and -noqmdata");
        System.out.println("-timeout secs         : timeout period for commands in seconds (0 indefinite)");
        System.out.println("-demo                 : list commands which would have been processed and files which would have been gathered");
        System.out.println("-v                    : verbose output into console log");
        System.out.println("-ftp <IBM|custom>     : ftp the zip file on completion");
        System.out.println("      IBM             -Send file straight to IBM (requires -pmrno or -caseno)");
        System.out.println("      custom          -Send the file to a user provided location");
        System.out.println("");
        System.out.println("For use with -ftp IBM:");
        System.out.println("-pmrno pmrNumber      : provide a PMR number for the file name");
        System.out.println("-caseno caseNumber    : provide a case number for the file name");
        System.out.println("                      [ only one of either -pmrno or -caseno may be supplied ]");
        System.out.println("");
        System.out.println("For use with -ftp custom:");
        System.out.println("-ftpserver server     : name of server to be used for the ftp connection");
        System.out.println("-ftpusername username : username to be used for the ftp connection");
        System.out.println("-ftppassword password : password to be used for the ftp connection");
        System.out.println("-ftpdirectory path    : directory to be used for the ftp connection");
        System.out.println("");
        System.out.println("Other options: ");
        System.out.println("-help                 : provide simple help");
    }

    private static void showSubstitution() {
        System.out.println("The following values will be substituted in the XML file(s):");
        System.out.println("ZIP::     - Location of Zip File");
        System.out.println("WorkDir:: - Temp Dir where all files are zipped from");
        System.out.println("MQ::      - MQ install path");
        System.out.println("MQD::     - MQ Data install path");
        System.out.println("MQBIN::   - MQ bin path");
        System.out.println("QM::      - Queue Manager name");
        System.out.println("SQM::     - Safe Queue Manager name for files");
        System.out.println("QML::     - Queue Manager logs location");
        System.out.println("QMD::     - Queue Manager data location");
        System.out.println("QME::     - Queue Manager ephemeral prefix");
        System.out.println("QMS::     - Queue Manager sockets prefix");
        System.out.println("WLP::     - Liberty Profile location");
        System.out.println("WLPD::    - Liberty Profile data location");
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        CommandLineArguments commandLineArguments;
        boolean bl;
        Logger logger;
        Runtime runtime;
        block46: {
            Object object7;
            runtime = Runtime.getRuntime();
            logger = new Logger();
            bl = true;
            if (!logger.isMQAppliance()) {
                logger.log("crtmqras", "crtmqras starts...", true);
            }
            commandLineArguments = new CommandLineArguments(logger);
            try {
                object6 = "";
                for (int i = 0; i < stringArray.length; ++i) {
                    object5 = stringArray[i];
                    if (++i < stringArray.length) {
                        object6 = stringArray[i];
                        if ('-' == ((String)object6).charAt(0)) {
                            --i;
                            object6 = "";
                        }
                    } else {
                        object6 = "";
                    }
                    if ('-' != ((String)object5).charAt(0)) {
                        throw new Exception("key does not start with a '-': " + (String)object5);
                    }
                    object5 = ((String)object5).substring(1);
                    if ("help".equals(object5) || "?".equals(object5)) {
                        if (logger.isMQAppliance()) {
                            Zipper.applianceshowHelp();
                        } else {
                            Zipper.showHelp();
                        }
                        return;
                    }
                    if ("sub".equals(object5)) {
                        Zipper.showSubstitution();
                        return;
                    }
                    commandLineArguments.add((String)object5, (String)object6);
                }
                commandLineArguments.add("section", "defs");
                commandLineArguments.check();
            }
            catch (Throwable throwable) {
                logger.log("Error: " + throwable.getMessage(), true);
                if (logger.isMQAppliance()) {
                    Zipper.applianceshowHelp();
                } else {
                    Zipper.showHelp();
                }
                runtime.exit(21);
            }
            MULTIPLE_INPUTS = commandLineArguments.getCustomInputSupplied();
            XML_FILE_NAME = commandLineArguments.getInputFile();
            if (MULTIPLE_INPUTS) {
                SECONDARY_XML_FILE_NAME = commandLineArguments.getCustomInputFile();
            }
            String string = commandLineArguments.getZipFile();
            try {
                object6 = "-" + InetAddress.getLocalHost().getHostName();
                string = string.substring(0, string.contains(".zip") ? string.indexOf(".zip") : string.length()) + (String)object6 + ".zip";
            }
            catch (Exception exception) {
                logger.log("Warning: unable to determine hostname, using default name for zip file", true, false);
            }
            ZIP_FILE_NAME = string;
            WORK_DIRECTORY_NAME = commandLineArguments.getWorkDirectory();
            object6 = null;
            object5 = ZipFolder.createInstanceOf(WORK_DIRECTORY_NAME);
            if (object5 == null) {
                logger.log("Error: creating work directory (" + WORK_DIRECTORY_NAME + ") failed!", true);
                runtime.exit(22);
            }
            logger.setFile(WORK_DIRECTORY_NAME);
            try {
                object6 = new ZipFile(new File(ZIP_FILE_NAME));
            }
            catch (Exception exception) {
                logger.log("Error: creating zip file (" + ZIP_FILE_NAME + ") " + exception.getMessage(), exception);
                runtime.exit(21);
            }
            Registry registry = null;
            try {
                registry = new Registry((ZipFolder)object5, commandLineArguments);
            }
            catch (Exception exception) {
                if ("Missing QM found in -qmlist".equals(exception.getMessage())) {
                    logger.log("crtmqras", "crtmqras exit, fatal common services error", true);
                    runtime.exit(24);
                }
                logger.log("crtmqras: common services error " + exception.getMessage(), exception);
            }
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            myHandler myHandler2 = null;
            try {
                SAXParser sAXParser = sAXParserFactory.newSAXParser();
                logger.log("using xml_file = " + XML_FILE_NAME);
                myHandler2 = new myHandler((ZipFolder)object5, registry, (ZipFile)object6, commandLineArguments, logger);
                sAXParser.parse(new File(XML_FILE_NAME), (DefaultHandler)myHandler2);
                if (MULTIPLE_INPUTS) {
                    logger.log("using secondary_xml_file = " + XML_FILE_NAME);
                    sAXParser.parse(new File(SECONDARY_XML_FILE_NAME), (DefaultHandler)myHandler2);
                }
            }
            catch (Exception exception) {
                logger.log("crtmqras: error: XML parser has failed: " + exception.getMessage(), exception);
                runtime.exit(24);
            }
            boolean bl2 = false;
            if (Registry.OS_NAME.equals("OS/400")) {
                bl2 = true;
            }
            if (myHandler2 != null) {
                object7 = new CommaSeparatedList(myHandler2.getSectionsUsed().toString());
                object4 = ((CommaSeparatedList)object7).iterator();
                while (object4.hasNext()) {
                    object3 = object4.next();
                    if (0 == ((String)object3).length()) continue;
                    ((ZipFile)object6).addFiles(new File(WORK_DIRECTORY_NAME + File.separator + (String)object3), true, true, true, "", bl2, (String)object3, null);
                }
            }
            bl = ((ZipFile)object6).addFiles(((ZipFolder)object5).getHandle(), true, false, false, "", bl2, "", "console.log");
            object7 = "autopdzip" + File.separator + "autopd";
            object4 = (String)object7 + File.separator + "autopd-collection-environment-v2.xml";
            try {
                object3 = new File(((ZipFolder)object5).toString() + File.separator + (String)object7);
                ((File)object3).mkdirs();
                object2 = new FileOutputStream(((ZipFolder)object5).toString() + File.separator + (String)object4);
                object = new PrintStream((OutputStream)object2);
                ((PrintStream)object).println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                ((PrintStream)object).println("<collectionEnvironmentInfo         ");
                ((PrintStream)object).println("  pluginTaxonomyId=\"SSFKSJ\" ");
                ((PrintStream)object).println("  toolName=\"runmqras\"");
                ((PrintStream)object).println("  toolVersion=\"@(#) MQMBID sn=p920-038-251014 su=37056e99045b1a90fb46804fec32700b61389170 pn=cmd/tools/com.ibm.mq.tools.ras/src/crtmqras/Zipper.java\"");
                ((PrintStream)object).println("  xmlns=\"http://www.ibm.com/autopd/collectionEnvironment\"");
                ((PrintStream)object).println("  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
                ((PrintStream)object).println("  xsi:schemaLocation=\"http://www.ibm.com/autopd/collectionEnvironment ../autoPD-collection-env.xsd \">");
                ((PrintStream)object).println("</collectionEnvironmentInfo>");
                ((PrintStream)object).flush();
                ((PrintStream)object).close();
                ((FileOutputStream)object2).close();
            }
            catch (Exception exception) {
                if (logger.isMQAppliance()) break block46;
                logger.log("crtmqras: error: Cannot produce autopd config file: " + exception.getMessage(), exception);
            }
        }
        ((ZipFile)object6).addFile(((ZipFolder)object5).toString() + File.separator + (String)object4, (String)object4, true, true, false);
        try {
            ((ZipFile)object6).addFile(XML_FILE_NAME, null, true, false, false);
            if (MULTIPLE_INPUTS) {
                ((ZipFile)object6).addFile(SECONDARY_XML_FILE_NAME, null, true, false, false);
            }
        }
        catch (Exception exception) {
            logger.log("Failed to add xml file(s) to zip file due to: " + exception.getMessage(), exception);
        }
        ((ZipFile)object6).addFile(WORK_DIRECTORY_NAME + File.separator + "console.log", null, true, false, false);
        if (bl) {
            if (logger.isMQAppliance()) {
                logger.disableOverwriteState();
                logger.log("runmqras has successfully finished.", true);
                logger.log("The zip file can be found at mqdiag://" + ZIP_FILE_NAME.substring(ZIP_FILE_NAME.lastIndexOf("/") + 1) + "\n", true);
            } else {
                logger.log("crtmqras has successfully finished", true);
                logger.log("The zip file can be found at " + ZIP_FILE_NAME + "\n", true);
            }
            ((ZipFile)object6).close();
            logger.close();
            ZipFolder.destroy(((ZipFile)object6).getFilename());
            if (commandLineArguments.isToFtp()) {
                object3 = "ftp.ecurep.ibm.com";
                object2 = "anonymous";
                object = "";
                String string = "toibm/websphere";
                if (commandLineArguments.isCustom()) {
                    if (commandLineArguments.getFtpServer() != null || commandLineArguments.getFtpServer() != "") {
                        object3 = commandLineArguments.getFtpServer();
                    }
                    if (commandLineArguments.getFtpUsername() != null || commandLineArguments.getFtpUsername() != "") {
                        object2 = commandLineArguments.getFtpUsername();
                    }
                    if (commandLineArguments.getFtpPassword() != null || commandLineArguments.getFtpPassword() != "") {
                        object = commandLineArguments.getFtpPassword();
                    }
                    string = ".";
                    if (commandLineArguments.getFtpDirectory() != null || commandLineArguments.getFtpDirectory() != "") {
                        string = commandLineArguments.getFtpDirectory();
                    }
                }
                FTPClient fTPClient = new FTPClient((String)object3, (String)object2, (String)object, string, ((ZipFile)object6).getFilename(), logger);
                fTPClient.ftpFile();
            }
        } else {
            logger.log("crtmqras has finished but failed to write compressed file", false);
            if (logger.isMQAppliance()) {
                logger.disableOverwriteState();
                logger.log("runmqras finished with errors. Do you have enough space in mqdiag folder?", true);
                logger.log("These files will be left in mqdiag://" + WORK_DIRECTORY_NAME.substring(WORK_DIRECTORY_NAME.lastIndexOf("/") + 1) + "\n", false);
            } else {
                logger.log("These files will be left in " + WORK_DIRECTORY_NAME, true);
            }
            logger.close();
            runtime.exit(25);
        }
    }
}

