/*
 * Decompiled with CFR 0.152.
 */
package crtmqras;

import crtmqras.Logger;
import java.io.File;

public class ZipFolder {
    public static final String SHORT_COPYRIGHT_STRING = "(c) Copyright IBM Corporation 2005, 2008";
    public static final String SCCSID = "@(#) MQMBID sn=p920-038-251014 su=37056e99045b1a90fb46804fec32700b61389170 pn=cmd/tools/com.ibm.mq.tools.ras/src/crtmqras/ZipFolder.java";
    public static final String LONG_COPYRIGHT_STRING = "Licensed Materials - Property of IBM 63H9336 (c) Copyright IBM Corp. 2005, 2008. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static String temp_dir;
    private static boolean valid;
    private static boolean created;
    private static File f_td;
    private static Logger logger;

    private ZipFolder(String string) {
        valid = ZipFolder.createTempDir(string);
        if (valid) {
            temp_dir = string;
        }
    }

    private static boolean isOk() {
        return valid;
    }

    public static ZipFolder createInstanceOf(String string) {
        if (logger == null) {
            logger = Logger.getInstanceOf();
        }
        ZipFolder zipFolder = new ZipFolder(string);
        if (ZipFolder.isOk()) {
            return zipFolder;
        }
        return null;
    }

    public String toString() {
        if (ZipFolder.isOk()) {
            return temp_dir;
        }
        return "";
    }

    public File getHandle() {
        if (ZipFolder.isOk()) {
            return f_td;
        }
        return null;
    }

    public static void destroy(String string) {
        File[] fileArray;
        File file = new File(f_td.getPath() + File.separator + "autopdzip" + File.separator + "autopd" + File.separator + "autopd-collection-environment-v2.xml");
        if (file.exists() && !file.delete()) {
            logger.log("failed to delete " + file.getName(), true);
            file.deleteOnExit();
        }
        if ((file = new File(f_td.getPath() + File.separator + "autopdzip" + File.separator + "autopd")).exists() && !file.delete()) {
            logger.log("failed to delete " + file.getName(), true);
            file.deleteOnExit();
        }
        if ((file = new File(f_td.getPath() + File.separator + "autopdzip")).exists() && !file.delete()) {
            logger.log("failed to delete " + file.getName(), true);
            file.deleteOnExit();
        }
        if (null != (fileArray = f_td.listFiles())) {
            for (int i = 0; i < fileArray.length; ++i) {
                String string2 = f_td.getPath() + File.separator + fileArray[i].getName();
                if (string2.equals(string) || !(file = new File(string2)).exists()) continue;
                ZipFolder.delete(file);
            }
        }
        if (null != (fileArray = f_td.listFiles()) && fileArray.length == 0 && created && !f_td.delete()) {
            logger.log("failed to delete " + f_td.getName(), true);
        }
    }

    private static void delete(File file) {
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                ZipFolder.delete(file2);
            }
        }
        if (!file.delete()) {
            logger.log("Failed to delete file: " + file, true);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void validateTempDir(String string) throws Exception {
        logger = Logger.getInstanceOf();
        f_td = new File(string);
        if (f_td.exists()) {
            if (!f_td.isDirectory()) throw new Exception("Work Directory (" + string + ") is not a valid directory!");
            File[] fileArray = f_td.listFiles();
            if (fileArray.length > 0) {
                throw new Exception("Work Directory (" + string + ") must be empty to prevent\naccidental file deletion!");
            }
            logger.log("ZipFolder", "work directory (" + string + ") exists but is empty. Dir is valid.");
            return;
        } else {
            logger.log("ZipFolder", "work directory (" + string + ") is valid...");
        }
    }

    private static boolean createTempDir(String string) {
        if (!f_td.exists()) {
            logger.log("ZipFolder", "creating work directory (" + string + ")");
            valid = f_td.mkdirs();
            created = true;
        } else {
            valid = true;
            created = false;
        }
        return valid;
    }
}

