/*
 * Decompiled with CFR 0.152.
 */
package crtmqras;

import crtmqras.Logger;
import crtmqras.Registry;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipFile {
    public static final String SHORT_COPYRIGHT_STRING = "(c) Copyright IBM Corporation 2005, 2008";
    public static final String SCCSID = "@(#) MQMBID sn=p920-038-251014 su=37056e99045b1a90fb46804fec32700b61389170 pn=cmd/tools/com.ibm.mq.tools.ras/src/crtmqras/ZipFile.java";
    public static final String LONG_COPYRIGHT_STRING = "Licensed Materials - Property of IBM 63H9336 (c) Copyright IBM Corp. 2005, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final int buffer_size = 8192;
    private FileOutputStream outf;
    private ZipOutputStream out;
    private File outFile;
    private Logger logger;
    private String Filename;
    private Set<String> outFiles;

    public String getFilename() {
        return this.Filename;
    }

    public ZipFile(File file) throws Exception {
        this.outFile = file;
        this.logger = Logger.getInstanceOf();
        this.outf = new FileOutputStream(file);
        this.outFiles = new HashSet<String>();
        this.out = new ZipOutputStream(new BufferedOutputStream(this.outf));
        this.Filename = this.outFile.getPath();
        this.logger.log("", "created new zipfile called " + this.Filename, 'V');
    }

    public boolean addFile(String string, String string2, boolean bl, boolean bl2, boolean bl3) throws Exception {
        boolean bl4 = true;
        try {
            File file = new File(string);
            String string3 = file.getName();
            this.logger.log("addFile", " file: " + string3 + " fullname: " + string);
            if (file.exists() && file.isFile()) {
                if (!string.equals(this.Filename)) {
                    if (bl) {
                        FileInputStream fileInputStream = new FileInputStream(string);
                        InputStreamReader inputStreamReader = null;
                        BufferedInputStream bufferedInputStream = null;
                        if (bl3) {
                            try {
                                this.logger.log("Attempting to convert file from ebcdic to ascii");
                                inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "Cp037");
                            }
                            catch (Exception exception) {
                                this.logger.log("Cannot use Cp037 - Files will be added, but not converted to ascii:" + exception);
                                bufferedInputStream = new BufferedInputStream(fileInputStream, 8192);
                            }
                        } else {
                            bufferedInputStream = new BufferedInputStream(fileInputStream, 8192);
                        }
                        ZipEntry zipEntry = null;
                        if (bl2) {
                            if (string2 != null) {
                                zipEntry = new ZipEntry(string2.replaceAll(Registry.SEPARATOR, "/"));
                            } else if (string.indexOf(File.separator) == 0) {
                                String string4 = string.substring(1).replaceAll(Registry.SEPARATOR, "/");
                                while (string4.indexOf(File.separator) == 0) {
                                    string4 = string4.substring(1).replaceAll(Registry.SEPARATOR, "/");
                                }
                                zipEntry = new ZipEntry(string4);
                            } else {
                                zipEntry = string.indexOf(58) == 1 ? new ZipEntry(string.substring(3).replaceAll(Registry.SEPARATOR, "/")) : new ZipEntry(string.replaceAll(Registry.SEPARATOR, "/"));
                            }
                        } else {
                            this.logger.log("Adding '" + string3 + "' without directory structure.");
                            zipEntry = new ZipEntry(string3);
                        }
                        zipEntry.setTime(file.lastModified());
                        if (!this.outFiles.add(zipEntry.getName())) {
                            fileInputStream.close();
                            return bl4;
                        }
                        this.out.putNextEntry(zipEntry);
                        if (bufferedInputStream != null) {
                            int n = 0;
                            byte[] byArray = new byte[8192];
                            while ((n = bufferedInputStream.read(byArray, 0, 8192)) != -1) {
                                this.out.write(byArray, 0, n);
                            }
                            bufferedInputStream.close();
                        } else {
                            int n;
                            char[] cArray = new char[8192];
                            while ((n = inputStreamReader.read(cArray, 0, 8192)) != -1) {
                                byte[] byArray = new String(cArray, 0, n).getBytes();
                                this.out.write(byArray, 0, byArray.length);
                            }
                            inputStreamReader.close();
                        }
                        this.out.closeEntry();
                        fileInputStream.close();
                    }
                    this.logger.log("", "added file " + string);
                }
            } else {
                bl4 = false;
                this.logger.log("", "failed to find file " + string);
            }
        }
        catch (Exception exception) {
            bl4 = false;
            this.logger.log("Error: writing file (" + this.outFile.getName() + ") " + exception.getMessage(), true);
        }
        return bl4;
    }

    public boolean addFiles(File file, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return this.addFiles(file, bl, bl2, bl3, "", bl4, "", null);
    }

    public boolean addFiles(File file, boolean bl, boolean bl2, boolean bl3, final String string, boolean bl4, String string2, String string3) {
        boolean bl5;
        block32: {
            bl5 = true;
            String string4 = "";
            try {
                if (file.exists() && file.isDirectory()) {
                    File[] fileArray = null;
                    if (string.equals("") || string.equals("*")) {
                        fileArray = file.listFiles();
                    } else {
                        FilenameFilter filenameFilter = new FilenameFilter(){

                            @Override
                            public boolean accept(File file, String string2) {
                                if (new File(file.getPath() + File.separator + string2).isDirectory()) {
                                    return true;
                                }
                                return string2.matches(string.replace(".", "\\.").replace("*", ".*"));
                            }
                        };
                        try {
                            fileArray = file.listFiles(filenameFilter);
                        }
                        catch (PatternSyntaxException patternSyntaxException) {
                            this.logger.log("Syntax error in a regular-expression pattern: " + string + ", matching 0 files");
                        }
                    }
                    if (fileArray == null || fileArray != null && fileArray.length < 1) {
                        this.logger.log("no files found in directory " + file.getPath());
                        break block32;
                    }
                    for (int i = 0; i < fileArray.length; ++i) {
                        if (string3 != null && fileArray[i].getName().equalsIgnoreCase(string3)) {
                            this.logger.log("Skipping excluded file " + string3);
                            continue;
                        }
                        string4 = file.getPath() + File.separator + fileArray[i].getName();
                        if (string4.equals(this.Filename)) continue;
                        File file2 = new File(string4);
                        if (file2.exists() && file2.isFile()) {
                            if (bl) {
                                boolean bl6 = false;
                                try {
                                    Object[] objectArray;
                                    int n;
                                    InputStreamReader inputStreamReader = null;
                                    BufferedInputStream bufferedInputStream = null;
                                    FileInputStream fileInputStream = new FileInputStream(string4);
                                    if (bl4) {
                                        try {
                                            this.logger.log("Attempting to convert file from ebcdic to ascii");
                                            inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "Cp037");
                                        }
                                        catch (Exception exception) {
                                            this.logger.log("Cannot use Cp037 - Files will be added, but not converted to ascii:" + exception);
                                            bufferedInputStream = new BufferedInputStream(fileInputStream, 8192);
                                        }
                                    } else {
                                        bufferedInputStream = new BufferedInputStream(fileInputStream, 8192);
                                    }
                                    bl6 = true;
                                    ZipEntry zipEntry = null;
                                    if (bl2) {
                                        if (string2.length() > 0) {
                                            zipEntry = new ZipEntry(string4.substring(string4.indexOf(string2)).replaceAll(Registry.SEPARATOR, "/"));
                                        } else if (string4.indexOf(File.separator) == 0) {
                                            String string5 = string4.substring(1).replaceAll(Registry.SEPARATOR, "/");
                                            while (string5.indexOf(File.separator) == 0) {
                                                string5 = string5.substring(1).replaceAll(Registry.SEPARATOR, "/");
                                            }
                                            zipEntry = new ZipEntry(string5);
                                        } else {
                                            zipEntry = string4.indexOf(58) == 1 ? new ZipEntry(string4.substring(3).replaceAll(Registry.SEPARATOR, "/")) : new ZipEntry(string4.replaceAll(Registry.SEPARATOR, "/"));
                                        }
                                    } else {
                                        String string6 = fileArray[i].getName();
                                        this.logger.log("Adding '" + string6 + "' without directory structure.");
                                        zipEntry = new ZipEntry(string6);
                                    }
                                    zipEntry.setTime(file2.lastModified());
                                    if (!this.outFiles.add(zipEntry.getName())) continue;
                                    this.out.putNextEntry(zipEntry);
                                    bl6 = false;
                                    if (bufferedInputStream != null) {
                                        n = 0;
                                        objectArray = new byte[8192];
                                        while ((n = bufferedInputStream.read((byte[])objectArray, 0, 8192)) != -1) {
                                            bl6 = true;
                                            this.out.write((byte[])objectArray, 0, n);
                                            bl6 = false;
                                        }
                                        bufferedInputStream.close();
                                    } else {
                                        objectArray = new char[8192];
                                        while ((n = inputStreamReader.read((char[])objectArray, 0, 8192)) != -1) {
                                            byte[] byArray = new String((char[])objectArray, 0, n).getBytes();
                                            bl6 = true;
                                            this.out.write(byArray, 0, byArray.length);
                                            bl6 = false;
                                        }
                                        inputStreamReader.close();
                                    }
                                    bl6 = true;
                                    this.out.closeEntry();
                                    bl6 = false;
                                    fileInputStream.close();
                                }
                                catch (Exception exception) {
                                    this.logger.log("Error including file " + string4 + ", " + exception.getMessage());
                                    if (bl6) {
                                        throw exception;
                                    }
                                    this.logger.log("ERROR: Cannot read from file " + string4 + " due to an exception:", true);
                                    this.logger.log("  " + exception.getMessage(), true);
                                }
                            }
                            this.logger.log("", "added file " + string4);
                            continue;
                        }
                        if (file2.isFile()) {
                            this.logger.log("", "failed to find file " + string4);
                            continue;
                        }
                        if (!file2.isDirectory() || !bl3) continue;
                        this.logger.log("ZipFile", string4 + " is a directory, attempting to add files from within");
                        if (string2.length() > 0) {
                            this.addFiles(file2, bl, bl2, bl3, string, bl4, string4.substring(string4.indexOf(string2)), string3);
                            continue;
                        }
                        this.addFiles(file2, bl, bl2, bl3, string, bl4, "", string3);
                    }
                    break block32;
                }
                this.logger.log("", "failed to find directory " + file.getPath());
            }
            catch (Exception exception) {
                bl5 = false;
                String string7 = "Error: adding file (" + string4 + ") " + exception.getMessage();
                this.logger.log(string7);
            }
        }
        return bl5;
    }

    public void close() throws IOException {
        this.out.flush();
        this.out.close();
        this.outf.close();
    }
}

