/*
 * Decompiled with CFR 0.152.
 */
package crtmqras;

import crtmqras.QM;
import crtmqras.Registry;
import crtmqras.StringSubstitution;

public class MQStringSubstitution
extends StringSubstitution {
    public static final String SHORT_COPYRIGHT_STRING = "(c) Copyright IBM Corporation 2010, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p920-038-251014 su=37056e99045b1a90fb46804fec32700b61389170 pn=cmd/tools/com.ibm.mq.tools.ras/src/crtmqras/MQStringSubstitution.java";
    public static final String LONG_COPYRIGHT_STRING = "Licensed Materials - Property of IBM 63H9336 (c) Copyright IBM Corp. 2010, 2016. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static String qm = "QM::";
    private static String sqm = "SQM::";
    private static String qml = "QML::";
    private static String qmd = "QMD::";
    private static String qme = "QME::";
    private static String qms = "QMS::";
    private static String mq = "MQ::";
    private static String mql = "MQL::";
    private static String mqd = "MQD::";
    private static String mqbin = "MQBIN::";
    private static String mqi = "MQI::";
    private static String wlp = "WLP::";
    private static String wlpd = "WLPD::";
    private String mqInstall = "";
    private String mqData = "";
    private String mqBin = "";
    private String wlpInstall = "";
    private String wlpData = "";

    public MQStringSubstitution(Registry registry) {
        super(registry);
        this.getMQDirs();
    }

    private void getMQDirs() {
        this.mqInstall = this.reg.getInstall_directory();
        this.mqData = this.reg.getMqDirectory();
        this.mqBin = this.reg.getExe_directory();
        this.wlpInstall = this.reg.getWlpDirectory();
        this.wlpData = this.reg.getWlpDataDirectory();
    }

    public String processLine(String string, QM qM) {
        if (!string.equalsIgnoreCase("")) {
            this.logger.log("MQStringSub", "Old Line: " + string);
            String string2 = this.replace(string, mq, this.mqInstall);
            string2 = this.replace(string2, mqd, this.mqData);
            string2 = this.replace(string2, mqbin, this.mqBin);
            String string3 = System.getenv("MQ_INSTALLATION_NAME");
            if (string3 == null) {
                this.logger.log("Environment variable MQ_INSTALLATION_NAME has not been set.");
                this.logger.log("The crtmqenv command has failed to set MQ_INSTALLATION_NAME in the runmqras.sh / runmqras.bat script.");
                System.out.println("Exiting - can't continue with a NULL MQ_INSTALLATION_NAME environment variable");
                System.exit(1);
            }
            string2 = this.replace(string2, mqi, string3);
            string2 = this.replace(string2, wlp, this.wlpInstall);
            string2 = this.replace(string2, wlpd, this.wlpData);
            if (qM != null) {
                String string4 = this.makeNameSafe(qM.getName());
                String string5 = this.makeOutputSafe(qM.getMangledName());
                string2 = this.replace(string2, sqm, string5);
                string2 = this.replace(string2, qml, qM.getLogpath());
                string2 = this.replace(string2, qmd, qM.getDataPath());
                string2 = this.replace(string2, qme, qM.getEphemPrefix());
                string2 = this.replace(string2, qms, qM.getSocketsPrefix());
                string2 = this.replace(string2, qm, string4);
            }
            this.logger.log("MQStringSub", "New Line: " + string2);
            return string2;
        }
        return string;
    }

    public boolean isMqProgram(String string) {
        return string.contains(this.mqInstall) || string.contains(this.mqBin);
    }
}

