/*
 * Decompiled with CFR 0.152.
 */
package crtmqras;

import crtmqras.CommaSeparatedList;
import crtmqras.Logger;
import crtmqras.ZipFolder;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class CommandLineArguments {
    private Logger logger;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String SCCSID = "@(#) MQMBID sn=p920-038-251014 su=37056e99045b1a90fb46804fec32700b61389170 pn=cmd/tools/com.ibm.mq.tools.ras/src/crtmqras/CommandLineArguments.java";
    public static final String CURRENT_DATE_TIME_STAMP = "yyyyMMddHHmm";
    private String inputFile;
    private String customInputFile = null;
    private String zipFile;
    private String workDirectory;
    private String section = "";
    private String timeout;
    private int timeout_value = 10;
    private boolean timeoutOverridden = false;
    private String pmrNo;
    private String caseNo;
    private String outputDir;
    private CommaSeparatedList qmList = null;
    private boolean noQmData = false;
    private boolean demoMode = false;
    private boolean verboseMode = false;
    private boolean processDefaultSections = true;
    private boolean processAllSections = false;
    private boolean toFtp = false;
    private boolean isCustom = false;
    private String ftpServer;
    private String ftpUsername;
    private String ftpPassword;
    private String ftpDirectory;

    public CommandLineArguments(Logger logger) {
        this.logger = logger;
    }

    private String xmlEncode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        block8: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block8;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block8;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block8;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block8;
                }
                case '\'': {
                    stringBuffer.append("&apos;");
                    continue block8;
                }
                case '\u0000': {
                    stringBuffer.append("\\0");
                    continue block8;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public void add(String string, String string2) throws Exception {
        if ("inputfile".equalsIgnoreCase(string)) {
            this.logger.log("inputfile - " + string2);
            this.inputFile = this.xmlEncode(string2);
        } else if ("zipfile".equalsIgnoreCase(string)) {
            this.zipFile = string2;
            this.logger.log("zipfile - " + string2);
        } else if ("demo".equalsIgnoreCase(string)) {
            this.demoMode = true;
            this.logger.log("running in demonstration mode");
        } else if ("workdirectory".equalsIgnoreCase(string)) {
            this.workDirectory = string2;
            this.logger.log("workdirectory - " + string2);
        } else if ("section".equalsIgnoreCase(string)) {
            this.section = this.checkSectionString(string2, this.section);
            this.logger.log("section - " + this.section);
        } else if ("timeout".equalsIgnoreCase(string)) {
            this.timeout = string2;
            this.logger.log("timeout - " + string2);
        } else if ("v".equalsIgnoreCase(string)) {
            this.verboseMode = true;
            this.logger.setVerboseMode();
        } else if ("pmrno".equalsIgnoreCase(string)) {
            String string3;
            this.pmrNo = string3 = this.checkPMRValue(string2);
            this.logger.log("pmrno - " + string2);
        } else if ("caseno".equalsIgnoreCase(string)) {
            String string4;
            this.caseNo = string4 = this.checkCaseValue(string2);
            this.logger.log("caseno - " + string2);
        } else if ("outputdir".equalsIgnoreCase(string)) {
            this.outputDir = string2;
            this.logger.log("outputdir - " + string2);
        } else if ("customInput".equalsIgnoreCase(string)) {
            this.customInputFile = string2;
            this.logger.log("customInput - " + string2);
        } else if ("qmlist".equalsIgnoreCase(string)) {
            this.qmList = new CommaSeparatedList(string2);
            this.logger.log("qmList - " + string2);
        } else if ("noqmdata".equalsIgnoreCase(string)) {
            this.noQmData = true;
            this.logger.log("queue manager data will be ommitted");
        } else if ("ftp".equalsIgnoreCase(string)) {
            this.toFtp = true;
            if (string2.equalsIgnoreCase("custom")) {
                this.isCustom = true;
            }
            this.logger.log("ftp - " + this.toFtp);
        } else if ("ftpserver".equalsIgnoreCase(string)) {
            this.ftpServer = string2;
            this.logger.log("FTP Server -" + this.ftpServer);
        } else if ("ftpusername".equalsIgnoreCase(string)) {
            this.ftpUsername = string2;
            this.logger.log("FTP username- " + this.ftpUsername);
        } else if ("ftppassword".equalsIgnoreCase(string)) {
            this.ftpPassword = string2;
            this.logger.log("FTP password has changed from default to password provided by user");
        } else if ("ftpdirectory".equalsIgnoreCase(string)) {
            this.ftpDirectory = string2;
            this.logger.log("FTP Directory- " + this.ftpDirectory);
        } else {
            throw new Exception("Unexpected commandLine argument: [" + string + " = \"" + string2 + "\"]");
        }
    }

    public void check() throws Exception {
        Object object;
        boolean bl = true;
        String string = "";
        this.logger.log("Checking supplied paths");
        if (this.inputFile == null || this.inputFile.length() < 1) {
            this.inputFile = System.getProperty("defaultRasInput");
            if (this.inputFile == null || this.inputFile.length() < 1) {
                string = "inputFile not specified and no default path available to use";
                this.logger.log(string);
                throw new Exception(string);
            }
            this.checkIsValidFile(this.inputFile);
            this.logger.log("Using default Input path: " + this.inputFile, true, false);
        } else {
            this.checkIsValidFile(this.inputFile);
            this.logger.log("Using Input file: " + this.inputFile, true, false);
        }
        if (this.customInputFile == null || this.customInputFile.length() < 1) {
            this.logger.log("No Custom Input file supplied");
        } else {
            this.checkIsValidFile(this.customInputFile);
            this.logger.log("Also using Custom Input file: " + this.customInputFile, true);
        }
        if (this.workDirectory == null || this.workDirectory.length() < 1) {
            this.workDirectory = System.getProperty("defaultRasWork");
            if (this.workDirectory == null || this.workDirectory.length() < 1) {
                string = "workDirectory not specified and no default path available to use";
                this.logger.log(string);
                throw new Exception(string);
            }
            ZipFolder.validateTempDir(this.workDirectory);
            this.logger.log("Using default Work path: " + this.workDirectory, true, false);
        } else {
            ZipFolder.validateTempDir(this.workDirectory);
            this.logger.log("Using Work path: " + this.workDirectory, true, false);
        }
        if (this.outputDir == null || this.outputDir.length() < 1) {
            this.outputDir = this.workDirectory;
            this.logger.log("Using default output path: " + this.outputDir, true, false);
        } else {
            this.checkIsValidDir(this.outputDir);
            this.logger.log("Using output path: " + this.outputDir, true, false);
        }
        if (this.zipFile != null && this.pmrNo != null) {
            string = "Argument error: At most one of -zipfile or -pmrno may be supplied";
            this.logger.log(string);
            throw new Exception(string);
        }
        if (this.zipFile != null && this.caseNo != null) {
            string = "Argument error: At most one of -zipfile or -caseno may be supplied";
            this.logger.log(string);
            throw new Exception(string);
        }
        if (this.pmrNo != null && this.caseNo != null) {
            string = "Argument error: At most one of -pmrno or -caseno may be supplied";
            this.logger.log(string);
            throw new Exception(string);
        }
        if (this.pmrNo != null) {
            this.zipFile = this.outputDir + File.separator + this.pmrNo;
            this.logger.log("Using Zip File path: " + this.zipFile, true, false);
        } else if (this.caseNo != null) {
            this.zipFile = this.outputDir + File.separator + this.caseNo;
            this.logger.log("Using Zip File path: " + this.zipFile, true, false);
        } else {
            if (this.zipFile == null || this.zipFile.length() < 1) {
                object = Calendar.getInstance();
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(CURRENT_DATE_TIME_STAMP);
                String string2 = simpleDateFormat.format(((Calendar)object).getTime());
                this.zipFile = "runmqras_" + string2 + ".zip";
                this.zipFile = this.zipFile.trim();
                this.zipFile = this.outputDir + File.separator + this.zipFile;
            } else if (this.zipFile.indexOf(File.separator) == -1) {
                this.logger.log("Zipfile: " + this.zipFile + " doesnt contain a file path");
                this.zipFile = this.outputDir + File.separator + this.zipFile;
            } else {
                this.logger.log("Zipfile: " + this.zipFile + " determined as containing a file path.");
            }
            this.logger.log("Using Zip File path: " + this.zipFile, true, false);
        }
        if (this.isToFtp() && !this.isCustom) {
            this.setToFtp(false);
            string = "The FTP IBM option will no longer work as the IBM FTP servers have been disabled";
            this.logger.log(string);
            throw new Exception(string);
        }
        if (this.noQmData && this.qmList != null) {
            string = "Argument error: At most one of -noqmdata or -qmlist may be supplied";
            this.logger.log(string);
            throw new Exception(string);
        }
        if (this.timeout != null) {
            try {
                this.timeout_value = Integer.parseInt(this.timeout);
                this.timeoutOverridden = true;
            }
            catch (Exception exception) {
                bl = false;
                string = exception.getMessage();
            }
            if (this.timeout_value == 0) {
                object = "User has chosen to have an indefinite timeout value";
                this.logger.log((String)object, true);
            } else if (this.timeout_value < 0 || this.timeout_value > 3600) {
                string = "value outside of range 0::3600";
                bl = false;
            }
            if (!bl) {
                throw new Exception("invalid timeout value: " + string);
            }
        }
    }

    private String checkPMRValue(String string) throws Exception {
        String string2 = string.replaceAll(",", ".");
        String[] stringArray = string2.split("\\.");
        if (stringArray.length == 3) {
            if (stringArray[0].length() != 5 || stringArray[1].length() != 3 || stringArray[2].length() != 3) {
                throw new Exception("Argument error: Invalid PMR number pattern supplied. Expected format is 'nnnnn,xxx,nnn' , where n is a numeric digit");
            }
        } else {
            throw new Exception("Argument error: Invalid PMR number pattern supplied. Expected format is 'nnnnn,xxx,nnn' , where n is a numeric digit");
        }
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(CURRENT_DATE_TIME_STAMP);
        String string3 = simpleDateFormat.format(calendar.getTime());
        string2 = string2 + ".runmqras_" + string3 + ".zip";
        string2 = string2.trim();
        return string2;
    }

    private String checkCaseValue(String string) throws Exception {
        String string2 = "(?<=\\D)(?=\\d)";
        String[] stringArray = string.split(string2);
        if (stringArray.length == 2) {
            if (stringArray[0].length() != 2 || stringArray[1].length() != 9) {
                throw new Exception("Argument error: Invalid case number pattern supplied. Expected format is 'XXnnnnnnnnn', where X is an alphabetic character, and n is a numeric digit");
            }
        } else {
            throw new Exception("Argument error: Invalid case number pattern supplied. Expected format is 'XXnnnnnnnnn', where X is an alphabetic character, and n is a numeric digit");
        }
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(CURRENT_DATE_TIME_STAMP);
        String string3 = simpleDateFormat.format(calendar.getTime());
        string = string + ".runmqras_" + string3 + ".zip";
        string = string.trim();
        return string;
    }

    private void checkIsValidFile(String string) throws Exception {
        boolean bl = true;
        String string2 = "*** File: '" + string;
        File file = new File(string);
        if (!file.exists()) {
            bl = false;
            string2 = string2 + "' doesnt exist! ***";
        } else if (!file.isFile()) {
            bl = false;
            string2 = string2 + "' is not a valid File! ***";
        }
        if (!bl) {
            this.logger.log(string2);
            throw new Exception(string2);
        }
    }

    private void checkIsValidDir(String string) throws Exception {
        boolean bl = true;
        String string2 = "*** Dir: '" + string;
        File file = new File(string);
        if (!file.exists()) {
            bl = false;
            string2 = string2 + "' doesnt exist! ***";
        } else if (!file.isDirectory()) {
            bl = false;
            string2 = string2 + "' is not a valid Directory! ***";
        }
        if (!bl) {
            this.logger.log(string2);
            throw new Exception(string2);
        }
    }

    private String checkSectionString(String string, String string2) {
        String string3 = string2;
        String string4 = string.toLowerCase();
        String string5 = "," + string4 + ",";
        if (string5.indexOf(",all,") != -1) {
            this.processAllSections = true;
        }
        if (string5.indexOf(",nodefault,") != -1) {
            this.processDefaultSections = false;
        }
        string3 = string3.equals("") ? string4 : string3 + "," + string4;
        return string3;
    }

    public String getWorkDirectory() {
        return this.workDirectory;
    }

    public String getSection() {
        return this.section;
    }

    public int getTimeout() {
        return this.timeout_value;
    }

    public boolean isTimeoutOverridden() {
        return this.timeoutOverridden;
    }

    public boolean getDemoMode() {
        return this.demoMode;
    }

    public boolean isVerboseMode() {
        return this.verboseMode;
    }

    public String getZipFile() {
        return this.zipFile;
    }

    public boolean isToFtp() {
        return this.toFtp;
    }

    public void setToFtp(boolean bl) {
        this.toFtp = bl;
    }

    public String getInputFile() {
        return this.inputFile;
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public String getCustomInputFile() {
        return this.customInputFile;
    }

    public boolean getCustomInputSupplied() {
        return this.customInputFile != null;
    }

    public CommaSeparatedList getSuppliedQMList() {
        if (this.noQmData) {
            this.qmList = new CommaSeparatedList("");
        }
        return this.qmList;
    }

    public boolean processDefaultSections() {
        return this.processDefaultSections;
    }

    public boolean processAllSections() {
        return this.processAllSections;
    }

    public boolean isCustom() {
        return this.isCustom;
    }

    public void setCustom(boolean bl) {
        this.isCustom = bl;
    }

    public String getFtpServer() {
        return this.ftpServer;
    }

    public void setFtpServer(String string) {
        this.ftpServer = string;
    }

    public String getFtpUsername() {
        return this.ftpUsername;
    }

    public void setFtpUsername(String string) {
        this.ftpUsername = string;
    }

    public String getFtpPassword() {
        return this.ftpPassword;
    }

    public void setFtpPassword(String string) {
        this.ftpPassword = string;
    }

    public String getFtpDirectory() {
        return this.ftpDirectory;
    }

    public void setFtpDirectory(String string) {
        this.ftpDirectory = string;
    }
}

