/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest.client.models;

import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import io.apicurio.registry.client.util.DateTimeUtil;
import io.apicurio.registry.rest.client.models.Labels;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class SearchedArtifact
implements AdditionalDataHolder,
Parsable {
    private Map<String, Object> additionalData;
    private String artifactId;
    private String artifactType;
    private OffsetDateTime createdOn;
    private String description;
    private String groupId;
    private Labels labels;
    private String modifiedBy;
    private OffsetDateTime modifiedOn;
    private String name;
    private String owner;

    public SearchedArtifact() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static SearchedArtifact createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new SearchedArtifact();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        return this.additionalData;
    }

    @Nullable
    public String getArtifactId() {
        return this.artifactId;
    }

    @Nullable
    public String getArtifactType() {
        return this.artifactType;
    }

    @Nullable
    public OffsetDateTime getCreatedOn() {
        return this.createdOn;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(10);
        deserializerMap.put("artifactId", n -> this.setArtifactId(n.getStringValue()));
        deserializerMap.put("artifactType", n -> this.setArtifactType(n.getStringValue()));
        deserializerMap.put("createdOn", n -> this.setCreatedOn(DateTimeUtil.getOffsetDateTimeValue((ParseNode)n)));
        deserializerMap.put("description", n -> this.setDescription(n.getStringValue()));
        deserializerMap.put("groupId", n -> this.setGroupId(n.getStringValue()));
        deserializerMap.put("labels", n -> this.setLabels((Labels)n.getObjectValue(Labels::createFromDiscriminatorValue)));
        deserializerMap.put("modifiedBy", n -> this.setModifiedBy(n.getStringValue()));
        deserializerMap.put("modifiedOn", n -> this.setModifiedOn(DateTimeUtil.getOffsetDateTimeValue((ParseNode)n)));
        deserializerMap.put("name", n -> this.setName(n.getStringValue()));
        deserializerMap.put("owner", n -> this.setOwner(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public String getGroupId() {
        return this.groupId;
    }

    @Nullable
    public Labels getLabels() {
        return this.labels;
    }

    @Nullable
    public String getModifiedBy() {
        return this.modifiedBy;
    }

    @Nullable
    public OffsetDateTime getModifiedOn() {
        return this.modifiedOn;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getOwner() {
        return this.owner;
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("artifactId", this.getArtifactId());
        writer.writeStringValue("artifactType", this.getArtifactType());
        writer.writeOffsetDateTimeValue("createdOn", this.getCreatedOn());
        writer.writeStringValue("description", this.getDescription());
        writer.writeStringValue("groupId", this.getGroupId());
        writer.writeObjectValue("labels", (Parsable)this.getLabels(), new Parsable[0]);
        writer.writeStringValue("modifiedBy", this.getModifiedBy());
        writer.writeOffsetDateTimeValue("modifiedOn", this.getModifiedOn());
        writer.writeStringValue("name", this.getName());
        writer.writeStringValue("owner", this.getOwner());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.additionalData = value;
    }

    public void setArtifactId(@Nullable String value) {
        this.artifactId = value;
    }

    public void setArtifactType(@Nullable String value) {
        this.artifactType = value;
    }

    public void setCreatedOn(@Nullable OffsetDateTime value) {
        this.createdOn = value;
    }

    public void setDescription(@Nullable String value) {
        this.description = value;
    }

    public void setGroupId(@Nullable String value) {
        this.groupId = value;
    }

    public void setLabels(@Nullable Labels value) {
        this.labels = value;
    }

    public void setModifiedBy(@Nullable String value) {
        this.modifiedBy = value;
    }

    public void setModifiedOn(@Nullable OffsetDateTime value) {
        this.modifiedOn = value;
    }

    public void setName(@Nullable String value) {
        this.name = value;
    }

    public void setOwner(@Nullable String value) {
        this.owner = value;
    }
}

