/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.resolver.config;

import java.time.Duration;
import java.util.Arrays;
import java.util.Map;

public abstract class AbstractConfig {
    protected Map<String, Object> originals;

    protected abstract Map<String, ?> getDefaults();

    protected Duration getDurationNonNegativeMillis(String key) {
        long millis;
        Object value = this.getObject(key);
        if (value == null) {
            this.reportError(key, "a non-null value", value);
        }
        if (value instanceof Number) {
            millis = ((Number)value).longValue();
        } else if (value instanceof String) {
            millis = Long.parseLong((String)value);
        } else if (value instanceof Duration) {
            millis = ((Duration)value).toMillis();
        } else {
            this.reportError(key, "a duration-like value", value);
            throw new IllegalStateException("Unreachable");
        }
        if (millis < 0L) {
            this.reportError(key, "a non-negative duration-like value", value);
        }
        return Duration.ofMillis(millis);
    }

    protected long getLongNonNegative(String key) {
        long result;
        Object value = this.getObject(key);
        if (value == null) {
            this.reportError(key, "a non-null value", value);
        }
        if (value instanceof Number) {
            result = ((Number)value).longValue();
        } else if (value instanceof String) {
            result = Long.parseLong((String)value);
        } else {
            this.reportError(key, "a number-like value", value);
            throw new IllegalStateException("Unreachable");
        }
        if (result < 0L) {
            this.reportError(key, "a non-negative number-like value", value);
        }
        return result;
    }

    protected String getString(String key) {
        Object value = this.getObject(key);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return ((String)value).trim();
        }
        this.reportError(key, "a String", value.getClass().getName());
        throw new IllegalStateException("Unreachable");
    }

    protected String getStringOneOf(String key, String ... possibilities) {
        String result = this.getString(key);
        if (!Arrays.asList(possibilities).contains(result)) {
            this.reportError(key, "one of " + Arrays.toString(possibilities), result);
        }
        return result;
    }

    protected Boolean getBooleanOrFalse(String key) {
        Boolean val = this.getBoolean(key);
        return val != null && val != false;
    }

    protected Boolean getBoolean(String key) {
        Object value = this.getObject(key);
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            String trimmed = ((String)value).trim();
            if (trimmed.equalsIgnoreCase("true")) {
                return true;
            }
            if (trimmed.equalsIgnoreCase("false")) {
                return false;
            }
            this.reportError(key, "a boolean-like value", value);
            throw new IllegalStateException("Unreachable");
        }
        this.reportError(key, "a boolean-like value", value);
        throw new IllegalStateException("Unreachable");
    }

    protected Object getObject(String key) {
        if (key == null) {
            throw new NullPointerException("Configuration property key is null.");
        }
        if (!this.originals.containsKey(key) && this.getDefaults().containsKey(key)) {
            return this.getDefaults().get(key);
        }
        return this.originals.get(key);
    }

    protected Class<?> getClass(String className) {
        try {
            Object value = this.originals.get(className);
            if (value == null) {
                return null;
            }
            if (value instanceof Class) {
                return (Class)value;
            }
            if (value instanceof String) {
                return this.getClass().getClassLoader().loadClass((String)value);
            }
            this.reportError(className, "a Class or String", value.getClass().getName());
            throw new IllegalStateException("Unreachable");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, Object> originals() {
        return this.originals;
    }

    private void reportError(String key, String expectedText, Object value) {
        throw new IllegalArgumentException("Invalid configuration property value for '" + key + "'. Expected " + expectedText + ", but got a '" + String.valueOf(value) + "'.");
    }
}

