/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.resolver.client;

import io.apicurio.registry.resolver.client.RegistryArtifactReference;
import io.apicurio.registry.resolver.client.RegistryClientFacade;
import io.apicurio.registry.resolver.client.RegistryVersionCoordinates;
import io.apicurio.registry.rest.client.models.IfArtifactExists;
import io.apicurio.registry.rest.client.v2.RegistryClient;
import io.apicurio.registry.rest.client.v2.groups.item.artifacts.ArtifactsRequestBuilder;
import io.apicurio.registry.rest.client.v2.models.ArtifactContent;
import io.apicurio.registry.rest.client.v2.models.ArtifactMetaData;
import io.apicurio.registry.rest.client.v2.models.ArtifactReference;
import io.apicurio.registry.rest.client.v2.models.ArtifactState;
import io.apicurio.registry.rest.client.v2.models.IfExists;
import io.apicurio.registry.rest.client.v2.models.VersionMetaData;
import io.apicurio.registry.utils.IoUtil;
import io.vertx.core.Vertx;
import java.io.InputStream;
import java.util.List;
import java.util.Set;

public class RegistryClientFacadeImpl_v2
implements RegistryClientFacade {
    private final RegistryClient client;
    private Vertx vertx;

    public RegistryClientFacadeImpl_v2(RegistryClient client) {
        this(client, null);
    }

    public RegistryClientFacadeImpl_v2(RegistryClient client, Vertx vertx) {
        this.client = client;
        this.vertx = vertx;
    }

    public RegistryClient getClient() {
        return this.client;
    }

    @Override
    public String getSchemaByContentId(Long contentId) {
        InputStream rawSchema = this.client.ids().contentIds().byContentId(contentId).get();
        return IoUtil.toString((InputStream)rawSchema);
    }

    @Override
    public String getSchemaByGlobalId(long globalId, boolean dereferenced) {
        InputStream rawSchema = this.client.ids().globalIds().byGlobalId(Long.valueOf(globalId)).get(config -> {
            assert (config.queryParameters != null);
            if (dereferenced) {
                config.queryParameters.dereference = true;
            }
        });
        return IoUtil.toString((InputStream)rawSchema);
    }

    @Override
    public String getSchemaByGAV(String groupId, String artifactId, String version) {
        InputStream rawSchema = this.client.groups().byGroupId(groupId).artifacts().byArtifactId(artifactId).versions().byVersion(version).get();
        return IoUtil.toString((InputStream)rawSchema);
    }

    @Override
    public String getSchemaByContentHash(String contentHash) {
        InputStream rawSchema = this.client.ids().contentHashes().byContentHash(contentHash).get();
        return IoUtil.toString((InputStream)rawSchema);
    }

    @Override
    public List<RegistryArtifactReference> getReferencesByContentId(long contentId) {
        List references = this.client.ids().contentIds().byContentId(Long.valueOf(contentId)).references().get();
        return references.stream().map(RegistryArtifactReference::fromClientArtifactReference).toList();
    }

    @Override
    public List<RegistryArtifactReference> getReferencesByGlobalId(long globalId) {
        List references = this.client.ids().globalIds().byGlobalId(Long.valueOf(globalId)).references().get();
        return references.stream().map(RegistryArtifactReference::fromClientArtifactReference).toList();
    }

    @Override
    public List<RegistryArtifactReference> getReferencesByGAV(String groupId, String artifactId, String version) {
        List references = this.client.groups().byGroupId(groupId).artifacts().byArtifactId(artifactId).versions().byVersion(version).references().get();
        return references.stream().map(RegistryArtifactReference::fromClientArtifactReference).toList();
    }

    @Override
    public List<RegistryArtifactReference> getReferencesByContentHash(String contentHash) {
        List references = this.client.ids().contentHashes().byContentHash(contentHash).references().get();
        return references.stream().map(RegistryArtifactReference::fromClientArtifactReference).toList();
    }

    @Override
    public List<RegistryVersionCoordinates> searchVersionsByContent(String schemaString, String artifactType, io.apicurio.registry.resolver.strategy.ArtifactReference reference, boolean canonical) {
        ArtifactContent content = new ArtifactContent();
        content.setContent(schemaString);
        String groupId = reference.getGroupId() == null ? "default" : reference.getGroupId();
        String artifactId = reference.getArtifactId();
        VersionMetaData vmd = this.client.groups().byGroupId(groupId).artifacts().byArtifactId(artifactId).meta().post(content, config -> {
            config.queryParameters.canonical = canonical;
        });
        if (ArtifactState.DISABLED == vmd.getState()) {
            return List.of();
        }
        return List.of(RegistryVersionCoordinates.create(vmd.getGlobalId(), vmd.getContentId(), vmd.getGroupId(), vmd.getId(), vmd.getVersion()));
    }

    @Override
    public RegistryVersionCoordinates createSchema(String artifactType, String groupId, String artifactId, String version, String autoCreateBehavior, boolean canonical, String schemaString, Set<RegistryArtifactReference> references) {
        ArtifactContent content = new ArtifactContent();
        content.setContent(schemaString);
        content.setReferences(RegistryClientFacadeImpl_v2.toClientReferences(references));
        IfArtifactExists ifArtifactExists = IfArtifactExists.forValue((String)autoCreateBehavior);
        ArtifactMetaData amd = this.client.groups().byGroupId(groupId).artifacts().post(content, arg_0 -> RegistryClientFacadeImpl_v2.lambda$createSchema$2(switch (ifArtifactExists) {
            case IfArtifactExists.FIND_OR_CREATE_VERSION -> IfExists.RETURN_OR_UPDATE;
            case IfArtifactExists.FAIL -> IfExists.FAIL;
            default -> IfExists.UPDATE;
        }, canonical, version, artifactId, artifactType, arg_0));
        return RegistryVersionCoordinates.create(amd.getGlobalId(), amd.getContentId(), amd.getGroupId(), amd.getId(), amd.getVersion());
    }

    @Override
    public RegistryVersionCoordinates getVersionCoordinatesByGAV(String groupId, String artifactId, String version) {
        if (version == null) {
            version = "latest";
        }
        VersionMetaData vmd = this.client.groups().byGroupId(groupId).artifacts().byArtifactId(artifactId).versions().byVersion(version).meta().get();
        return RegistryVersionCoordinates.create(vmd.getGlobalId(), vmd.getContentId(), vmd.getGroupId(), vmd.getId(), vmd.getVersion());
    }

    @Override
    public void close() throws Exception {
        if (this.vertx != null) {
            this.vertx.close();
            this.vertx = null;
        }
    }

    private static List<ArtifactReference> toClientReferences(Set<RegistryArtifactReference> references) {
        return references.stream().map(ref -> {
            ArtifactReference ar = new ArtifactReference();
            ar.setName(ref.getName());
            ar.setGroupId(ref.getGroupId());
            ar.setArtifactId(ref.getArtifactId());
            ar.setVersion(ref.getVersion());
            return ar;
        }).toList();
    }

    private static /* synthetic */ void lambda$createSchema$2(IfExists ifExists, boolean canonical, String version, String artifactId, String artifactType, ArtifactsRequestBuilder.PostRequestConfiguration config) {
        config.queryParameters.ifExists = ifExists;
        config.queryParameters.canonical = canonical;
        if (version != null) {
            config.headers.add("X-Registry-Version", version);
        }
        if (artifactId != null) {
            config.headers.add("X-Registry-ArtifactId", artifactId);
        }
        if (artifactType != null) {
            config.headers.add("X-Registry-ArtifactType", artifactType);
        }
    }
}

