/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.resolver.client;

import io.apicurio.registry.client.RegistryClientFactory;
import io.apicurio.registry.client.RegistryClientOptions;
import io.apicurio.registry.client.RegistryV2ClientFactory;
import io.apicurio.registry.resolver.client.RegistryClientFacade;
import io.apicurio.registry.resolver.client.RegistryClientFacadeImpl;
import io.apicurio.registry.resolver.client.RegistryClientFacadeImpl_v2;
import io.apicurio.registry.resolver.config.SchemaResolverConfig;
import io.apicurio.registry.rest.client.v2.RegistryClient;
import io.vertx.core.Vertx;
import java.util.logging.Logger;

public class RegistryClientFacadeFactory {
    private static final Logger logger = Logger.getLogger(RegistryClientFacadeFactory.class.getSimpleName());
    public static Vertx vertx;

    public static RegistryClientFacade create(SchemaResolverConfig config) {
        String baseUrl = config.getRegistryUrl();
        if (baseUrl == null) {
            throw new IllegalArgumentException("Missing registry base url, set apicurio.registry.url");
        }
        Vertx ivertx = vertx == null ? Vertx.vertx() : vertx;
        boolean shouldCloseVertx = vertx == null;
        String endpointVersion = null;
        if (config.getRegistryUrlVersion() != null) {
            endpointVersion = config.getRegistryUrlVersion();
        }
        endpointVersion = endpointVersion == null && baseUrl.contains("/apis/registry/v2") ? "2" : "3";
        switch (endpointVersion) {
            case "2": {
                return RegistryClientFacadeFactory.create_v2(config, ivertx, shouldCloseVertx);
            }
        }
        return RegistryClientFacadeFactory.create_v3(config, ivertx, shouldCloseVertx);
    }

    private static RegistryClientOptions buildClientOptions(SchemaResolverConfig config, Vertx vertx) {
        String baseUrl = config.getRegistryUrl();
        String tokenEndpoint = config.getTokenEndpoint();
        String username = config.getAuthUsername();
        RegistryClientOptions clientOptions = RegistryClientOptions.create((String)baseUrl, (Vertx)vertx);
        try {
            if (tokenEndpoint != null) {
                String clientId = config.getAuthClientId();
                String clientSecret = config.getAuthClientSecret();
                String clientScope = config.getAuthClientScope();
                if (clientId == null) {
                    throw new IllegalArgumentException("Missing registry auth clientId, set apicurio.registry.auth.client.id");
                }
                if (clientSecret == null) {
                    throw new IllegalArgumentException("Missing registry auth secret, set apicurio.registry.auth.client.secret");
                }
                clientOptions.oauth2(tokenEndpoint, clientId, clientSecret, clientScope);
            } else if (username != null) {
                String password = config.getAuthPassword();
                if (password == null) {
                    throw new IllegalArgumentException("Missing registry auth password, set apicurio.registry.auth.password");
                }
                clientOptions.basicAuth(username, password);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        if (Boolean.TRUE.booleanValue()) {
            clientOptions.retry();
        }
        String truststoreLocation = config.getTlsTruststoreLocation();
        String truststorePassword = config.getTlsTruststorePassword();
        String truststoreType = config.getTlsTruststoreType();
        String certificates = config.getTlsCertificates();
        boolean trustAll = config.getTlsTrustAll();
        boolean verifyHost = config.getTlsVerifyHost();
        if (trustAll) {
            clientOptions.trustAll(true);
        } else if (truststoreLocation != null) {
            if ("JKS".equalsIgnoreCase(truststoreType)) {
                clientOptions.trustStoreJks(truststoreLocation, truststorePassword);
            } else if ("PKCS12".equalsIgnoreCase(truststoreType) || "P12".equalsIgnoreCase(truststoreType)) {
                clientOptions.trustStorePkcs12(truststoreLocation, truststorePassword);
            } else if ("PEM".equalsIgnoreCase(truststoreType)) {
                clientOptions.trustStorePem(new String[]{truststoreLocation});
            }
        } else if (certificates != null) {
            if (certificates.contains("-----BEGIN CERTIFICATE-----")) {
                clientOptions.trustStorePemContent(certificates);
            } else {
                String[] certPaths = certificates.split(",");
                for (int i = 0; i < certPaths.length; ++i) {
                    certPaths[i] = certPaths[i].trim();
                }
                clientOptions.trustStorePem(certPaths);
            }
        }
        if (!verifyHost) {
            clientOptions.verifyHost(false);
        }
        String proxyHost = config.getProxyHost();
        Integer proxyPort = config.getProxyPort();
        if (proxyHost != null && proxyPort != null) {
            clientOptions.proxy(proxyHost, proxyPort.intValue());
            String proxyUsername = config.getProxyUsername();
            String proxyPassword = config.getProxyPassword();
            if (proxyUsername != null && proxyPassword != null) {
                clientOptions.proxyAuth(proxyUsername, proxyPassword);
            }
        }
        return clientOptions;
    }

    private static RegistryClientFacade create_v3(SchemaResolverConfig config, Vertx vertx, boolean shouldCloseVertx) {
        RegistryClientOptions clientOptions = RegistryClientFacadeFactory.buildClientOptions(config, vertx);
        io.apicurio.registry.rest.client.RegistryClient client = RegistryClientFactory.create((RegistryClientOptions)clientOptions);
        return new RegistryClientFacadeImpl(client, (Vertx)(shouldCloseVertx ? vertx : null));
    }

    private static RegistryClientFacade create_v2(SchemaResolverConfig config, Vertx vertx, boolean shouldCloseVertx) {
        logger.warning("Using a deprecated version (2.x) of Apicurio Registry.  It is recommended to upgrade your Apicurio Registry.");
        RegistryClientOptions clientOptions = RegistryClientFacadeFactory.buildClientOptions(config, vertx);
        RegistryClient client = RegistryV2ClientFactory.create((RegistryClientOptions)clientOptions);
        return new RegistryClientFacadeImpl_v2(client, (Vertx)(shouldCloseVertx ? vertx : null));
    }
}

