/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.serde.avro;

import io.apicurio.registry.serde.avro.AvroEncoding;
import io.apicurio.registry.serde.avro.DefaultAvroDatumProvider;
import io.apicurio.registry.serde.config.SerdeConfig;
import java.util.HashMap;
import java.util.Map;

public class AvroSerdeConfig
extends SerdeConfig {
    public static final String AVRO_ENCODING = "apicurio.registry.avro.encoding";
    public static final String AVRO_ENCODING_JSON = "JSON";
    public static final String AVRO_ENCODING_BINARY = "BINARY";
    public static final String AVRO_DATUM_PROVIDER = "apicurio.registry.avro-datum-provider";
    public static final String AVRO_DATUM_PROVIDER_DEFAULT = DefaultAvroDatumProvider.class.getName();
    public static final String USE_SPECIFIC_AVRO_READER = "apicurio.registry.use-specific-avro-reader";
    public static final boolean USE_SPECIFIC_AVRO_READER_DEFAULT = false;
    private static final Map<String, ?> DEFAULTS = Map.of("apicurio.registry.avro.encoding", AvroEncoding.BINARY.name(), "apicurio.registry.avro-datum-provider", AVRO_DATUM_PROVIDER_DEFAULT, "apicurio.registry.use-specific-avro-reader", false);

    public AvroSerdeConfig(Map<String, ?> originals) {
        HashMap joint = new HashMap(this.getDefaults());
        joint.putAll(originals);
        this.originals = joint;
    }

    public AvroEncoding getAvroEncoding() {
        return AvroEncoding.valueOf(this.getString(AVRO_ENCODING));
    }

    public Class<?> getAvroDatumProvider() {
        return this.getClass(AVRO_DATUM_PROVIDER);
    }

    public boolean useSpecificAvroReader() {
        return this.getBoolean(USE_SPECIFIC_AVRO_READER);
    }

    protected Map<String, ?> getDefaults() {
        HashMap joint = new HashMap(super.getDefaults());
        joint.putAll(DEFAULTS);
        return joint;
    }
}

