/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.serde.avro;

import io.apicurio.registry.resolver.ParsedSchema;
import io.apicurio.registry.resolver.SchemaParser;
import io.apicurio.registry.resolver.SchemaResolver;
import io.apicurio.registry.resolver.client.RegistryClientFacade;
import io.apicurio.registry.resolver.strategy.ArtifactReferenceResolverStrategy;
import io.apicurio.registry.resolver.utils.Utils;
import io.apicurio.registry.serde.AbstractDeserializer;
import io.apicurio.registry.serde.avro.AvroDatumProvider;
import io.apicurio.registry.serde.avro.AvroEncoding;
import io.apicurio.registry.serde.avro.AvroSchemaParser;
import io.apicurio.registry.serde.avro.AvroSerdeConfig;
import io.apicurio.registry.serde.config.SerdeConfig;
import io.apicurio.registry.serde.utils.ByteBufferInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.avro.Schema;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;

public class AvroDeserializer<U>
extends AbstractDeserializer<Schema, U> {
    private final DecoderFactory decoderFactory = DecoderFactory.get();
    private AvroSchemaParser<U> parser;
    private AvroDatumProvider<U> avroDatumProvider;
    private AvroEncoding encoding;

    public AvroDeserializer() {
    }

    public AvroDeserializer(RegistryClientFacade clientFacade) {
        super(clientFacade);
    }

    public AvroDeserializer(SchemaResolver<Schema, U> schemaResolver) {
        super(schemaResolver);
    }

    public AvroDeserializer(RegistryClientFacade clientFacade, SchemaResolver<Schema, U> schemaResolver) {
        super(clientFacade, schemaResolver);
    }

    public AvroDeserializer(RegistryClientFacade clientFacade, ArtifactReferenceResolverStrategy<Schema, U> strategy, SchemaResolver<Schema, U> schemaResolver) {
        super(clientFacade, strategy, schemaResolver);
    }

    public void configure(SerdeConfig configs, boolean isKey) {
        AvroSerdeConfig config = new AvroSerdeConfig(configs.originals());
        this.encoding = config.getAvroEncoding();
        Class<?> adp = config.getAvroDatumProvider();
        Consumer<AvroDatumProvider> consumer = this::setAvroDatumProvider;
        Utils.instantiate(AvroDatumProvider.class, adp, consumer);
        this.avroDatumProvider.configure(config);
        this.parser = new AvroSchemaParser<U>(this.avroDatumProvider);
        super.configure((SerdeConfig)config, isKey);
    }

    public SchemaParser<Schema, U> schemaParser() {
        return this.parser;
    }

    protected U readData(ParsedSchema<Schema> schema, ByteBuffer buffer, int start, int length) {
        AvroEncoding encoding = null;
        if (this.encoding != null) {
            encoding = this.encoding;
        }
        try {
            DatumReader<U> reader = this.avroDatumProvider.createDatumReader((Schema)schema.getParsedSchema());
            if (encoding == AvroEncoding.JSON) {
                ByteBuffer slice = buffer.duplicate();
                slice.position(start);
                slice.limit(start + length);
                return (U)reader.read(null, (Decoder)this.decoderFactory.jsonDecoder((Schema)schema.getParsedSchema(), (InputStream)new ByteBufferInputStream(slice)));
            }
            return (U)reader.read(null, (Decoder)this.decoderFactory.binaryDecoder(buffer.array(), start, length, null));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public AvroDeserializer<U> setAvroDatumProvider(AvroDatumProvider<U> avroDatumProvider) {
        this.avroDatumProvider = Objects.requireNonNull(avroDatumProvider);
        return this;
    }

    public void setEncoding(AvroEncoding encoding) {
        this.encoding = encoding;
    }
}

