/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest.v2;

import io.apicurio.registry.rest.v2.beans.ArtifactTypeInfo;
import io.apicurio.registry.rest.v2.beans.ConfigurationProperty;
import io.apicurio.registry.rest.v2.beans.RoleMapping;
import io.apicurio.registry.rest.v2.beans.Rule;
import io.apicurio.registry.rest.v2.beans.UpdateConfigurationProperty;
import io.apicurio.registry.rest.v2.beans.UpdateRole;
import io.apicurio.registry.types.RuleType;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.util.List;

@Path(value="/apis/registry/v2/admin")
public interface AdminResource {
    @Path(value="/artifactTypes")
    @GET
    @Produces(value={"application/json"})
    public List<ArtifactTypeInfo> listArtifactTypes();

    @Path(value="/rules")
    @GET
    @Produces(value={"application/json"})
    public List<RuleType> listGlobalRules();

    @Path(value="/rules")
    @POST
    @Consumes(value={"application/json"})
    public void createGlobalRule(@NotNull Rule var1);

    @Path(value="/rules")
    @DELETE
    public void deleteAllGlobalRules();

    @Path(value="/rules/{rule}")
    @GET
    @Produces(value={"application/json"})
    public Rule getGlobalRuleConfig(@PathParam(value="rule") RuleType var1);

    @Path(value="/rules/{rule}")
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Rule updateGlobalRuleConfig(@PathParam(value="rule") RuleType var1, @NotNull Rule var2);

    @Path(value="/rules/{rule}")
    @DELETE
    public void deleteGlobalRule(@PathParam(value="rule") RuleType var1);

    @Path(value="/export")
    @GET
    @Produces(value={"application/json", "application/zip"})
    public Response exportData(@QueryParam(value="forBrowser") Boolean var1);

    @Path(value="/import")
    @POST
    @Consumes(value={"application/zip"})
    public void importData(@HeaderParam(value="X-Registry-Preserve-GlobalId") Boolean var1, @HeaderParam(value="X-Registry-Preserve-ContentId") Boolean var2, @NotNull InputStream var3);

    @Path(value="/roleMappings/{principalId}")
    @GET
    @Produces(value={"application/json"})
    public RoleMapping getRoleMapping(@PathParam(value="principalId") String var1);

    @Path(value="/roleMappings/{principalId}")
    @PUT
    @Consumes(value={"application/json"})
    public void updateRoleMapping(@PathParam(value="principalId") String var1, @NotNull UpdateRole var2);

    @Path(value="/roleMappings/{principalId}")
    @DELETE
    public void deleteRoleMapping(@PathParam(value="principalId") String var1);

    @Path(value="/roleMappings")
    @GET
    @Produces(value={"application/json"})
    public List<RoleMapping> listRoleMappings();

    @Path(value="/roleMappings")
    @POST
    @Consumes(value={"application/json"})
    public void createRoleMapping(@NotNull RoleMapping var1);

    @Path(value="/config/properties")
    @GET
    @Produces(value={"application/json"})
    public List<ConfigurationProperty> listConfigProperties();

    @Path(value="/config/properties/{propertyName}")
    @GET
    @Produces(value={"application/json"})
    public ConfigurationProperty getConfigProperty(@PathParam(value="propertyName") String var1);

    @Path(value="/config/properties/{propertyName}")
    @PUT
    @Consumes(value={"application/json"})
    public void updateConfigProperty(@PathParam(value="propertyName") String var1, @NotNull UpdateConfigurationProperty var2);

    @Path(value="/config/properties/{propertyName}")
    @DELETE
    public void resetConfigProperty(@PathParam(value="propertyName") String var1);
}

