/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest.client.v2.search.artifacts;

import com.microsoft.kiota.BaseRequestBuilder;
import com.microsoft.kiota.BaseRequestConfiguration;
import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.QueryParameters;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.serialization.ParsableFactory;
import io.apicurio.registry.rest.client.v2.models.ArtifactSearchResults;
import io.apicurio.registry.rest.client.v2.models.Error;
import io.apicurio.registry.rest.client.v2.models.SortBy;
import io.apicurio.registry.rest.client.v2.models.SortOrder;
import io.apicurio.registry.rest.client.v2.search.artifacts.PostOrderQueryParameterType;
import io.apicurio.registry.rest.client.v2.search.artifacts.PostOrderbyQueryParameterType;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ArtifactsRequestBuilder
extends BaseRequestBuilder {
    public ArtifactsRequestBuilder(@Nonnull HashMap<String, Object> pathParameters, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/search/artifacts{?artifactType*,canonical*,contentId*,description*,globalId*,group*,labels*,limit*,name*,offset*,order*,orderby*,properties*}", pathParameters);
    }

    public ArtifactsRequestBuilder(@Nonnull String rawUrl, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/search/artifacts{?artifactType*,canonical*,contentId*,description*,globalId*,group*,labels*,limit*,name*,offset*,order*,orderby*,properties*}", rawUrl);
    }

    @Nullable
    public ArtifactSearchResults get() {
        return this.get(null);
    }

    @Nullable
    public ArtifactSearchResults get(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = this.toGetRequestInformation(requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("500", Error::createFromDiscriminatorValue);
        return (ArtifactSearchResults)this.requestAdapter.send(requestInfo, errorMapping, ArtifactSearchResults::createFromDiscriminatorValue);
    }

    @Nullable
    public ArtifactSearchResults post(@Nonnull InputStream body, @Nonnull String contentType) {
        return this.post(body, contentType, null);
    }

    @Nullable
    public ArtifactSearchResults post(@Nonnull InputStream body, @Nonnull String contentType, @Nullable Consumer<PostRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        Objects.requireNonNull(contentType);
        RequestInformation requestInfo = this.toPostRequestInformation(body, contentType, requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("500", Error::createFromDiscriminatorValue);
        return (ArtifactSearchResults)this.requestAdapter.send(requestInfo, errorMapping, ArtifactSearchResults::createFromDiscriminatorValue);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation() {
        return this.toGetRequestInformation(null);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = new RequestInformation(HttpMethod.GET, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new GetRequestConfiguration(), x -> x.queryParameters);
        requestInfo.headers.tryAdd("Accept", "application/json");
        return requestInfo;
    }

    @Nonnull
    public RequestInformation toPostRequestInformation(@Nonnull InputStream body, @Nonnull String contentType) {
        return this.toPostRequestInformation(body, contentType, null);
    }

    @Nonnull
    public RequestInformation toPostRequestInformation(@Nonnull InputStream body, @Nonnull String contentType, @Nullable Consumer<PostRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        Objects.requireNonNull(contentType);
        RequestInformation requestInfo = new RequestInformation(HttpMethod.POST, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new PostRequestConfiguration(), x -> x.queryParameters);
        requestInfo.headers.tryAdd("Accept", "application/json");
        requestInfo.setStreamContent(body, contentType);
        return requestInfo;
    }

    @Nonnull
    public ArtifactsRequestBuilder withUrl(@Nonnull String rawUrl) {
        Objects.requireNonNull(rawUrl);
        return new ArtifactsRequestBuilder(rawUrl, this.requestAdapter);
    }

    public class PostRequestConfiguration
    extends BaseRequestConfiguration {
        @Nullable
        public PostQueryParameters queryParameters;

        public PostRequestConfiguration() {
            this.queryParameters = new PostQueryParameters();
        }
    }

    public class PostQueryParameters
    implements QueryParameters {
        @Nullable
        public String artifactType;
        @Nullable
        public Boolean canonical;
        @Nullable
        public Integer limit;
        @Nullable
        public Integer offset;
        @Nullable
        public PostOrderQueryParameterType order;
        @Nullable
        public PostOrderbyQueryParameterType orderby;

        @Nonnull
        public Map<String, Object> toQueryParameters() {
            HashMap<String, Object> allQueryParams = new HashMap<String, Object>();
            allQueryParams.put("order", (Object)this.order);
            allQueryParams.put("orderby", (Object)this.orderby);
            allQueryParams.put("artifactType", this.artifactType);
            allQueryParams.put("canonical", this.canonical);
            allQueryParams.put("limit", this.limit);
            allQueryParams.put("offset", this.offset);
            return allQueryParams;
        }
    }

    public class GetRequestConfiguration
    extends BaseRequestConfiguration {
        @Nullable
        public GetQueryParameters queryParameters;

        public GetRequestConfiguration() {
            this.queryParameters = new GetQueryParameters();
        }
    }

    public class GetQueryParameters
    implements QueryParameters {
        @Nullable
        public Long contentId;
        @Nullable
        public String description;
        @Nullable
        public Long globalId;
        @Nullable
        public String group;
        @Nullable
        public String[] labels;
        @Nullable
        public Integer limit;
        @Nullable
        public String name;
        @Nullable
        public Integer offset;
        @Nullable
        public SortOrder order;
        @Nullable
        public SortBy orderby;
        @Nullable
        public String[] properties;

        @Nonnull
        public Map<String, Object> toQueryParameters() {
            HashMap<String, Object> allQueryParams = new HashMap<String, Object>();
            allQueryParams.put("order", (Object)this.order);
            allQueryParams.put("orderby", (Object)this.orderby);
            allQueryParams.put("contentId", this.contentId);
            allQueryParams.put("description", this.description);
            allQueryParams.put("globalId", this.globalId);
            allQueryParams.put("group", this.group);
            allQueryParams.put("limit", this.limit);
            allQueryParams.put("name", this.name);
            allQueryParams.put("offset", this.offset);
            allQueryParams.put("labels", this.labels);
            allQueryParams.put("properties", this.properties);
            return allQueryParams;
        }
    }
}

