/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.serde;

import io.apicurio.registry.resolver.SchemaResolver;
import io.apicurio.registry.resolver.strategy.ArtifactReference;
import io.apicurio.registry.resolver.utils.Utils;
import io.apicurio.registry.serde.AbstractDeserializer;
import io.apicurio.registry.serde.Default4ByteIdHandler;
import io.apicurio.registry.serde.IdHandler;
import io.apicurio.registry.serde.config.BaseKafkaSerDeConfig;
import io.apicurio.registry.serde.config.SerdeConfig;
import io.apicurio.registry.serde.headers.HeadersHandler;
import java.util.Map;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;

public class KafkaDeserializer<T, U>
implements Deserializer<U> {
    protected final AbstractDeserializer<T, U> delegatedDeserializer;
    protected HeadersHandler headersHandler;

    protected KafkaDeserializer(AbstractDeserializer<T, U> delegatedDeserializer) {
        this.delegatedDeserializer = delegatedDeserializer;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.delegatedDeserializer.configure(new SerdeConfig(configs), isKey);
        this.configure(new BaseKafkaSerDeConfig(configs), isKey);
    }

    public U deserialize(String topic, byte[] data) {
        return (U)this.delegatedDeserializer.deserializeData(topic, data);
    }

    public U deserialize(String topic, Headers headers, byte[] data) {
        if (data == null) {
            return null;
        }
        ArtifactReference artifactReference = null;
        if (this.headersHandler != null && headers != null && (artifactReference = this.headersHandler.readHeaders(headers)).hasValue()) {
            return (U)this.delegatedDeserializer.readData(topic, data, artifactReference);
        }
        if (data[0] == 0) {
            return this.deserialize(topic, data);
        }
        if (headers == null) {
            throw new IllegalStateException("Headers cannot be null");
        }
        return (U)this.delegatedDeserializer.readData(topic, data, artifactReference);
    }

    protected void configure(BaseKafkaSerDeConfig config, boolean isKey) {
        boolean headersEnabled = config.enableHeaders();
        if (headersEnabled) {
            Object headersHandler = config.getHeadersHandler();
            Utils.instantiate(HeadersHandler.class, (Object)headersHandler, this::setHeadersHandler);
            this.headersHandler.configure(config.originals(), isKey);
        }
    }

    public void setHeadersHandler(HeadersHandler headersHandler) {
        this.headersHandler = headersHandler;
    }

    public void close() {
        this.delegatedDeserializer.getSerdeConfigurer().close();
    }

    public void as4ByteId() {
        this.delegatedDeserializer.getSerdeConfigurer().setIdHandler((IdHandler)new Default4ByteIdHandler());
    }

    public SchemaResolver<T, U> getSchemaResolver() {
        return this.delegatedDeserializer.getSerdeConfigurer().getSchemaResolver();
    }

    public void setSchemaResolver(SchemaResolver<T, U> schemaResolver) {
        this.delegatedDeserializer.getSerdeConfigurer().setSchemaResolver(schemaResolver);
    }
}

