/*
 * Decompiled with CFR 0.152.
 */
package io.kiota.http.jdk;

import com.microsoft.kiota.ApiClientBuilder;
import com.microsoft.kiota.ApiException;
import com.microsoft.kiota.ApiExceptionBuilder;
import com.microsoft.kiota.PeriodAndDuration;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.RequestOption;
import com.microsoft.kiota.ResponseHandler;
import com.microsoft.kiota.ResponseHandlerOption;
import com.microsoft.kiota.ResponseHeaders;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.ParseNodeFactory;
import com.microsoft.kiota.serialization.ParseNodeFactoryRegistry;
import com.microsoft.kiota.serialization.SerializationWriterFactory;
import com.microsoft.kiota.serialization.SerializationWriterFactoryRegistry;
import com.microsoft.kiota.serialization.ValuedEnumParser;
import com.microsoft.kiota.store.BackingStoreFactory;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import io.kiota.http.jdk.HeadersCompatibility;
import io.kiota.http.jdk.HttpRequestCompatibility;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public class JDKRequestAdapter
implements RequestAdapter {
    private static final String contentTypeHeaderKey = "Content-Type";
    @Nonnull
    private final HttpClient client;
    @Nonnull
    private ParseNodeFactory pNodeFactory;
    @Nonnull
    private SerializationWriterFactory sWriterFactory;
    @Nonnull
    private String baseUrl = "";
    private static final String nullRequestInfoParameter = "parameter requestInfo cannot be null";
    private static final String nullEnumParserParameter = "parameter enumParser cannot be null";
    private static final String nullFactoryParameter = "parameter factory cannot be null";

    public void setBaseUrl(@Nonnull String baseUrl) {
        this.baseUrl = Objects.requireNonNull(baseUrl);
    }

    @Nonnull
    public String getBaseUrl() {
        return this.baseUrl;
    }

    public JDKRequestAdapter() {
        this(null, null, null);
    }

    public JDKRequestAdapter(@Nonnull HttpClient client) {
        this(client, null, null);
    }

    public JDKRequestAdapter(@Nullable HttpClient client, @Nullable ParseNodeFactory parseNodeFactory) {
        this(client, parseNodeFactory, null);
    }

    public JDKRequestAdapter(@Nullable HttpClient client, @Nullable ParseNodeFactory parseNodeFactory, @Nullable SerializationWriterFactory serializationWriterFactory) {
        this.client = client == null ? HttpClient.newHttpClient() : client;
        this.pNodeFactory = parseNodeFactory == null ? ParseNodeFactoryRegistry.defaultInstance : parseNodeFactory;
        this.sWriterFactory = serializationWriterFactory == null ? SerializationWriterFactoryRegistry.defaultInstance : serializationWriterFactory;
    }

    @Nonnull
    public SerializationWriterFactory getSerializationWriterFactory() {
        return this.sWriterFactory;
    }

    public void enableBackingStore(@Nullable BackingStoreFactory backingStoreFactory) {
        this.pNodeFactory = Objects.requireNonNull(ApiClientBuilder.enableBackingStoreForParseNodeFactory((ParseNodeFactory)this.pNodeFactory));
        this.sWriterFactory = Objects.requireNonNull(ApiClientBuilder.enableBackingStoreForSerializationWriterFactory((SerializationWriterFactory)this.sWriterFactory));
        if (backingStoreFactory != null) {
            BackingStoreFactorySingleton.instance = backingStoreFactory;
        }
    }

    @Nullable
    public <ModelType extends Parsable> List<ModelType> sendCollection(@Nonnull RequestInformation requestInfo, @Nullable HashMap<String, ParsableFactory<? extends Parsable>> errorMappings, @Nonnull ParsableFactory<ModelType> factory) {
        Objects.requireNonNull(requestInfo, nullRequestInfoParameter);
        Objects.requireNonNull(factory, nullFactoryParameter);
        HttpResponse<InputStream> response = this.getHttpResponseMessage(requestInfo);
        ResponseHandler responseHandler = this.getResponseHandler(requestInfo);
        if (responseHandler == null) {
            this.throwIfFailedResponse(response, errorMappings);
            if (this.shouldReturnNull(response)) {
                return null;
            }
            ParseNode rootNode = this.getRootParseNode(response);
            if (rootNode == null) {
                return null;
            }
            List result = rootNode.getCollectionOfObjectValues(factory);
            return result;
        }
        return (List)responseHandler.handleResponse(response, errorMappings);
    }

    private ResponseHandler getResponseHandler(RequestInformation requestInfo) {
        Collection requestOptions = requestInfo.getRequestOptions();
        for (RequestOption rOption : requestOptions) {
            if (!(rOption instanceof ResponseHandlerOption)) continue;
            ResponseHandlerOption option = (ResponseHandlerOption)rOption;
            return option.getResponseHandler();
        }
        return null;
    }

    @Nullable
    public <ModelType extends Parsable> ModelType send(@Nonnull RequestInformation requestInfo, @Nullable HashMap<String, ParsableFactory<? extends Parsable>> errorMappings, @Nonnull ParsableFactory<ModelType> factory) {
        Objects.requireNonNull(requestInfo, nullRequestInfoParameter);
        Objects.requireNonNull(factory, nullFactoryParameter);
        HttpResponse<InputStream> response = this.getHttpResponseMessage(requestInfo);
        ResponseHandler responseHandler = this.getResponseHandler(requestInfo);
        if (responseHandler == null) {
            this.throwIfFailedResponse(response, errorMappings);
            if (this.shouldReturnNull(response)) {
                return null;
            }
            ParseNode rootNode = this.getRootParseNode(response);
            if (rootNode == null) {
                return null;
            }
            Parsable result = rootNode.getObjectValue(factory);
            return (ModelType)result;
        }
        return (ModelType)((Parsable)responseHandler.handleResponse(response, errorMappings));
    }

    @Nullable
    public <ModelType> ModelType sendPrimitive(@Nonnull RequestInformation requestInfo, @Nullable HashMap<String, ParsableFactory<? extends Parsable>> errorMappings, @Nonnull Class<ModelType> targetClass) {
        Objects.requireNonNull(requestInfo, nullRequestInfoParameter);
        Objects.requireNonNull(targetClass, "parameter targetClass cannot be null");
        HttpResponse<InputStream> response = this.getHttpResponseMessage(requestInfo);
        ResponseHandler responseHandler = this.getResponseHandler(requestInfo);
        if (responseHandler == null) {
            Object result;
            this.throwIfFailedResponse(response, errorMappings);
            if (this.shouldReturnNull(response)) {
                return null;
            }
            if (targetClass == Void.class) {
                return null;
            }
            if (targetClass == InputStream.class) {
                return (ModelType)response.body();
            }
            ParseNode rootNode = this.getRootParseNode(response);
            if (rootNode == null) {
                return null;
            }
            if (targetClass == Boolean.class) {
                result = rootNode.getBooleanValue();
            } else if (targetClass == Byte.class) {
                result = rootNode.getByteValue();
            } else if (targetClass == String.class) {
                result = rootNode.getStringValue();
            } else if (targetClass == Short.class) {
                result = rootNode.getShortValue();
            } else if (targetClass == BigDecimal.class) {
                result = rootNode.getBigDecimalValue();
            } else if (targetClass == Double.class) {
                result = rootNode.getDoubleValue();
            } else if (targetClass == Integer.class) {
                result = rootNode.getIntegerValue();
            } else if (targetClass == Float.class) {
                result = rootNode.getFloatValue();
            } else if (targetClass == Long.class) {
                result = rootNode.getLongValue();
            } else if (targetClass == UUID.class) {
                result = rootNode.getUUIDValue();
            } else if (targetClass == OffsetDateTime.class) {
                result = rootNode.getOffsetDateTimeValue();
            } else if (targetClass == LocalDate.class) {
                result = rootNode.getLocalDateValue();
            } else if (targetClass == LocalTime.class) {
                result = rootNode.getLocalTimeValue();
            } else if (targetClass == PeriodAndDuration.class) {
                result = rootNode.getPeriodAndDurationValue();
            } else if (targetClass == byte[].class) {
                result = rootNode.getByteArrayValue();
            } else {
                throw new RuntimeException("unexpected payload type " + targetClass.getName());
            }
            return (ModelType)result;
        }
        return (ModelType)responseHandler.handleResponse(response, errorMappings);
    }

    @Nullable
    public <ModelType extends Enum<ModelType>> ModelType sendEnum(@Nonnull RequestInformation requestInfo, @Nullable HashMap<String, ParsableFactory<? extends Parsable>> errorMappings, @Nonnull ValuedEnumParser<ModelType> enumParser) {
        Objects.requireNonNull(requestInfo, nullRequestInfoParameter);
        Objects.requireNonNull(enumParser, nullEnumParserParameter);
        HttpResponse<InputStream> response = this.getHttpResponseMessage(requestInfo);
        ResponseHandler responseHandler = this.getResponseHandler(requestInfo);
        if (responseHandler == null) {
            this.throwIfFailedResponse(response, errorMappings);
            if (this.shouldReturnNull(response)) {
                return null;
            }
            ParseNode rootNode = this.getRootParseNode(response);
            if (rootNode == null) {
                return null;
            }
            Enum result = rootNode.getEnumValue(enumParser);
            return (ModelType)result;
        }
        return (ModelType)((Enum)responseHandler.handleResponse(response, errorMappings));
    }

    @Nullable
    public <ModelType extends Enum<ModelType>> List<ModelType> sendEnumCollection(@Nonnull RequestInformation requestInfo, @Nullable HashMap<String, ParsableFactory<? extends Parsable>> errorMappings, @Nonnull ValuedEnumParser<ModelType> enumParser) {
        Objects.requireNonNull(requestInfo, nullRequestInfoParameter);
        Objects.requireNonNull(enumParser, nullEnumParserParameter);
        HttpResponse<InputStream> response = this.getHttpResponseMessage(requestInfo);
        ResponseHandler responseHandler = this.getResponseHandler(requestInfo);
        if (responseHandler == null) {
            this.throwIfFailedResponse(response, errorMappings);
            if (this.shouldReturnNull(response)) {
                return null;
            }
            ParseNode rootNode = this.getRootParseNode(response);
            if (rootNode == null) {
                return null;
            }
            List result = rootNode.getCollectionOfEnumValues(enumParser);
            return result;
        }
        return (List)responseHandler.handleResponse(response, errorMappings);
    }

    @Nullable
    public <ModelType> List<ModelType> sendPrimitiveCollection(@Nonnull RequestInformation requestInfo, @Nullable HashMap<String, ParsableFactory<? extends Parsable>> errorMappings, @Nonnull Class<ModelType> targetClass) {
        Objects.requireNonNull(requestInfo, nullRequestInfoParameter);
        HttpResponse<InputStream> response = this.getHttpResponseMessage(requestInfo);
        ResponseHandler responseHandler = this.getResponseHandler(requestInfo);
        if (responseHandler == null) {
            this.throwIfFailedResponse(response, errorMappings);
            if (this.shouldReturnNull(response)) {
                return null;
            }
            ParseNode rootNode = this.getRootParseNode(response);
            if (rootNode == null) {
                return null;
            }
            List result = rootNode.getCollectionOfPrimitiveValues(targetClass);
            return result;
        }
        return (List)responseHandler.handleResponse(response, errorMappings);
    }

    @Nullable
    private ParseNode getRootParseNode(HttpResponse<InputStream> response) {
        InputStream rawInputStream = response.body();
        if (rawInputStream == null) {
            return null;
        }
        String contentType = response.headers().firstValue(contentTypeHeaderKey).orElse(null);
        if (contentType == null) {
            return null;
        }
        return this.pNodeFactory.getParseNode(contentType, rawInputStream);
    }

    private boolean shouldReturnNull(HttpResponse response) {
        return response.statusCode() == 204;
    }

    private HttpResponse<InputStream> throwIfFailedResponse(@Nonnull HttpResponse response, @Nullable HashMap<String, ParsableFactory<? extends Parsable>> errorMappings) {
        if (response.statusCode() >= 200 && response.statusCode() < 300) {
            return response;
        }
        String statusCodeAsString = Integer.toString(response.statusCode());
        int statusCode = response.statusCode();
        ResponseHeaders responseHeaders = HeadersCompatibility.getResponseHeaders(response.headers());
        if (!(errorMappings != null && (errorMappings.containsKey(statusCodeAsString) || statusCode >= 400 && statusCode < 500 && errorMappings.containsKey("4XX") || statusCode >= 500 && statusCode < 600 && errorMappings.containsKey("5XX")))) {
            ApiException result = new ApiExceptionBuilder().withMessage("the server returned an unexpected status code and no error class is registered for this code " + statusCode).withResponseStatusCode(statusCode).withResponseHeaders(responseHeaders).build();
            throw result;
        }
        ParsableFactory<? extends Parsable> errorClass = errorMappings.containsKey(statusCodeAsString) ? errorMappings.get(statusCodeAsString) : (statusCode >= 400 && statusCode < 500 ? errorMappings.get("4XX") : errorMappings.get("5XX"));
        ParseNode rootNode = this.getRootParseNode(response);
        if (rootNode == null) {
            ApiException result = new ApiExceptionBuilder().withMessage("service returned status code" + statusCode + " but no response body was found").withResponseStatusCode(statusCode).withResponseHeaders(responseHeaders).build();
            throw result;
        }
        ApiException result = new ApiExceptionBuilder(() -> rootNode.getObjectValue(errorClass)).withResponseStatusCode(statusCode).withResponseHeaders(responseHeaders).build();
        throw result;
    }

    private HttpResponse<InputStream> getHttpResponseMessage(@Nonnull RequestInformation requestInfo) {
        Objects.requireNonNull(requestInfo, nullRequestInfoParameter);
        this.setBaseUrlForRequestInformation(requestInfo);
        try {
            return this.client.send(this.convertToNativeRequest(requestInfo), HttpResponse.BodyHandlers.ofInputStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void setBaseUrlForRequestInformation(@Nonnull RequestInformation requestInfo) {
        Objects.requireNonNull(requestInfo);
        requestInfo.pathParameters.put("baseurl", this.getBaseUrl());
    }

    @Nonnull
    public HttpRequest convertToNativeRequest(@Nonnull RequestInformation requestInfo) {
        Objects.requireNonNull(requestInfo, nullRequestInfoParameter);
        return this.getRequestFromRequestInformation(requestInfo);
    }

    @Nonnull
    protected HttpRequest getRequestFromRequestInformation(@Nonnull RequestInformation requestInfo) {
        return HttpRequestCompatibility.convert(requestInfo);
    }
}

