/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.serde;

import io.apicurio.registry.resolver.ParsedSchema;
import io.apicurio.registry.resolver.SchemaLookupResult;
import io.apicurio.registry.resolver.SchemaParser;
import io.apicurio.registry.resolver.SchemaResolver;
import io.apicurio.registry.resolver.client.RegistryClientFacade;
import io.apicurio.registry.resolver.strategy.ArtifactReferenceResolverStrategy;
import io.apicurio.registry.serde.BaseSerde;
import io.apicurio.registry.serde.config.SerdeConfig;
import io.apicurio.registry.serde.data.SerdeMetadata;
import io.apicurio.registry.serde.data.SerdeRecord;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;

public abstract class AbstractSerializer<T, U>
implements AutoCloseable {
    private final BaseSerde<T, U> baseSerde;

    public AbstractSerializer() {
        this.baseSerde = new BaseSerde();
    }

    public AbstractSerializer(RegistryClientFacade clientFacade) {
        this.baseSerde = new BaseSerde(clientFacade);
    }

    public AbstractSerializer(SchemaResolver<T, U> schemaResolver) {
        this.baseSerde = new BaseSerde<T, U>(schemaResolver);
    }

    public AbstractSerializer(RegistryClientFacade clientFacade, SchemaResolver<T, U> schemaResolver) {
        this.baseSerde = new BaseSerde<T, U>(clientFacade, schemaResolver);
    }

    public AbstractSerializer(RegistryClientFacade clientFacade, ArtifactReferenceResolverStrategy<T, U> strategy, SchemaResolver<T, U> schemaResolver) {
        this.baseSerde = new BaseSerde<T, U>(clientFacade, strategy, schemaResolver);
    }

    public abstract SchemaParser<T, U> schemaParser();

    public abstract void serializeData(ParsedSchema<T> var1, U var2, OutputStream var3) throws IOException;

    public void configure(SerdeConfig config, boolean isKey) {
        this.baseSerde.configure(config, isKey, this.schemaParser());
    }

    public byte[] serializeData(String topic, U data) {
        if (data == null) {
            return null;
        }
        try {
            SerdeMetadata resolverMetadata = new SerdeMetadata(topic, this.baseSerde.isKey());
            SchemaLookupResult schema = this.baseSerde.getSchemaResolver().resolveSchema(new SerdeRecord<U>(resolverMetadata, data));
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write(0);
            this.baseSerde.getIdHandler().writeId(schema.toArtifactReference(), out);
            this.serializeData(schema.getParsedSchema(), data, out);
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public BaseSerde<T, U> getSerdeConfigurer() {
        return this.baseSerde;
    }

    @Override
    public void close() {
        this.baseSerde.close();
    }
}

