/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.client.util;

import com.microsoft.kiota.serialization.ParseNode;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

public class DateTimeUtil {
    private static final String DEFAULT_LEGACY_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    private static final String PROPERTY_NAME = "apicurio.apis.date-format";
    private static final String ENV_VAR_NAME = "APICURIO_APIS_DATE_FORMAT";
    private static final DateTimeFormatter LEGACY_FORMATTER = DateTimeUtil.createLegacyFormatter();

    private static DateTimeFormatter createLegacyFormatter() {
        String format = System.getProperty(PROPERTY_NAME);
        if (format == null || format.isEmpty()) {
            format = System.getenv(ENV_VAR_NAME);
        }
        if (format == null || format.isEmpty()) {
            format = System.getenv(PROPERTY_NAME);
        }
        if (format == null || format.isEmpty()) {
            format = DEFAULT_LEGACY_FORMAT;
        }
        return DateTimeFormatter.ofPattern(format);
    }

    public static OffsetDateTime getOffsetDateTimeValue(ParseNode parseNode) {
        if (parseNode == null) {
            return null;
        }
        try {
            return parseNode.getOffsetDateTimeValue();
        }
        catch (DateTimeParseException e) {
            try {
                String dateString = parseNode.getStringValue();
                if (dateString == null) {
                    return null;
                }
                return OffsetDateTime.parse(dateString, LEGACY_FORMATTER);
            }
            catch (DateTimeParseException legacyException) {
                throw e;
            }
        }
    }
}

