/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.serde.avro;

import io.apicurio.registry.serde.avro.AvroDatumProvider;
import io.apicurio.registry.serde.avro.AvroSchemaUtils;
import io.apicurio.registry.serde.avro.AvroSerdeConfig;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.specific.SpecificRecord;

public class DefaultAvroDatumProvider<T>
implements AvroDatumProvider<T> {
    private Boolean useSpecificAvroReader;
    private Map<String, Schema> schemas = new ConcurrentHashMap<String, Schema>();

    public DefaultAvroDatumProvider() {
    }

    public DefaultAvroDatumProvider(boolean useSpecificAvroReader) {
        this.useSpecificAvroReader = useSpecificAvroReader;
    }

    public DefaultAvroDatumProvider<T> setUseSpecificAvroReader(boolean useSpecificAvroReader) {
        this.useSpecificAvroReader = useSpecificAvroReader;
        return this;
    }

    @Override
    public void configure(AvroSerdeConfig config) {
        if (this.useSpecificAvroReader == null) {
            this.useSpecificAvroReader = config.useSpecificAvroReader();
        }
    }

    private Schema getReaderSchema(Schema schema) {
        return this.schemas.computeIfAbsent(schema.getFullName(), k -> {
            Class readerClass = SpecificData.get().getClass(schema);
            if (readerClass != null) {
                try {
                    return ((SpecificRecord)readerClass.getConstructor(new Class[0]).newInstance(new Object[0])).getSchema();
                }
                catch (Exception e) {
                    throw new IllegalStateException(String.format("Error getting schema [%s]: %s", schema.getFullName(), readerClass.getName()), e);
                }
            }
            throw new IllegalArgumentException("Could not find class " + schema.getFullName() + " specified in writer's schema whilst finding reader's schema for a SpecificRecord.");
        });
    }

    @Override
    public DatumWriter<T> createDatumWriter(T data, Schema schema) {
        if (data instanceof SpecificRecord) {
            return new SpecificDatumWriter(schema);
        }
        return new GenericDatumWriter(schema);
    }

    @Override
    public DatumReader<T> createDatumReader(Schema schema) {
        if (this.useSpecificAvroReader != null && this.useSpecificAvroReader.booleanValue() && !AvroSchemaUtils.isPrimitive(schema)) {
            return new SpecificDatumReader(schema, this.getReaderSchema(schema));
        }
        return new GenericDatumReader(schema);
    }

    @Override
    public Schema toSchema(T data) {
        return AvroSchemaUtils.getSchema(data);
    }
}

