/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.serde.avro;

import io.apicurio.registry.resolver.ParsedSchema;
import io.apicurio.registry.resolver.SchemaParser;
import io.apicurio.registry.resolver.SchemaResolver;
import io.apicurio.registry.resolver.client.RegistryClientFacade;
import io.apicurio.registry.resolver.strategy.ArtifactReferenceResolverStrategy;
import io.apicurio.registry.resolver.utils.Utils;
import io.apicurio.registry.serde.AbstractSerializer;
import io.apicurio.registry.serde.avro.AvroDatumProvider;
import io.apicurio.registry.serde.avro.AvroEncoding;
import io.apicurio.registry.serde.avro.AvroSchemaParser;
import io.apicurio.registry.serde.avro.AvroSerdeConfig;
import io.apicurio.registry.serde.avro.NonRecordContainer;
import io.apicurio.registry.serde.config.SerdeConfig;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.avro.Schema;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;

public class AvroSerializer<U>
extends AbstractSerializer<Schema, U> {
    private final EncoderFactory encoderFactory = EncoderFactory.get();
    private AvroSchemaParser<U> parser;
    private AvroDatumProvider<U> avroDatumProvider;
    private AvroEncoding encoding;

    public AvroSerializer() {
    }

    public AvroSerializer(RegistryClientFacade clientFacade) {
        super(clientFacade);
    }

    public AvroSerializer(SchemaResolver<Schema, U> schemaResolver) {
        super(schemaResolver);
    }

    public AvroSerializer(RegistryClientFacade clientFacade, SchemaResolver<Schema, U> schemaResolver) {
        super(clientFacade, schemaResolver);
    }

    public AvroSerializer(RegistryClientFacade clientFacade, ArtifactReferenceResolverStrategy<Schema, U> artifactResolverStrategy, SchemaResolver<Schema, U> schemaResolver) {
        super(clientFacade, artifactResolverStrategy, schemaResolver);
    }

    private AvroSerializer<U> setAvroDatumProvider(AvroDatumProvider<U> avroDatumProvider) {
        this.avroDatumProvider = Objects.requireNonNull(avroDatumProvider);
        return this;
    }

    public void setEncoding(AvroEncoding encoding) {
        this.encoding = encoding;
    }

    public AvroEncoding getEncoding() {
        return this.encoding;
    }

    public void configure(SerdeConfig configs, boolean isKey) {
        AvroSerdeConfig config = new AvroSerdeConfig(configs.originals());
        this.encoding = config.getAvroEncoding();
        Class<?> adp = config.getAvroDatumProvider();
        Consumer<AvroDatumProvider> consumer = this::setAvroDatumProvider;
        Utils.instantiate(AvroDatumProvider.class, adp, consumer);
        this.avroDatumProvider.configure(config);
        this.parser = new AvroSchemaParser<U>(this.avroDatumProvider);
        super.configure((SerdeConfig)config, isKey);
    }

    public SchemaParser<Schema, U> schemaParser() {
        return this.parser;
    }

    public void serializeData(ParsedSchema<Schema> schema, U data, OutputStream out) throws IOException {
        Encoder encoder = this.createEncoder((Schema)schema.getParsedSchema(), out);
        if (data instanceof NonRecordContainer) {
            data = ((NonRecordContainer)NonRecordContainer.class.cast(data)).getValue();
        }
        DatumWriter<U> writer = this.avroDatumProvider.createDatumWriter(data, (Schema)schema.getParsedSchema());
        writer.write(data, encoder);
        encoder.flush();
    }

    private Encoder createEncoder(Schema schema, OutputStream os) throws IOException {
        if (this.encoding == AvroEncoding.JSON) {
            return this.encoderFactory.jsonEncoder(schema, os);
        }
        return this.encoderFactory.directBinaryEncoder(os, null);
    }
}

