/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.serde;

import io.apicurio.registry.resolver.strategy.ArtifactReference;
import io.apicurio.registry.serde.IdHandler;
import io.apicurio.registry.serde.config.IdOption;
import io.apicurio.registry.serde.config.SerdeConfig;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Map;

public class Legacy8ByteIdHandler
implements IdHandler {
    static final int idSize = 8;
    private IdOption idOption = IdOption.globalId;

    @Override
    public void configure(Map<String, Object> configs, boolean isKey) {
        SerdeConfig config = new SerdeConfig(configs);
        this.idOption = config.useIdOption();
    }

    @Override
    public void writeId(ArtifactReference reference, OutputStream out) throws IOException {
        long id;
        if (this.idOption == IdOption.globalId) {
            if (reference.getGlobalId() == null) {
                throw new IllegalStateException("Missing globalId. IdOption is globalId but there is no contentId in the ArtifactReference");
            }
            id = reference.getGlobalId();
        } else {
            id = reference.getContentId();
        }
        out.write(ByteBuffer.allocate(8).putLong(id).array());
    }

    @Override
    public void writeId(ArtifactReference reference, ByteBuffer buffer) {
        long id;
        if (this.idOption == IdOption.globalId) {
            if (reference.getGlobalId() == null) {
                throw new IllegalStateException("Missing globalId. IdOption is globalId but there is no globalId in the ArtifactReference");
            }
            id = reference.getGlobalId();
        } else {
            id = reference.getContentId();
        }
        buffer.putLong(id);
    }

    @Override
    public ArtifactReference readId(ByteBuffer buffer) {
        if (this.idOption == IdOption.globalId) {
            return ArtifactReference.builder().globalId(Long.valueOf(buffer.getLong())).build();
        }
        return ArtifactReference.builder().contentId(Long.valueOf(buffer.getLong())).build();
    }

    @Override
    public int idSize() {
        return 8;
    }
}

