/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class IoUtil {
    public static void unpackToDisk(ZipInputStream zip, Path outputDirectory) throws IOException {
        ZipEntry entry = zip.getNextEntry();
        while (entry != null) {
            Path entryPath = IoUtil.zipPath(entry, outputDirectory);
            if (entry.isDirectory()) {
                Files.createDirectories(entryPath, new FileAttribute[0]);
            } else {
                Path parentPath = entryPath.getParent();
                if (parentPath != null && Files.notExists(parentPath, new LinkOption[0])) {
                    Files.createDirectories(parentPath, new FileAttribute[0]);
                }
                Files.copy(zip, entryPath, StandardCopyOption.REPLACE_EXISTING);
            }
            zip.closeEntry();
            entry = zip.getNextEntry();
        }
    }

    private static Path zipPath(ZipEntry entry, Path targetDir) throws IOException {
        Path targetDirResolved = targetDir.resolve(entry.getName());
        Path normalizedPath = targetDirResolved.normalize();
        if (!normalizedPath.startsWith(targetDir)) {
            throw new IOException("Invalid ZIP entry: " + entry.getName());
        }
        return normalizedPath;
    }

    private static ByteArrayOutputStream toBaos(InputStream stream) throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        IoUtil.copy(stream, result);
        return result;
    }

    public static void close(AutoCloseable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static void closeIgnore(AutoCloseable closeable) {
        try {
            IoUtil.close(closeable);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static byte[] toBytes(InputStream stream) {
        try {
            byte[] byArray = IoUtil.toBaos(stream).toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            IoUtil.close(stream);
        }
    }

    public static byte[] toBytes(InputStream stream, boolean closeStream) {
        try {
            byte[] byArray = IoUtil.toBaos(stream).toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            if (closeStream) {
                IoUtil.close(stream);
            }
        }
    }

    public static byte[] toBytes(File file) {
        byte[] byArray;
        FileInputStream stream = new FileInputStream(file);
        try {
            byArray = IoUtil.toBaos(stream).toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        stream.close();
        return byArray;
    }

    public static String toString(File file) {
        String string;
        FileInputStream stream = new FileInputStream(file);
        try {
            string = IoUtil.toString(stream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        stream.close();
        return string;
    }

    public static String toString(InputStream stream) {
        try {
            String string = IoUtil.toBaos(stream).toString(StandardCharsets.UTF_8.name());
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            IoUtil.close(stream);
        }
    }

    public static String toString(byte[] bytes) {
        return bytes == null ? null : new String(bytes, StandardCharsets.UTF_8);
    }

    public static byte[] toBytes(String string) {
        return string == null ? null : string.getBytes(StandardCharsets.UTF_8);
    }

    public static InputStream toStream(String content) {
        return new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));
    }

    public static InputStream toStream(byte[] content) {
        return new ByteArrayInputStream(content);
    }

    public static long copy(InputStream input, OutputStream output) throws IOException {
        int n;
        byte[] buffer = new byte[8192];
        long count = 0L;
        while ((n = input.read(buffer)) != -1) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }
}

