/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.model;

import jakarta.validation.ValidationException;
import java.util.regex.Pattern;
import lombok.Generated;

public class GroupId {
    private static final Pattern VALID_PATTERN = Pattern.compile(".{1,512}");
    private static final String DEFAULT_STRING = "default";
    private static final String DEFAULT_RAW_GROUP_ID = "__$GROUPID$__";
    public static final GroupId DEFAULT = new GroupId("__$GROUPID$__");
    private final String rawGroupId;

    public GroupId(String rawGroupId) {
        if (!GroupId.isValid(rawGroupId)) {
            throw new ValidationException("Group ID '" + rawGroupId + "' is invalid. It must have length 1..512 (inclusive).");
        }
        this.rawGroupId = rawGroupId == null || DEFAULT_STRING.equalsIgnoreCase(rawGroupId) ? DEFAULT_RAW_GROUP_ID : rawGroupId;
    }

    public boolean isDefaultGroup() {
        return DEFAULT.getRawGroupId().equals(this.rawGroupId);
    }

    public String getRawGroupIdWithDefaultString() {
        return this.isDefaultGroup() ? DEFAULT_STRING : this.rawGroupId;
    }

    public String getRawGroupIdWithNull() {
        return this.isDefaultGroup() ? null : this.rawGroupId;
    }

    public String toString() {
        return this.getRawGroupIdWithDefaultString();
    }

    public static boolean isValid(String rawGroupId) {
        return rawGroupId == null || VALID_PATTERN.matcher(rawGroupId).matches();
    }

    @Generated
    public String getRawGroupId() {
        return this.rawGroupId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GroupId)) {
            return false;
        }
        GroupId other = (GroupId)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$rawGroupId = this.getRawGroupId();
        String other$rawGroupId = other.getRawGroupId();
        return !(this$rawGroupId == null ? other$rawGroupId != null : !this$rawGroupId.equals(other$rawGroupId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GroupId;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $rawGroupId = this.getRawGroupId();
        result = result * 59 + ($rawGroupId == null ? 43 : $rawGroupId.hashCode());
        return result;
    }
}

