/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest.client.v2.groups.item.artifacts.item.test;

import com.microsoft.kiota.BaseRequestBuilder;
import com.microsoft.kiota.BaseRequestConfiguration;
import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.serialization.ParsableFactory;
import io.apicurio.registry.rest.client.v2.models.Error;
import io.apicurio.registry.rest.client.v2.models.RuleViolationError;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class TestRequestBuilder
extends BaseRequestBuilder {
    public TestRequestBuilder(@Nonnull HashMap<String, Object> pathParameters, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/groups/{groupId}/artifacts/{artifactId}/test", pathParameters);
    }

    public TestRequestBuilder(@Nonnull String rawUrl, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/groups/{groupId}/artifacts/{artifactId}/test", rawUrl);
    }

    public void put(@Nonnull InputStream body, @Nonnull String contentType) {
        this.put(body, contentType, null);
    }

    public void put(@Nonnull InputStream body, @Nonnull String contentType, @Nullable Consumer<PutRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        Objects.requireNonNull(contentType);
        RequestInformation requestInfo = this.toPutRequestInformation(body, contentType, requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("404", Error::createFromDiscriminatorValue);
        errorMapping.put("409", RuleViolationError::createFromDiscriminatorValue);
        errorMapping.put("500", Error::createFromDiscriminatorValue);
        this.requestAdapter.sendPrimitive(requestInfo, errorMapping, Void.class);
    }

    @Nonnull
    public RequestInformation toPutRequestInformation(@Nonnull InputStream body, @Nonnull String contentType) {
        return this.toPutRequestInformation(body, contentType, null);
    }

    @Nonnull
    public RequestInformation toPutRequestInformation(@Nonnull InputStream body, @Nonnull String contentType, @Nullable Consumer<PutRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        Objects.requireNonNull(contentType);
        RequestInformation requestInfo = new RequestInformation(HttpMethod.PUT, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new PutRequestConfiguration());
        requestInfo.headers.tryAdd("Accept", "application/json");
        requestInfo.setStreamContent(body, contentType);
        return requestInfo;
    }

    @Nonnull
    public TestRequestBuilder withUrl(@Nonnull String rawUrl) {
        Objects.requireNonNull(rawUrl);
        return new TestRequestBuilder(rawUrl, this.requestAdapter);
    }

    public class PutRequestConfiguration
    extends BaseRequestConfiguration {
    }
}

