/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest.client.v2.groups.item.artifacts.item;

import com.microsoft.kiota.BaseRequestBuilder;
import com.microsoft.kiota.BaseRequestConfiguration;
import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.QueryParameters;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import io.apicurio.registry.rest.client.v2.groups.item.artifacts.item.meta.MetaRequestBuilder;
import io.apicurio.registry.rest.client.v2.groups.item.artifacts.item.owner.OwnerRequestBuilder;
import io.apicurio.registry.rest.client.v2.groups.item.artifacts.item.rules.RulesRequestBuilder;
import io.apicurio.registry.rest.client.v2.groups.item.artifacts.item.state.StateRequestBuilder;
import io.apicurio.registry.rest.client.v2.groups.item.artifacts.item.test.TestRequestBuilder;
import io.apicurio.registry.rest.client.v2.groups.item.artifacts.item.versions.VersionsRequestBuilder;
import io.apicurio.registry.rest.client.v2.models.ArtifactContent;
import io.apicurio.registry.rest.client.v2.models.ArtifactMetaData;
import io.apicurio.registry.rest.client.v2.models.Error;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class WithArtifactItemRequestBuilder
extends BaseRequestBuilder {
    @Nonnull
    public MetaRequestBuilder meta() {
        return new MetaRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public OwnerRequestBuilder owner() {
        return new OwnerRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public RulesRequestBuilder rules() {
        return new RulesRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public StateRequestBuilder state() {
        return new StateRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public TestRequestBuilder test() {
        return new TestRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public VersionsRequestBuilder versions() {
        return new VersionsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    public WithArtifactItemRequestBuilder(@Nonnull HashMap<String, Object> pathParameters, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/groups/{groupId}/artifacts/{artifactId}{?dereference*}", pathParameters);
    }

    public WithArtifactItemRequestBuilder(@Nonnull String rawUrl, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/groups/{groupId}/artifacts/{artifactId}{?dereference*}", rawUrl);
    }

    public void delete() {
        this.delete(null);
    }

    public void delete(@Nullable Consumer<DeleteRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = this.toDeleteRequestInformation(requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("404", Error::createFromDiscriminatorValue);
        errorMapping.put("500", Error::createFromDiscriminatorValue);
        this.requestAdapter.sendPrimitive(requestInfo, errorMapping, Void.class);
    }

    @Nullable
    public InputStream get() {
        return this.get(null);
    }

    @Nullable
    public InputStream get(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = this.toGetRequestInformation(requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("404", Error::createFromDiscriminatorValue);
        errorMapping.put("500", Error::createFromDiscriminatorValue);
        return (InputStream)this.requestAdapter.sendPrimitive(requestInfo, errorMapping, InputStream.class);
    }

    @Nullable
    public ArtifactMetaData put(@Nonnull ArtifactContent body) {
        return this.put(body, null);
    }

    @Nullable
    public ArtifactMetaData put(@Nonnull ArtifactContent body, @Nullable Consumer<PutRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = this.toPutRequestInformation(body, requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("404", Error::createFromDiscriminatorValue);
        errorMapping.put("409", Error::createFromDiscriminatorValue);
        errorMapping.put("500", Error::createFromDiscriminatorValue);
        return (ArtifactMetaData)this.requestAdapter.send(requestInfo, errorMapping, ArtifactMetaData::createFromDiscriminatorValue);
    }

    @Nonnull
    public RequestInformation toDeleteRequestInformation() {
        return this.toDeleteRequestInformation(null);
    }

    @Nonnull
    public RequestInformation toDeleteRequestInformation(@Nullable Consumer<DeleteRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = new RequestInformation(HttpMethod.DELETE, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new DeleteRequestConfiguration());
        requestInfo.headers.tryAdd("Accept", "application/json");
        return requestInfo;
    }

    @Nonnull
    public RequestInformation toGetRequestInformation() {
        return this.toGetRequestInformation(null);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = new RequestInformation(HttpMethod.GET, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new GetRequestConfiguration(), x -> x.queryParameters);
        requestInfo.headers.tryAdd("Accept", "*/*, application/json");
        return requestInfo;
    }

    @Nonnull
    public RequestInformation toPutRequestInformation(@Nonnull ArtifactContent body) {
        return this.toPutRequestInformation(body, null);
    }

    @Nonnull
    public RequestInformation toPutRequestInformation(@Nonnull ArtifactContent body, @Nullable Consumer<PutRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = new RequestInformation(HttpMethod.PUT, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new PutRequestConfiguration());
        requestInfo.headers.tryAdd("Accept", "application/json");
        requestInfo.setContentFromParsable(this.requestAdapter, "application/vnd.create.extended+json", (Parsable)body);
        return requestInfo;
    }

    @Nonnull
    public WithArtifactItemRequestBuilder withUrl(@Nonnull String rawUrl) {
        Objects.requireNonNull(rawUrl);
        return new WithArtifactItemRequestBuilder(rawUrl, this.requestAdapter);
    }

    public class PutRequestConfiguration
    extends BaseRequestConfiguration {
    }

    public class GetRequestConfiguration
    extends BaseRequestConfiguration {
        @Nullable
        public GetQueryParameters queryParameters;

        public GetRequestConfiguration() {
            this.queryParameters = new GetQueryParameters();
        }
    }

    public class GetQueryParameters
    implements QueryParameters {
        @Nullable
        public Boolean dereference;

        @Nonnull
        public Map<String, Object> toQueryParameters() {
            HashMap<String, Object> allQueryParams = new HashMap<String, Object>();
            allQueryParams.put("dereference", this.dereference);
            return allQueryParams;
        }
    }

    public class DeleteRequestConfiguration
    extends BaseRequestConfiguration {
    }
}

