/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.resolver.config;

import io.apicurio.registry.resolver.config.AbstractConfig;
import io.apicurio.registry.resolver.strategy.DynamicArtifactReferenceResolverStrategy;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;

public class SchemaResolverConfig
extends AbstractConfig {
    public static final String ARTIFACT_RESOLVER_STRATEGY = "apicurio.registry.artifact-resolver-strategy";
    public static final String ARTIFACT_RESOLVER_STRATEGY_DEFAULT = DynamicArtifactReferenceResolverStrategy.class.getName();
    public static final String AUTO_REGISTER_ARTIFACT = "apicurio.registry.auto-register";
    public static final boolean AUTO_REGISTER_ARTIFACT_DEFAULT = false;
    public static final String AUTO_REGISTER_ARTIFACT_IF_EXISTS = "apicurio.registry.auto-register.if-exists";
    public static final String AUTO_REGISTER_ARTIFACT_IF_EXISTS_DEFAULT = "FIND_OR_CREATE_VERSION";
    public static final String FIND_LATEST_ARTIFACT = "apicurio.registry.find-latest";
    public static final boolean FIND_LATEST_ARTIFACT_DEFAULT = false;
    public static final String CACHE_LATEST = "apicurio.registry.cache-latest";
    public static final boolean CACHE_LATEST_DEFAULT = true;
    public static final String FAULT_TOLERANT_REFRESH = "apicurio.registry.fault-tolerant-refresh";
    public static final boolean FAULT_TOLERANT_REFRESH_DEFAULT = false;
    public static final String EXPLICIT_ARTIFACT_GROUP_ID = "apicurio.registry.artifact.group-id";
    public static final String EXPLICIT_ARTIFACT_ID = "apicurio.registry.artifact.artifact-id";
    public static final String SCHEMA_LOCATION = "apicurio.registry.artifact.schema.location";
    public static final String EXPLICIT_ARTIFACT_VERSION = "apicurio.registry.artifact.version";
    public static final String REGISTRY_URL = "apicurio.registry.url";
    public static final String REGISTRY_URL_VERSION = "apicurio.registry.url.version";
    public static final String AUTH_TOKEN_ENDPOINT = "apicurio.registry.auth.service.token.endpoint";
    public static final String AUTH_CLIENT_ID = "apicurio.registry.auth.client.id";
    public static final String AUTH_CLIENT_SECRET = "apicurio.registry.auth.client.secret";
    public static final String AUTH_CLIENT_SCOPE = "apicurio.registry.auth.client.scope";
    public static final String AUTH_USERNAME = "apicurio.registry.auth.username";
    public static final String AUTH_PASSWORD = "apicurio.registry.auth.password";
    public static final String CHECK_PERIOD_MS = "apicurio.registry.check-period-ms";
    public static final long CHECK_PERIOD_MS_DEFAULT = 30000L;
    public static final String RETRY_COUNT = "apicurio.registry.retry-count";
    public static final long RETRY_COUNT_DEFAULT = 3L;
    public static final String RETRY_BACKOFF_MS = "apicurio.registry.retry-backoff-ms";
    public static final long RETRY_BACKOFF_MS_DEFAULT = 300L;
    public static final String DEREFERENCE_SCHEMA = "apicurio.registry.dereference-schema";
    public static final boolean DEREFERENCE_DEFAULT = false;
    public static final String CANONICALIZE = "apicurio.registry.canonicalize";
    public static final boolean CANONICALIZE_DEFAULT = false;
    public static final String TLS_TRUSTSTORE_LOCATION = "apicurio.registry.tls.truststore.location";
    public static final String TLS_TRUSTSTORE_PASSWORD = "apicurio.registry.tls.truststore.password";
    public static final String TLS_TRUSTSTORE_TYPE = "apicurio.registry.tls.truststore.type";
    public static final String TLS_TRUSTSTORE_TYPE_DEFAULT = "JKS";
    public static final String TLS_CERTIFICATES = "apicurio.registry.tls.certificates";
    public static final String TLS_TRUST_ALL = "apicurio.registry.tls.trust-all";
    public static final boolean TLS_TRUST_ALL_DEFAULT = false;
    public static final String TLS_VERIFY_HOST = "apicurio.registry.tls.verify-host";
    public static final boolean TLS_VERIFY_HOST_DEFAULT = true;
    public static final String PROXY_HOST = "apicurio.registry.proxy.host";
    public static final String PROXY_PORT = "apicurio.registry.proxy.port";
    public static final String PROXY_USERNAME = "apicurio.registry.proxy.username";
    public static final String PROXY_PASSWORD = "apicurio.registry.proxy.password";
    private static final Map<String, Object> DEFAULTS = Map.ofEntries(Map.entry("apicurio.registry.canonicalize", false), Map.entry("apicurio.registry.artifact-resolver-strategy", ARTIFACT_RESOLVER_STRATEGY_DEFAULT), Map.entry("apicurio.registry.auto-register", false), Map.entry("apicurio.registry.auto-register.if-exists", "FIND_OR_CREATE_VERSION"), Map.entry("apicurio.registry.cache-latest", true), Map.entry("apicurio.registry.fault-tolerant-refresh", false), Map.entry("apicurio.registry.find-latest", false), Map.entry("apicurio.registry.check-period-ms", 30000L), Map.entry("apicurio.registry.retry-count", 3L), Map.entry("apicurio.registry.retry-backoff-ms", 300L), Map.entry("apicurio.registry.dereference-schema", false), Map.entry("apicurio.registry.tls.truststore.type", "JKS"), Map.entry("apicurio.registry.tls.trust-all", false), Map.entry("apicurio.registry.tls.verify-host", true));

    public SchemaResolverConfig() {
        this.originals = DEFAULTS;
    }

    public SchemaResolverConfig(Map<String, ?> originals) {
        HashMap joint = new HashMap(this.getDefaults());
        joint.putAll(originals);
        this.originals = joint;
    }

    public String getRegistryUrl() {
        String registryUrl = this.getString(REGISTRY_URL);
        if (registryUrl != null) {
            try {
                String[] credentials;
                URI uri = new URI(registryUrl);
                String userInfo = uri.getUserInfo();
                if (userInfo != null && (credentials = userInfo.split(":", 2)).length == 2) {
                    this.originals.put(AUTH_USERNAME, credentials[0]);
                    this.originals.put(AUTH_PASSWORD, credentials[1]);
                }
                return new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment()).toString();
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Invalid registry URL: " + registryUrl, e);
            }
        }
        return registryUrl;
    }

    public String getRegistryUrlVersion() {
        return this.getString(REGISTRY_URL_VERSION);
    }

    public String getTokenEndpoint() {
        return this.getString(AUTH_TOKEN_ENDPOINT);
    }

    public String getAuthClientId() {
        return this.getString(AUTH_CLIENT_ID);
    }

    public String getAuthClientSecret() {
        return this.getString(AUTH_CLIENT_SECRET);
    }

    public String getAuthClientScope() {
        return this.getString(AUTH_CLIENT_SCOPE);
    }

    public String getAuthUsername() {
        return this.getString(AUTH_USERNAME);
    }

    public String getAuthPassword() {
        return this.getString(AUTH_PASSWORD);
    }

    public Object getArtifactResolverStrategy() {
        return this.getObject(ARTIFACT_RESOLVER_STRATEGY);
    }

    public boolean autoRegisterArtifact() {
        return this.getBoolean(AUTO_REGISTER_ARTIFACT);
    }

    public String autoRegisterArtifactIfExists() {
        return this.getStringOneOf(AUTO_REGISTER_ARTIFACT_IF_EXISTS, "FAIL", "CREATE_VERSION", AUTO_REGISTER_ARTIFACT_IF_EXISTS_DEFAULT);
    }

    public boolean getCacheLatest() {
        return this.getBoolean(CACHE_LATEST);
    }

    public boolean getFaultTolerantRefresh() {
        return this.getBoolean(FAULT_TOLERANT_REFRESH);
    }

    public boolean findLatest() {
        return this.getBoolean(FIND_LATEST_ARTIFACT);
    }

    public Duration getCheckPeriod() {
        return this.getDurationNonNegativeMillis(CHECK_PERIOD_MS);
    }

    public long getRetryCount() {
        return this.getLongNonNegative(RETRY_COUNT);
    }

    public Duration getRetryBackoff() {
        return this.getDurationNonNegativeMillis(RETRY_BACKOFF_MS);
    }

    public String getExplicitArtifactGroupId() {
        return this.getString(EXPLICIT_ARTIFACT_GROUP_ID);
    }

    public String getExplicitArtifactId() {
        return this.getString(EXPLICIT_ARTIFACT_ID);
    }

    public String getExplicitSchemaLocation() {
        return this.getString(SCHEMA_LOCATION);
    }

    public String getExplicitArtifactVersion() {
        return this.getString(EXPLICIT_ARTIFACT_VERSION);
    }

    public boolean resolveDereferenced() {
        return this.getBooleanOrFalse(DEREFERENCE_SCHEMA);
    }

    public boolean isCanonicalize() {
        return this.getBooleanOrFalse(CANONICALIZE);
    }

    public String getTlsTruststoreLocation() {
        return this.getString(TLS_TRUSTSTORE_LOCATION);
    }

    public String getTlsTruststorePassword() {
        return this.getString(TLS_TRUSTSTORE_PASSWORD);
    }

    public String getTlsTruststoreType() {
        return this.getString(TLS_TRUSTSTORE_TYPE);
    }

    public String getTlsCertificates() {
        return this.getString(TLS_CERTIFICATES);
    }

    public boolean getTlsTrustAll() {
        return this.getBooleanOrFalse(TLS_TRUST_ALL);
    }

    public boolean getTlsVerifyHost() {
        return this.getBoolean(TLS_VERIFY_HOST);
    }

    public String getProxyHost() {
        return this.getString(PROXY_HOST);
    }

    public Integer getProxyPort() {
        Object value = this.getObject(PROXY_PORT);
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid proxy port value: " + String.valueOf(value), e);
            }
        }
        throw new IllegalArgumentException("Proxy port must be a number, got: " + value.getClass().getName());
    }

    public String getProxyUsername() {
        return this.getString(PROXY_USERNAME);
    }

    public String getProxyPassword() {
        return this.getString(PROXY_PASSWORD);
    }

    @Override
    protected Map<String, ?> getDefaults() {
        return DEFAULTS;
    }
}

