/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.resolver.cache;

import com.microsoft.kiota.ApiException;
import io.apicurio.registry.resolver.cache.ContentWithReferences;
import io.apicurio.registry.resolver.strategy.ArtifactCoordinates;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;

public class ERCache<V> {
    private final Map<Long, WrappedValue<V>> globalIdIndex = new ConcurrentHashMap<Long, WrappedValue<V>>();
    private final Map<ContentWithReferences, WrappedValue<V>> contentIndex = new ConcurrentHashMap<ContentWithReferences, WrappedValue<V>>();
    private final Map<Long, WrappedValue<V>> contentIdIndex = new ConcurrentHashMap<Long, WrappedValue<V>>();
    private final Map<ArtifactCoordinates, WrappedValue<V>> gavIndex = new ConcurrentHashMap<ArtifactCoordinates, WrappedValue<V>>();
    private final Map<String, WrappedValue<V>> contentHashIndex = new ConcurrentHashMap<String, WrappedValue<V>>();
    private Function<V, Long> globalIdExtractor;
    private Function<V, ContentWithReferences> contentExtractor;
    private Function<V, Long> contentIdExtractor;
    private Function<V, ArtifactCoordinates> gavExtractor;
    private Function<V, String> contentHashExtractor;
    private Duration lifetime = Duration.ZERO;
    private Duration backoff = Duration.ofMillis(200L);
    private long retries;
    private boolean cacheLatest;
    private boolean faultTolerantRefresh;

    public void configureLifetime(Duration lifetime) {
        this.lifetime = lifetime;
    }

    public void configureRetryBackoff(Duration backoff) {
        this.backoff = backoff;
    }

    public void configureRetryCount(long retries) {
        this.retries = retries;
    }

    public void configureCacheLatest(boolean cacheLatest) {
        this.cacheLatest = cacheLatest;
    }

    public void configureFaultTolerantRefresh(boolean faultTolerantRefresh) {
        this.faultTolerantRefresh = faultTolerantRefresh;
    }

    public void configureGlobalIdKeyExtractor(Function<V, Long> keyExtractor) {
        this.globalIdExtractor = keyExtractor;
    }

    public void configureContentKeyExtractor(Function<V, ContentWithReferences> keyExtractor) {
        this.contentExtractor = keyExtractor;
    }

    public void configureContentIdKeyExtractor(Function<V, Long> keyExtractor) {
        this.contentIdExtractor = keyExtractor;
    }

    public void configureArtifactCoordinatesKeyExtractor(Function<V, ArtifactCoordinates> keyExtractor) {
        this.gavExtractor = keyExtractor;
    }

    public void configureContentHashKeyExtractor(Function<V, String> keyExtractor) {
        this.contentHashExtractor = keyExtractor;
    }

    public boolean isCacheLatest() {
        return this.cacheLatest;
    }

    public boolean isFaultTolerantRefresh() {
        return this.faultTolerantRefresh;
    }

    public void checkInitialized() {
        boolean initialized = this.globalIdExtractor != null && this.contentExtractor != null && this.contentIdExtractor != null && this.gavExtractor != null && this.contentHashExtractor != null;
        boolean bl = initialized = initialized && this.lifetime != null && this.backoff != null && this.retries >= 0L;
        if (!initialized) {
            throw new IllegalStateException("Not properly initialized!");
        }
    }

    public boolean containsByGlobalId(Long key) {
        WrappedValue<V> value = this.globalIdIndex.get(key);
        return value != null && !value.isExpired();
    }

    public boolean containsByContentId(Long key) {
        WrappedValue<V> value = this.contentIdIndex.get(key);
        return value != null && !value.isExpired();
    }

    public boolean containsByArtifactCoordinates(ArtifactCoordinates key) {
        WrappedValue<V> value = this.gavIndex.get(key);
        return value != null && !value.isExpired();
    }

    public boolean containsByContentHash(String key) {
        WrappedValue<V> value = this.contentHashIndex.get(key);
        return value != null && !value.isExpired();
    }

    public V getByGlobalId(Long key, Function<Long, V> loaderFunction) {
        WrappedValue<V> value = this.globalIdIndex.get(key);
        return this.getValue(value, key, loaderFunction);
    }

    public V getByContent(ContentWithReferences key, Function<ContentWithReferences, V> loaderFunction) {
        WrappedValue<V> value = this.contentIndex.get(key);
        return this.getValue(value, key, loaderFunction);
    }

    public V getByContentId(Long key, Function<Long, V> loaderFunction) {
        WrappedValue<V> value = this.contentIdIndex.get(key);
        return this.getValue(value, key, loaderFunction);
    }

    public V getByArtifactCoordinates(ArtifactCoordinates key, Function<ArtifactCoordinates, V> loaderFunction) {
        WrappedValue<V> value = this.gavIndex.get(key);
        return this.getValue(value, key, loaderFunction);
    }

    public V getByContentHash(String key, Function<String, V> loaderFunction) {
        WrappedValue<V> value = this.contentHashIndex.get(key);
        return this.getValue(value, key, loaderFunction);
    }

    private <T> V getValue(WrappedValue<V> value, T key, Function<T, V> loaderFunction) {
        V result;
        V v = result = value != null ? (V)value.value : null;
        if (value == null || value.isExpired()) {
            Result<Object, RuntimeException> newValue = ERCache.retry(this.backoff, this.retries, () -> loaderFunction.apply(key));
            if (newValue.isOk()) {
                this.reindex(new WrappedValue(this.lifetime, Instant.now(), newValue.ok), key);
                result = (V)newValue.ok;
            } else {
                if (this.faultTolerantRefresh && value != null) {
                    return value.value;
                }
                throw (RuntimeException)newValue.error;
            }
        }
        return result;
    }

    private <T> void reindex(WrappedValue<V> newValue, T lookupKey) {
        Optional.ofNullable(this.globalIdExtractor.apply(newValue.value)).ifPresent(k -> this.globalIdIndex.put((Long)k, (WrappedValue<WrappedValue>)newValue));
        Optional.ofNullable(this.contentExtractor.apply(newValue.value)).ifPresent(k -> this.contentIndex.put((ContentWithReferences)k, (WrappedValue<WrappedValue>)newValue));
        Optional.ofNullable(this.contentIdExtractor.apply(newValue.value)).ifPresent(k -> this.contentIdIndex.put((Long)k, (WrappedValue<WrappedValue>)newValue));
        Optional.ofNullable(this.gavExtractor.apply(newValue.value)).ifPresent(k -> {
            this.gavIndex.put((ArtifactCoordinates)k, (WrappedValue<WrappedValue>)newValue);
            if (this.cacheLatest && k.getClass().equals(lookupKey.getClass())) {
                this.gavIndex.put((ArtifactCoordinates)lookupKey, newValue);
            }
        });
        Optional.ofNullable(this.contentHashExtractor.apply(newValue.value)).ifPresent(k -> this.contentHashIndex.put((String)k, (WrappedValue<WrappedValue>)newValue));
    }

    public void clear() {
        this.globalIdIndex.clear();
        this.contentIndex.clear();
        this.contentIdIndex.clear();
        this.gavIndex.clear();
        this.contentHashIndex.clear();
    }

    private static <T> Result<T, RuntimeException> retry(Duration backoff, long retries, Supplier<T> supplier) {
        if (retries < 0L) {
            throw new IllegalArgumentException();
        }
        Objects.requireNonNull(supplier);
        Objects.requireNonNull(backoff);
        for (long i = 0L; i <= retries; ++i) {
            try {
                T value = supplier.get();
                if (value != null) {
                    return Result.ok(value);
                }
                return Result.error(new NullPointerException("Could not retrieve schema for the cache. Loading function returned null."));
            }
            catch (RuntimeException e) {
                if (i == retries || e.getCause() == null || !(e.getCause() instanceof ApiException) || ((ApiException)e.getCause()).getResponseStatusCode() != 429) {
                    e.printStackTrace();
                    return Result.error(new RuntimeException(e));
                }
                try {
                    Thread.sleep(backoff.toMillis());
                }
                catch (InterruptedException e2) {
                    e2.printStackTrace();
                }
                continue;
            }
        }
        return Result.error(new IllegalStateException("Unreachable."));
    }

    private static class WrappedValue<V> {
        private final Duration lifetime;
        private final Instant lastUpdate;
        private final V value;

        public WrappedValue(Duration lifetime, Instant lastUpdate, V value) {
            this.lifetime = lifetime;
            this.lastUpdate = lastUpdate;
            this.value = value;
        }

        public V getValue() {
            return this.value;
        }

        public boolean isExpired() {
            return this.lastUpdate.plus(this.lifetime).isBefore(Instant.now());
        }
    }

    public static class Result<T, E extends Exception> {
        public final T ok;
        public final E error;

        public static <T, E extends Exception> Result<T, E> ok(T ok) {
            Objects.requireNonNull(ok);
            return new Result<T, Object>(ok, null);
        }

        public static <T, E extends Exception> Result<T, E> error(E error) {
            Objects.requireNonNull(error);
            return new Result<Object, E>(null, error);
        }

        private Result(T ok, E error) {
            this.ok = ok;
            this.error = error;
        }

        public boolean isOk() {
            return this.ok != null;
        }

        public boolean isError() {
            return this.error != null;
        }
    }
}

