/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.resolver;

import io.apicurio.registry.resolver.AbstractSchemaResolver;
import io.apicurio.registry.resolver.ParsedSchema;
import io.apicurio.registry.resolver.ParsedSchemaImpl;
import io.apicurio.registry.resolver.SchemaLookupResult;
import io.apicurio.registry.resolver.SchemaParser;
import io.apicurio.registry.resolver.cache.ContentWithReferences;
import io.apicurio.registry.resolver.client.RegistryArtifactReference;
import io.apicurio.registry.resolver.client.RegistryClientFacade;
import io.apicurio.registry.resolver.client.RegistryVersionCoordinates;
import io.apicurio.registry.resolver.data.Record;
import io.apicurio.registry.resolver.strategy.ArtifactCoordinates;
import io.apicurio.registry.resolver.strategy.ArtifactReference;
import io.apicurio.registry.resolver.strategy.ArtifactReferenceImpl;
import io.apicurio.registry.utils.IoUtil;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class DefaultSchemaResolver<S, T>
extends AbstractSchemaResolver<S, T> {
    private boolean autoCreateArtifact;
    private String autoCreateBehavior;
    private boolean findLatest;
    private boolean canonicalize;
    private static final Logger logger = Logger.getLogger(DefaultSchemaResolver.class.getSimpleName());

    public DefaultSchemaResolver() {
    }

    public DefaultSchemaResolver(RegistryClientFacade clientFacade) {
        this.clientFacade = clientFacade;
    }

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    public void configure(Map<String, ?> configs, SchemaParser<S, T> schemaParser) {
        super.configure(configs, schemaParser);
        if (this.artifactResolverStrategy.loadSchema() && !schemaParser.supportsExtractSchemaFromData()) {
            throw new IllegalStateException("Wrong configuration");
        }
        this.autoCreateArtifact = this.config.autoRegisterArtifact();
        this.autoCreateBehavior = this.config.autoRegisterArtifactIfExists();
        this.findLatest = this.config.findLatest();
        this.canonicalize = this.config.isCanonicalize();
    }

    @Override
    public SchemaLookupResult<S> resolveSchema(Record<T> data) {
        Objects.requireNonNull(data);
        Objects.requireNonNull(data.payload());
        ParsedSchema parsedSchema = this.artifactResolverStrategy.loadSchema() && this.schemaParser.supportsExtractSchemaFromData() ? this.schemaParser.getSchemaFromData(data, this.resolveDereferenced) : null;
        ArtifactReference artifactReference = this.resolveArtifactReference(data, parsedSchema, false, null);
        return this.getSchemaFromCache(artifactReference).orElseGet(() -> this.getSchemaFromRegistry(parsedSchema, data, artifactReference));
    }

    private Optional<SchemaLookupResult<S>> getSchemaFromCache(ArtifactReference artifactReference) {
        if (artifactReference.getGlobalId() != null && this.schemaCache.containsByGlobalId(artifactReference.getGlobalId())) {
            return Optional.of(this.resolveSchemaByGlobalId(artifactReference.getGlobalId()));
        }
        if (artifactReference.getContentId() != null && this.schemaCache.containsByContentId(artifactReference.getContentId())) {
            return Optional.of(this.resolveSchemaByContentId(artifactReference.getContentId()));
        }
        if (artifactReference.getContentHash() != null && this.schemaCache.containsByContentHash(artifactReference.getContentHash())) {
            return Optional.of(this.resolveSchemaByContentHash(artifactReference.getContentHash()));
        }
        if (this.schemaCache.containsByArtifactCoordinates(ArtifactCoordinates.fromArtifactReference(artifactReference))) {
            return Optional.of(this.resolveSchemaByArtifactCoordinatesCached(ArtifactCoordinates.fromArtifactReference(artifactReference)));
        }
        return Optional.empty();
    }

    private SchemaLookupResult<S> getSchemaFromRegistry(ParsedSchema<S> parsedSchema, Record<T> data, ArtifactReference artifactReference) {
        if (this.autoCreateArtifact) {
            if (this.schemaParser.supportsExtractSchemaFromData()) {
                if (parsedSchema == null) {
                    parsedSchema = this.schemaParser.getSchemaFromData(data, this.resolveDereferenced);
                }
                List<SchemaLookupResult<S>> schemaLookupResults = List.of();
                if (parsedSchema.hasReferences()) {
                    schemaLookupResults = this.handleArtifactReferences(data, parsedSchema);
                }
                return this.handleAutoCreateArtifact(parsedSchema, artifactReference, schemaLookupResults);
            }
            if (this.config.getExplicitSchemaLocation() != null && this.schemaParser.supportsGetSchemaFromLocation()) {
                parsedSchema = this.schemaParser.getSchemaFromLocation(this.config.getExplicitSchemaLocation());
                return this.handleAutoCreateArtifact(parsedSchema, artifactReference, List.of());
            }
        }
        if (this.findLatest || artifactReference.getVersion() != null) {
            return this.resolveSchemaByCoordinates(artifactReference.getGroupId(), artifactReference.getArtifactId(), artifactReference.getVersion());
        }
        if (this.schemaParser.supportsExtractSchemaFromData()) {
            if (parsedSchema == null) {
                parsedSchema = this.schemaParser.getSchemaFromData(data, this.resolveDereferenced);
            }
            return this.handleResolveSchemaByContent(parsedSchema, artifactReference);
        }
        return this.resolveSchemaByCoordinates(artifactReference.getGroupId(), artifactReference.getArtifactId(), artifactReference.getVersion());
    }

    private List<SchemaLookupResult<S>> handleArtifactReferences(Record<T> data, ParsedSchema<S> parsedSchema) {
        ArrayList<SchemaLookupResult<S>> referencesLookup = new ArrayList<SchemaLookupResult<S>>();
        for (ParsedSchema<S> referencedSchema : parsedSchema.getSchemaReferences()) {
            List<SchemaLookupResult<S>> nestedReferences = this.handleArtifactReferences(data, referencedSchema);
            referencesLookup.add(this.handleAutoCreateArtifact(referencedSchema, this.resolveArtifactReference(data, referencedSchema, true, referencedSchema.referenceName()), nestedReferences));
        }
        return referencesLookup;
    }

    @Override
    public SchemaLookupResult<S> resolveSchemaByArtifactReference(ArtifactReference reference) {
        if (reference == null) {
            throw new IllegalStateException("artifact reference cannot be null");
        }
        if (reference.getContentId() != null) {
            return this.resolveSchemaByContentId(reference.getContentId());
        }
        if (reference.getContentHash() != null) {
            return this.resolveSchemaByContentHash(reference.getContentHash());
        }
        if (reference.getGlobalId() != null) {
            return this.resolveSchemaByGlobalId(reference.getGlobalId());
        }
        return this.resolveSchemaByCoordinates(reference.getGroupId(), reference.getArtifactId(), reference.getVersion());
    }

    private SchemaLookupResult<S> resolveSchemaByCoordinates(String groupId, String artifactId, String version) {
        if (artifactId == null) {
            throw new IllegalStateException("artifactId cannot be null");
        }
        ArtifactReferenceImpl reference = ArtifactReference.builder().groupId(groupId).artifactId(artifactId).version(version).build();
        return this.resolveSchemaByArtifactReferenceCached(reference);
    }

    protected SchemaLookupResult<S> resolveSchemaByContentId(long contentId) {
        return this.schemaCache.getByContentId(contentId, contentIdKey -> {
            ParsedSchemaImpl ps = null;
            String rawSchema = this.clientFacade.getSchemaByContentId((Long)contentIdKey);
            List<RegistryArtifactReference> artifactReferences = this.clientFacade.getReferencesByContentId(contentId);
            Map resolvedReferences = this.resolveReferences(artifactReferences);
            byte[] schema = rawSchema.getBytes(StandardCharsets.UTF_8);
            Object parsed = this.schemaParser.parseSchema(schema, resolvedReferences);
            ps = new ParsedSchemaImpl().setParsedSchema(parsed).setRawSchema(schema);
            SchemaLookupResult.SchemaLookupResultBuilder result = SchemaLookupResult.builder();
            return result.contentId((long)contentIdKey).parsedSchema(ps).build();
        });
    }

    protected SchemaLookupResult<S> resolveSchemaByContentHash(String contentHash) {
        return this.schemaCache.getByContentHash(contentHash, contentHashKey -> {
            ParsedSchemaImpl ps = null;
            String rawSchema = this.clientFacade.getSchemaByContentHash((String)contentHashKey);
            List<RegistryArtifactReference> artifactReferences = this.clientFacade.getReferencesByContentHash((String)contentHashKey);
            Map resolvedReferences = this.resolveReferences(artifactReferences);
            byte[] schema = rawSchema.getBytes(StandardCharsets.UTF_8);
            Object parsed = this.schemaParser.parseSchema(schema, resolvedReferences);
            ps = new ParsedSchemaImpl().setParsedSchema(parsed).setRawSchema(schema);
            SchemaLookupResult.SchemaLookupResultBuilder result = SchemaLookupResult.builder();
            return result.contentHash((String)contentHashKey).parsedSchema(ps).build();
        });
    }

    private SchemaLookupResult<S> handleResolveSchemaByContent(ParsedSchema<S> parsedSchema, ArtifactReference artifactReference) {
        String rawSchemaString = IoUtil.toString((byte[])parsedSchema.getRawSchema());
        return this.schemaCache.getByContent(ContentWithReferences.builder().content(rawSchemaString).build(), contentKey -> {
            logger.info(String.format("Retrieving schema content using string: %s", rawSchemaString));
            String artifactType = this.schemaParser.artifactType();
            List<RegistryVersionCoordinates> versions = this.clientFacade.searchVersionsByContent(rawSchemaString, artifactType, artifactReference, this.canonicalize);
            if (versions.isEmpty()) {
                throw new RuntimeException(String.format("Could not resolve artifact reference by content: %s", rawSchemaString) + "&" + String.valueOf(artifactReference));
            }
            SchemaLookupResult.SchemaLookupResultBuilder result = SchemaLookupResult.builder();
            this.loadFromVersionCoordinates(versions.get(0), result);
            result.parsedSchema(parsedSchema);
            return result.build();
        });
    }

    private SchemaLookupResult<S> handleAutoCreateArtifact(ParsedSchema<S> parsedSchema, ArtifactReference artifactReference, List<SchemaLookupResult<S>> referenceLookups) {
        Objects.requireNonNull(referenceLookups);
        String rawSchemaString = IoUtil.toString((byte[])parsedSchema.getRawSchema());
        Set<ArtifactReference> references = referenceLookups.stream().map(SchemaLookupResult::toArtifactReference).collect(Collectors.toSet());
        ContentWithReferences key = ContentWithReferences.builder().content(rawSchemaString).references(references).build();
        return this.schemaCache.getByContent(key, contentKey -> {
            String artifactType = this.schemaParser.artifactType();
            String groupId = artifactReference.getGroupId() == null ? "default" : artifactReference.getGroupId();
            String artifactId = artifactReference.getArtifactId();
            String version = artifactReference.getVersion();
            String autoCreate = this.autoCreateBehavior;
            Set<RegistryArtifactReference> clientReferences = referenceLookups.stream().map(RegistryArtifactReference::fromSchemaLookupResult).collect(Collectors.toSet());
            RegistryVersionCoordinates versionCoordinates = this.clientFacade.createSchema(artifactType, groupId, artifactId, version, autoCreate, this.canonicalize, rawSchemaString, clientReferences);
            SchemaLookupResult.SchemaLookupResultBuilder result = SchemaLookupResult.builder();
            this.loadFromVersionCoordinates(versionCoordinates, result);
            result.parsedSchema(parsedSchema);
            return result.build();
        });
    }

    private SchemaLookupResult<S> resolveSchemaByArtifactCoordinatesCached(ArtifactCoordinates artifactCoordinates) {
        return this.schemaCache.getByArtifactCoordinates(artifactCoordinates, artifactCoordinatesKey -> this.resolveByCoordinates(artifactCoordinatesKey.getGroupId(), artifactCoordinatesKey.getArtifactId(), artifactCoordinatesKey.getVersion()));
    }

    private SchemaLookupResult<S> resolveSchemaByArtifactReferenceCached(ArtifactReference artifactReference) {
        if (artifactReference.getGlobalId() != null) {
            return this.schemaCache.getByGlobalId(artifactReference.getGlobalId(), this::resolveSchemaByGlobalId);
        }
        if (artifactReference.getContentId() != null) {
            return this.schemaCache.getByContentId(artifactReference.getContentId(), this::resolveSchemaByContentId);
        }
        if (artifactReference.getContentHash() != null) {
            return this.schemaCache.getByContentHash(artifactReference.getContentHash(), this::resolveSchemaByContentHash);
        }
        return this.schemaCache.getByArtifactCoordinates(ArtifactCoordinates.fromArtifactReference(artifactReference), artifactReferenceKey -> this.resolveByCoordinates(artifactReferenceKey.getGroupId(), artifactReferenceKey.getArtifactId(), artifactReferenceKey.getVersion()));
    }

    private SchemaLookupResult<S> resolveByCoordinates(String groupId, String artifactId, String version) {
        SchemaLookupResult.SchemaLookupResultBuilder result = SchemaLookupResult.builder();
        RegistryVersionCoordinates versionCoordinates = this.clientFacade.getVersionCoordinatesByGAV(groupId, artifactId, version);
        this.loadFromVersionCoordinates(versionCoordinates, result);
        String schemaString = this.clientFacade.getSchemaByGlobalId(versionCoordinates.getGlobalId(), this.resolveDereferenced);
        Map resolvedReferences = new HashMap();
        if (!this.resolveDereferenced) {
            List<RegistryArtifactReference> artifactReferences = this.clientFacade.getReferencesByGlobalId(versionCoordinates.getGlobalId());
            resolvedReferences = this.resolveReferences(artifactReferences);
        }
        byte[] schema = schemaString.getBytes(StandardCharsets.UTF_8);
        Object parsed = this.schemaParser.parseSchema(schema, resolvedReferences);
        result.parsedSchema(new ParsedSchemaImpl().setParsedSchema(parsed).setRawSchema(schema));
        return result.build();
    }
}

