/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.resolver;

import io.apicurio.registry.resolver.ParsedSchema;
import io.apicurio.registry.resolver.ParsedSchemaImpl;
import io.apicurio.registry.resolver.SchemaLookupResult;
import io.apicurio.registry.resolver.SchemaParser;
import io.apicurio.registry.resolver.SchemaResolver;
import io.apicurio.registry.resolver.cache.ContentWithReferences;
import io.apicurio.registry.resolver.cache.ERCache;
import io.apicurio.registry.resolver.client.RegistryArtifactReference;
import io.apicurio.registry.resolver.client.RegistryClientFacade;
import io.apicurio.registry.resolver.client.RegistryClientFacadeFactory;
import io.apicurio.registry.resolver.client.RegistryVersionCoordinates;
import io.apicurio.registry.resolver.config.SchemaResolverConfig;
import io.apicurio.registry.resolver.data.Record;
import io.apicurio.registry.resolver.strategy.ArtifactReference;
import io.apicurio.registry.resolver.strategy.ArtifactReferenceResolverStrategy;
import io.apicurio.registry.resolver.utils.Utils;
import io.apicurio.registry.utils.IoUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractSchemaResolver<S, T>
implements SchemaResolver<S, T> {
    protected final ERCache<SchemaLookupResult<S>> schemaCache = new ERCache();
    protected SchemaResolverConfig config;
    protected SchemaParser<S, T> schemaParser;
    protected RegistryClientFacade clientFacade;
    protected ArtifactReferenceResolverStrategy<S, T> artifactResolverStrategy;
    protected String explicitArtifactGroupId;
    protected String explicitArtifactId;
    protected String explicitArtifactVersion;
    protected boolean resolveDereferenced;

    @Override
    public void configure(Map<String, ?> configs, SchemaParser<S, T> schemaParser) {
        String artifactVersionOverride;
        String artifactIdOverride;
        this.schemaParser = schemaParser;
        this.config = new SchemaResolverConfig(configs);
        if (this.clientFacade == null) {
            this.clientFacade = RegistryClientFacadeFactory.create(this.config);
        }
        Object ais = this.config.getArtifactResolverStrategy();
        Utils.instantiate(ArtifactReferenceResolverStrategy.class, ais, this::setArtifactResolverStrategy);
        this.schemaCache.configureLifetime(this.config.getCheckPeriod());
        this.schemaCache.configureRetryBackoff(this.config.getRetryBackoff());
        this.schemaCache.configureRetryCount(this.config.getRetryCount());
        this.schemaCache.configureCacheLatest(this.config.getCacheLatest());
        this.schemaCache.configureFaultTolerantRefresh(this.config.getFaultTolerantRefresh());
        this.schemaCache.configureGlobalIdKeyExtractor(SchemaLookupResult::getGlobalId);
        this.schemaCache.configureContentKeyExtractor(schema -> {
            byte[] rawSchema = schema.getParsedSchema().getRawSchema();
            if (rawSchema != null) {
                return ContentWithReferences.builder().content(IoUtil.toString((byte[])rawSchema)).build();
            }
            return null;
        });
        this.schemaCache.configureContentIdKeyExtractor(SchemaLookupResult::getContentId);
        this.schemaCache.configureContentHashKeyExtractor(SchemaLookupResult::getContentHash);
        this.schemaCache.configureArtifactCoordinatesKeyExtractor(SchemaLookupResult::toArtifactCoordinates);
        this.schemaCache.checkInitialized();
        String groupIdOverride = this.config.getExplicitArtifactGroupId();
        if (groupIdOverride != null) {
            this.explicitArtifactGroupId = groupIdOverride;
        }
        if ((artifactIdOverride = this.config.getExplicitArtifactId()) != null) {
            this.explicitArtifactId = artifactIdOverride;
        }
        if ((artifactVersionOverride = this.config.getExplicitArtifactVersion()) != null) {
            this.explicitArtifactVersion = artifactVersionOverride;
        }
        this.resolveDereferenced = this.config.resolveDereferenced();
    }

    @Override
    public void setClientFacade(RegistryClientFacade clientFacade) {
        this.clientFacade = clientFacade;
    }

    @Override
    public void setArtifactResolverStrategy(ArtifactReferenceResolverStrategy<S, T> artifactResolverStrategy) {
        this.artifactResolverStrategy = artifactResolverStrategy;
    }

    @Override
    public SchemaParser<S, T> getSchemaParser() {
        return this.schemaParser;
    }

    protected ArtifactReference resolveArtifactReference(Record<T> data, ParsedSchema<S> parsedSchema, boolean isReference, String referenceArtifactId) {
        ArtifactReference artifactReference = this.artifactResolverStrategy.artifactReference(data, parsedSchema);
        artifactReference = ArtifactReference.builder().groupId(this.explicitArtifactGroupId == null ? artifactReference.getGroupId() : this.explicitArtifactGroupId).artifactId(this.resolveArtifactId(artifactReference.getArtifactId(), isReference, referenceArtifactId)).version(this.explicitArtifactVersion == null ? artifactReference.getVersion() : this.explicitArtifactVersion).build();
        return artifactReference;
    }

    protected String resolveArtifactId(String artifactId, boolean isReference, String referenceArtifactId) {
        if (isReference) {
            return referenceArtifactId;
        }
        return this.explicitArtifactId == null ? artifactId : this.explicitArtifactId;
    }

    protected SchemaLookupResult<S> resolveSchemaByGlobalId(long globalId) {
        return this.schemaCache.getByGlobalId(globalId, globalIdKey -> {
            if (this.resolveDereferenced) {
                return this.resolveSchemaDereferenced((long)globalIdKey);
            }
            return this.resolveSchemaWithReferences((long)globalIdKey);
        });
    }

    private SchemaLookupResult<S> resolveSchemaDereferenced(long globalId) {
        String rawSchema = this.clientFacade.getSchemaByGlobalId(globalId, true);
        byte[] schema = rawSchema.getBytes(StandardCharsets.UTF_8);
        S parsed = this.schemaParser.parseSchema(schema, Collections.emptyMap());
        ParsedSchemaImpl ps = new ParsedSchemaImpl<S>().setParsedSchema(parsed).setRawSchema(schema);
        SchemaLookupResult.SchemaLookupResultBuilder result = SchemaLookupResult.builder();
        return result.globalId(globalId).parsedSchema(ps).build();
    }

    private SchemaLookupResult<S> resolveSchemaWithReferences(long globalId) {
        String rawSchema = this.clientFacade.getSchemaByGlobalId(globalId, false);
        List<RegistryArtifactReference> artifactReferences = this.clientFacade.getReferencesByGlobalId(globalId);
        Map<String, ParsedSchema<S>> resolvedReferences = this.resolveReferences(artifactReferences);
        byte[] schema = rawSchema.getBytes(StandardCharsets.UTF_8);
        S parsed = this.schemaParser.parseSchema(schema, resolvedReferences);
        ParsedSchemaImpl ps = new ParsedSchemaImpl<S>().setParsedSchema(parsed).setSchemaReferences(new ArrayList(resolvedReferences.values())).setRawSchema(schema);
        SchemaLookupResult.SchemaLookupResultBuilder result = SchemaLookupResult.builder();
        return result.globalId(globalId).parsedSchema(ps).build();
    }

    protected Map<String, ParsedSchema<S>> resolveReferences(List<RegistryArtifactReference> artifactReferences) {
        HashMap<String, ParsedSchema<S>> resolvedReferences = new HashMap<String, ParsedSchema<S>>();
        artifactReferences.forEach(reference -> {
            String groupId = reference.getGroupId() == null ? "default" : reference.getGroupId();
            String artifactId = reference.getArtifactId();
            String version = reference.getVersion();
            String referenceContent = this.clientFacade.getSchemaByGAV(groupId, artifactId, version);
            List<RegistryArtifactReference> referenceReferences = this.clientFacade.getReferencesByGAV(groupId, artifactId, version);
            if (!referenceReferences.isEmpty()) {
                Map<String, ParsedSchema<S>> nestedReferences = this.resolveReferences(referenceReferences);
                resolvedReferences.putAll(nestedReferences);
                resolvedReferences.put(reference.getName(), this.parseSchemaFromStream(reference.getName(), referenceContent, this.resolveReferences(referenceReferences)));
            } else {
                resolvedReferences.put(reference.getName(), this.parseSchemaFromStream(reference.getName(), referenceContent, Collections.emptyMap()));
            }
        });
        return resolvedReferences;
    }

    private ParsedSchema<S> parseSchemaFromStream(String name, String rawSchema, Map<String, ParsedSchema<S>> resolvedReferences) {
        byte[] schema = rawSchema.getBytes(StandardCharsets.UTF_8);
        S parsed = this.schemaParser.parseSchema(schema, resolvedReferences);
        return new ParsedSchemaImpl<S>().setParsedSchema(parsed).setSchemaReferences(new ArrayList(resolvedReferences.values())).setReferenceName(name).setRawSchema(schema);
    }

    @Override
    public void reset() {
        this.schemaCache.clear();
    }

    @Override
    public void close() throws IOException {
        try {
            this.clientFacade.close();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    protected void loadFromVersionCoordinates(RegistryVersionCoordinates version, SchemaLookupResult.SchemaLookupResultBuilder<S> resultBuilder) {
        resultBuilder.globalId(version.getGlobalId());
        resultBuilder.contentId(version.getContentId());
        resultBuilder.groupId(version.getGroupId());
        resultBuilder.artifactId(version.getArtifactId());
        resultBuilder.version(String.valueOf(version.getVersion()));
    }
}

