/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.model;

import jakarta.validation.ValidationException;
import java.util.regex.Pattern;
import lombok.Generated;

public class VersionId {
    private static final Pattern VALID_PATTERN = Pattern.compile("[a-zA-Z0-9._\\-+]{1,256}");
    private final String rawVersionId;

    public VersionId(String rawVersionId) {
        if (!VersionId.isValid(rawVersionId)) {
            throw new ValidationException("Version ID '" + rawVersionId + "' is invalid. It must consist of alphanumeric characters or '._-+', and have length 1..256 (inclusive).");
        }
        this.rawVersionId = rawVersionId;
    }

    public String toString() {
        return this.rawVersionId;
    }

    public static boolean isValid(String rawVersionId) {
        return rawVersionId != null && VALID_PATTERN.matcher(rawVersionId).matches();
    }

    @Generated
    public String getRawVersionId() {
        return this.rawVersionId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VersionId)) {
            return false;
        }
        VersionId other = (VersionId)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$rawVersionId = this.getRawVersionId();
        String other$rawVersionId = other.getRawVersionId();
        return !(this$rawVersionId == null ? other$rawVersionId != null : !this$rawVersionId.equals(other$rawVersionId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof VersionId;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $rawVersionId = this.getRawVersionId();
        result = result * 59 + ($rawVersionId == null ? 43 : $rawVersionId.hashCode());
        return result;
    }
}

